/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CloseMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CloseProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CorrelateProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.MessageHeaderDecoder;
import io.camunda.zeebe.engine.processing.message.command.OpenMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.OpenProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class SubscriptionCommandMessageHandler
implements Function<byte[], CompletableFuture<Void>> {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenProcessMessageSubscriptionCommand openProcessMessageSubscriptionCommand = new OpenProcessMessageSubscriptionCommand();
    private final CorrelateProcessMessageSubscriptionCommand correlateProcessMessageSubscriptionCommand = new CorrelateProcessMessageSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseProcessMessageSubscriptionCommand closeProcessMessageSubscriptionCommand = new CloseProcessMessageSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand resetMessageCorrelationCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final RecordMetadata recordMetadata = new RecordMetadata();
    private final MessageSubscriptionRecord messageSubscriptionRecord = new MessageSubscriptionRecord();
    private final ProcessMessageSubscriptionRecord processMessageSubscriptionRecord = new ProcessMessageSubscriptionRecord();
    private final Consumer<Runnable> enviromentToRun;
    private final IntFunction<LogStreamRecordWriter> logstreamRecordWriterSupplier;

    public SubscriptionCommandMessageHandler(Consumer<Runnable> enviromentToRun, IntFunction<LogStreamRecordWriter> logstreamRecordWriterSupplier) {
        this.enviromentToRun = enviromentToRun;
        this.logstreamRecordWriterSupplier = logstreamRecordWriterSupplier;
    }

    @Override
    public CompletableFuture<Void> apply(byte[] bytes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.enviromentToRun.accept(() -> {
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            boolean offset = false;
            int length = buffer.capacity();
            this.messageHeaderDecoder.wrap((DirectBuffer)buffer, 0);
            if (this.messageHeaderDecoder.schemaId() == 6) {
                switch (this.messageHeaderDecoder.templateId()) {
                    case 0: {
                        this.onOpenMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 1: {
                        this.onOpenProcessMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 2: {
                        this.onCorrelateProcessMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 3: {
                        this.onCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 4: {
                        this.onCloseMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 5: {
                        this.onCloseProcessMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 6: {
                        this.onRejectCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                }
            }
            future.complete(null);
        });
        return future;
    }

    private boolean onOpenMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.openMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.setProcessInstanceKey(this.openMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.openMessageSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.openMessageSubscriptionCommand.getBpmnProcessId()).setMessageKey(-1L).setMessageName(this.openMessageSubscriptionCommand.getMessageName()).setCorrelationKey(this.openMessageSubscriptionCommand.getCorrelationKey()).setInterrupting(this.openMessageSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(this.openMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onOpenProcessMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.openProcessMessageSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.openProcessMessageSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processMessageSubscriptionRecord.reset();
        this.processMessageSubscriptionRecord.setSubscriptionPartitionId(this.openProcessMessageSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.openProcessMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.openProcessMessageSubscriptionCommand.getMessageName()).setInterrupting(this.openProcessMessageSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, (UnpackedObject)this.processMessageSubscriptionRecord);
    }

    private boolean onCorrelateProcessMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateProcessMessageSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.correlateProcessMessageSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processMessageSubscriptionRecord.setSubscriptionPartitionId(this.correlateProcessMessageSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.correlateProcessMessageSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.correlateProcessMessageSubscriptionCommand.getBpmnProcessId()).setMessageKey(this.correlateProcessMessageSubscriptionCommand.getMessageKey()).setMessageName(this.correlateProcessMessageSubscriptionCommand.getMessageName()).setVariables(this.correlateProcessMessageSubscriptionCommand.getVariables()).setCorrelationKey(this.correlateProcessMessageSubscriptionCommand.getCorrelationKey());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, (UnpackedObject)this.processMessageSubscriptionRecord);
    }

    private boolean onCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(this.correlateMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.correlateMessageSubscriptionCommand.getElementInstanceKey()).setBpmnProcessId(this.correlateMessageSubscriptionCommand.getBpmnProcessId()).setMessageKey(-1L).setMessageName(this.correlateMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.correlateMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(this.closeMessageSubscriptionCommand.getProcessInstanceKey()).setElementInstanceKey(this.closeMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.closeMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseProcessMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeProcessMessageSubscriptionCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.closeProcessMessageSubscriptionCommand.getProcessInstanceKey();
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.processMessageSubscriptionRecord.reset();
        this.processMessageSubscriptionRecord.setSubscriptionPartitionId(this.closeProcessMessageSubscriptionCommand.getSubscriptionPartitionId()).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(this.closeProcessMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeProcessMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(processInstancePartitionId, ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, (UnpackedObject)this.processMessageSubscriptionRecord);
    }

    private boolean onRejectCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.resetMessageCorrelationCommand.wrap(buffer, offset, length);
        long processInstanceKey = this.resetMessageCorrelationCommand.getProcessInstanceKey();
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setProcessInstanceKey(processInstanceKey).setElementInstanceKey(-1L).setBpmnProcessId(this.resetMessageCorrelationCommand.getBpmnProcessId()).setMessageName(this.resetMessageCorrelationCommand.getMessageName()).setCorrelationKey(this.resetMessageCorrelationCommand.getCorrelationKey()).setMessageKey(this.resetMessageCorrelationCommand.getMessageKey()).setInterrupting(false);
        return this.writeCommand(this.resetMessageCorrelationCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean writeCommand(int partitionId, ValueType valueType, Intent intent, UnpackedObject command) {
        LogStreamRecordWriter logStreamRecordWriter = this.logstreamRecordWriterSupplier.apply(partitionId);
        if (logStreamRecordWriter == null) {
            return true;
        }
        logStreamRecordWriter.reset();
        this.recordMetadata.reset().recordType(RecordType.COMMAND).valueType(valueType).intent(intent);
        long position = logStreamRecordWriter.key(-1L).metadataWriter((BufferWriter)this.recordMetadata).valueWriter((BufferWriter)command).tryWrite();
        return position > 0L;
    }
}

