/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.msgpack.spec.MsgpackReaderException;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class CreateProcessInstanceProcessor
implements CommandProcessor<ProcessInstanceCreationRecord> {
    private static final String ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED = "Expected at least a bpmnProcessId or a key greater than -1, but none given";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS = "Expected to find process definition with process ID '%s', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION = "Expected to find process definition with process ID '%s' and version '%d', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_KEY = "Expected to find process definition with key '%d', but none found";
    private static final String ERROR_MESSAGE_NO_NONE_START_EVENT = "Expected to create instance of process with none start event, but there is no such event";
    private static final String ERROR_INVALID_VARIABLES_REJECTION_MESSAGE = "Expected to set variables from document, but the document is invalid: '%s'";
    private static final String ERROR_INVALID_VARIABLES_LOGGED_MESSAGE = "Expected to set variables from document, but the document is invalid";
    private final ProcessInstanceRecord newProcessInstance = new ProcessInstanceRecord();
    private final ProcessState processState;
    private final VariableBehavior variableBehavior;
    private final KeyGenerator keyGenerator;
    private final TypedCommandWriter commandWriter;

    public CreateProcessInstanceProcessor(ProcessState processState, KeyGenerator keyGenerator, Writers writers, VariableBehavior variableBehavior) {
        this.processState = processState;
        this.variableBehavior = variableBehavior;
        this.keyGenerator = keyGenerator;
        this.commandWriter = writers.command();
    }

    @Override
    public boolean onCommand(TypedRecord<ProcessInstanceCreationRecord> command, CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller) {
        ProcessInstanceCreationRecord record = command.getValue();
        DeployedProcess process = this.getProcess(record, controller);
        if (process == null || !this.isValidProcess(controller, process)) {
            return true;
        }
        long processInstanceKey = this.keyGenerator.nextKey();
        if (!this.setVariablesFromDocument(controller, record, process.getKey(), processInstanceKey)) {
            return true;
        }
        ProcessInstanceRecord processInstance = this.initProcessInstanceRecord(process, processInstanceKey);
        this.commandWriter.appendFollowUpCommand(processInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)processInstance);
        record.setProcessInstanceKey(processInstanceKey).setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey());
        controller.accept((Intent)ProcessInstanceCreationIntent.CREATED, record);
        return true;
    }

    private boolean isValidProcess(CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller, DeployedProcess process) {
        if (process.getProcess().getNoneStartEvent() == null) {
            controller.reject(RejectionType.INVALID_STATE, ERROR_MESSAGE_NO_NONE_START_EVENT);
            return false;
        }
        return true;
    }

    private boolean setVariablesFromDocument(CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller, ProcessInstanceCreationRecord record, long processDefinitionKey, long processInstanceKey) {
        try {
            this.variableBehavior.mergeLocalDocument(processInstanceKey, processDefinitionKey, processInstanceKey, record.getVariablesBuffer());
        }
        catch (MsgpackReaderException e) {
            Loggers.PROCESS_PROCESSOR_LOGGER.error(ERROR_INVALID_VARIABLES_LOGGED_MESSAGE, (Throwable)e);
            controller.reject(RejectionType.INVALID_ARGUMENT, String.format(ERROR_INVALID_VARIABLES_REJECTION_MESSAGE, e.getMessage()));
            return false;
        }
        return true;
    }

    private ProcessInstanceRecord initProcessInstanceRecord(DeployedProcess process, long processInstanceKey) {
        this.newProcessInstance.reset();
        this.newProcessInstance.setBpmnProcessId(process.getBpmnProcessId());
        this.newProcessInstance.setVersion(process.getVersion());
        this.newProcessInstance.setProcessDefinitionKey(process.getKey());
        this.newProcessInstance.setProcessInstanceKey(processInstanceKey);
        this.newProcessInstance.setBpmnElementType(BpmnElementType.PROCESS);
        this.newProcessInstance.setElementId(process.getProcess().getId());
        this.newProcessInstance.setFlowScopeKey(-1L);
        return this.newProcessInstance;
    }

    private DeployedProcess getProcess(ProcessInstanceCreationRecord record, CommandProcessor.CommandControl controller) {
        DeployedProcess process;
        DirectBuffer bpmnProcessId = record.getBpmnProcessIdBuffer();
        if (bpmnProcessId.capacity() > 0) {
            process = record.getVersion() >= 0 ? this.getProcess(bpmnProcessId, record.getVersion(), controller) : this.getProcess(bpmnProcessId, controller);
        } else if (record.getProcessDefinitionKey() >= 0L) {
            process = this.getProcess(record.getProcessDefinitionKey(), controller);
        } else {
            controller.reject(RejectionType.INVALID_ARGUMENT, ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED);
            process = null;
        }
        return process;
    }

    private DeployedProcess getProcess(DirectBuffer bpmnProcessId, CommandProcessor.CommandControl controller) {
        DeployedProcess process = this.processState.getLatestProcessVersionByProcessId(bpmnProcessId);
        if (process == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId)));
        }
        return process;
    }

    private DeployedProcess getProcess(DirectBuffer bpmnProcessId, int version, CommandProcessor.CommandControl controller) {
        DeployedProcess process = this.processState.getProcessByProcessIdAndVersion(bpmnProcessId, version);
        if (process == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId), version));
        }
        return process;
    }

    private DeployedProcess getProcess(long key, CommandProcessor.CommandControl controller) {
        DeployedProcess process = this.processState.getProcessByKey(key);
        if (process == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_KEY, key));
        }
        return process;
    }
}

