/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;

public final class ProcessInstanceCommandContext {
    private final MutableElementInstanceState elementInstanceState;
    private TypedRecord<ProcessInstanceRecord> record;
    private ElementInstance elementInstance;
    private TypedResponseWriter responseWriter;
    private TypedStreamWriter streamWriter;

    public ProcessInstanceCommandContext(MutableElementInstanceState elementInstanceState) {
        this.elementInstanceState = elementInstanceState;
    }

    public ProcessInstanceIntent getCommand() {
        return (ProcessInstanceIntent)this.record.getIntent();
    }

    public TypedRecord<ProcessInstanceRecord> getRecord() {
        return this.record;
    }

    public void setRecord(TypedRecord<ProcessInstanceRecord> record) {
        this.record = record;
    }

    public ElementInstance getElementInstance() {
        return this.elementInstance;
    }

    public void setElementInstance(ElementInstance elementInstance) {
        this.elementInstance = elementInstance;
    }

    public TypedResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(TypedResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public MutableElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    public void reject(RejectionType rejectionType, String reason) {
        this.streamWriter.appendRejection(this.record, rejectionType, reason);
        this.responseWriter.writeRejectionOnCommand(this.record, rejectionType, reason);
    }

    public TypedStreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    public void setStreamWriter(TypedStreamWriter writer) {
        this.streamWriter = writer;
    }
}

