/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;

public final class ProcessMessageSubscriptionCorrelatedApplier
implements TypedEventApplier<ProcessMessageSubscriptionIntent, ProcessMessageSubscriptionRecord> {
    private final MutableProcessMessageSubscriptionState subscriptionState;
    private final MutableVariableState variableState;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;

    public ProcessMessageSubscriptionCorrelatedApplier(MutableProcessMessageSubscriptionState subscriptionState, MutableVariableState variableState, ElementInstanceState elementInstanceState, ProcessState processState) {
        this.subscriptionState = subscriptionState;
        this.variableState = variableState;
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
    }

    @Override
    public void applyState(long key, ProcessMessageSubscriptionRecord value) {
        long eventScopeKey = value.getElementInstanceKey();
        if (value.isInterrupting()) {
            this.subscriptionState.remove(eventScopeKey, value.getMessageNameBuffer());
        } else {
            this.subscriptionState.updateToOpenedState(value);
        }
        if (this.shouldCreateTemporaryVariables(value)) {
            this.variableState.setTemporaryVariables(eventScopeKey, value.getVariablesBuffer());
        }
    }

    private boolean shouldCreateTemporaryVariables(ProcessMessageSubscriptionRecord value) {
        if (value.getVariablesBuffer().capacity() <= 0) {
            return false;
        }
        long eventScopeKey = value.getElementInstanceKey();
        ElementInstance eventScopeInstance = this.elementInstanceState.getInstance(eventScopeKey);
        if (eventScopeInstance == null) {
            return false;
        }
        ExecutableFlowElement eventElement = this.processState.getFlowElement(eventScopeInstance.getValue().getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowElement.class);
        if (eventElement == null) {
            return false;
        }
        switch (eventElement.getElementType()) {
            case INTERMEDIATE_CATCH_EVENT: 
            case RECEIVE_TASK: 
            case START_EVENT: {
                return true;
            }
        }
        return false;
    }
}

