/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import org.agrona.DirectBuffer;

public class DbMigrationState
implements MutableMigrationState {
    private final DbLong messageSubscriptionSentTime;
    private final DbLong messageSubscriptionElementInstanceKey = new DbLong();
    private final DbString messageSubscriptionMessageName = new DbString();
    private final DbCompositeKey<DbLong, DbString> messageSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.messageSubscriptionElementInstanceKey, (DbKey)this.messageSubscriptionMessageName);
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> messageSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> messageSubscriptionSentTimeColumnFamily;
    private final DbLong processSubscriptionSentTime;
    private final DbLong processSubscriptionElementInstanceKey;
    private final DbString processSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> processSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> processSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> processSubscriptionSentTimeColumnFamily;

    public DbMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageSubscriptionSentTime = new DbLong();
        this.messageSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.messageSubscriptionSentTime, this.messageSubscriptionElementKeyAndMessageName);
        this.messageSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.messageSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.processSubscriptionElementInstanceKey = new DbLong();
        this.processSubscriptionMessageName = new DbString();
        this.processSubscriptionElementKeyAndMessageName = new DbCompositeKey((DbKey)this.processSubscriptionElementInstanceKey, (DbKey)this.processSubscriptionMessageName);
        this.processSubscriptionSentTime = new DbLong();
        this.processSubscriptionSentTimeCompositeKey = new DbCompositeKey((DbKey)this.processSubscriptionSentTime, this.processSubscriptionElementKeyAndMessageName);
        this.processSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.processSubscriptionSentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void migrateMessageSubscriptionSentTime(MutableMessageSubscriptionState messageSubscriptionState, MutablePendingMessageSubscriptionState transientState) {
        this.messageSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.getFirst()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.getSecond();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.getFirst()).getValue();
            MessageSubscription messageSubscription = messageSubscriptionState.get(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.getSecond()).getBuffer());
            if (messageSubscription != null) {
                messageSubscriptionState.updateToCorrelatingState(messageSubscription.getRecord());
                transientState.updateCommandSentTime(messageSubscription.getRecord(), sentTime);
            }
            this.messageSubscriptionSentTimeColumnFamily.delete((DbKey)key);
        });
    }

    @Override
    public void migrateProcessMessageSubscriptionSentTime(MutableProcessMessageSubscriptionState persistentState, MutablePendingProcessMessageSubscriptionState transientState) {
        this.processSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.getFirst()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.getSecond();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.getFirst()).getValue();
            ProcessMessageSubscription processMessageSubscription = persistentState.getSubscription(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.getSecond()).getBuffer());
            if (processMessageSubscription != null) {
                ProcessMessageSubscriptionRecord record = processMessageSubscription.getRecord();
                ProcessMessageSubscriptionRecord exclusiveCopy = new ProcessMessageSubscriptionRecord();
                exclusiveCopy.wrap(record);
                if (processMessageSubscription.isOpening()) {
                    persistentState.put(elementInstanceKey, exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                } else if (processMessageSubscription.isClosing()) {
                    persistentState.updateToClosingState(exclusiveCopy);
                    transientState.updateSentTime(exclusiveCopy, sentTime);
                }
            }
            this.processSubscriptionSentTimeColumnFamily.delete((DbKey)key);
        });
    }
}

