package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ValidatingWebhookFluentImpl<A extends ValidatingWebhookFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ValidatingWebhookFluent<A> {

    private List<String> admissionReviewVersions = new ArrayList<String>();
    private WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private String matchPolicy;
    private String name;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder objectSelector;
    private List<RuleWithOperationsBuilder> rules =  new ArrayList<RuleWithOperationsBuilder>();
    private String sideEffects;
    private Integer timeoutSeconds;

    public ValidatingWebhookFluentImpl() { 
    }


    public ValidatingWebhookFluentImpl(ValidatingWebhook instance) { 
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withClientConfig(instance.getClientConfig()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withName(instance.getName()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    }


    public A addToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.set(index, item); return (A)this;
    }

    public A addToAdmissionReviewVersions(String... items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromAdmissionReviewVersions(String... items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
    }

    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (this.admissionReviewVersions != null) { _visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);}
        if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList<String>(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
    }

    public A withAdmissionReviewVersions(String... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear();}
        if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasAdmissionReviewVersions() {
        return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
    }

    public A addNewAdmissionReviewVersion(String arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuilder arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuffer arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public WebhookClientConfig getClientConfig() {
        return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public A withClientConfig(WebhookClientConfig clientConfig) {
        _visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig!=null){ this.clientConfig= new WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} return (A) this;
    }

    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public ValidatingWebhookFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    public ValidatingWebhookFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    public ValidatingWebhookFluent.ClientConfigNested<A> editClientConfig() {
        return withNewClientConfigLike(getClientConfig());
    }

    public ValidatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new WebhookClientConfigBuilder().build());
    }

    public ValidatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy=failurePolicy; return (A) this;
    }

    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A withNewFailurePolicy(String arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuilder arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuffer arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy=matchPolicy; return (A) this;
    }

    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public A withNewMatchPolicy(String arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuilder arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuffer arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public ValidatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    public ValidatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    public ValidatingWebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public ValidatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public ValidatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildObjectSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public LabelSelector buildObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public A withObjectSelector(LabelSelector objectSelector) {
        _visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} return (A) this;
    }

    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public ValidatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    public ValidatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    public ValidatingWebhookFluent.ObjectSelectorNested<A> editObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector());
    }

    public ValidatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
    }

    public ValidatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
    }

    public A addToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(RuleWithOperations... items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(RuleWithOperations... items) {
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<RuleWithOperations> items) {
        for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(Predicate<RuleWithOperationsBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<RuleWithOperationsBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          RuleWithOperationsBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<RuleWithOperations> getRules() {
        return build(rules);
    }

    public List<RuleWithOperations> buildRules() {
        return build(rules);
    }

    public RuleWithOperations buildRule(int index) {
        return this.rules.get(index).build();
    }

    public RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    public RuleWithOperations buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public RuleWithOperations buildMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<RuleWithOperations> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<RuleWithOperationsBuilder>(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(RuleWithOperations... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public ValidatingWebhookFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    public ValidatingWebhookFluent.RulesNested<A> addNewRuleLike(RuleWithOperations item) {
        return new RulesNestedImpl(-1, item);
    }

    public ValidatingWebhookFluent.RulesNested<A> setNewRuleLike(int index,RuleWithOperations item) {
        return new RulesNestedImpl(index, item);
    }

    public ValidatingWebhookFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public ValidatingWebhookFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public ValidatingWebhookFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public ValidatingWebhookFluent.RulesNested<A> editMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public A withSideEffects(String sideEffects) {
        this.sideEffects=sideEffects; return (A) this;
    }

    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    public A withNewSideEffects(String arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuilder arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuffer arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValidatingWebhookFluentImpl that = (ValidatingWebhookFluentImpl) o;
        if (admissionReviewVersions != null ? !admissionReviewVersions.equals(that.admissionReviewVersions) :that.admissionReviewVersions != null) return false;
        if (clientConfig != null ? !clientConfig.equals(that.clientConfig) :that.clientConfig != null) return false;
        if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
        if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (sideEffects != null ? !sideEffects.equals(that.sideEffects) :that.sideEffects != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(admissionReviewVersions,  clientConfig,  failurePolicy,  matchPolicy,  name,  namespaceSelector,  objectSelector,  rules,  sideEffects,  timeoutSeconds,  super.hashCode());
    }

    public class ClientConfigNestedImpl<N> extends WebhookClientConfigFluentImpl<ValidatingWebhookFluent.ClientConfigNested<N>> implements ValidatingWebhookFluent.ClientConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new WebhookClientConfigBuilder(this);
        }

        public N and() {
             return (N) ValidatingWebhookFluentImpl.this.withClientConfig(builder.build());
        }

        public N endClientConfig() {
             return and();
        }
    }


    public class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ValidatingWebhookFluent.NamespaceSelectorNested<N>> implements ValidatingWebhookFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) ValidatingWebhookFluentImpl.this.withNamespaceSelector(builder.build());
        }

        public N endNamespaceSelector() {
             return and();
        }
    }


    public class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ValidatingWebhookFluent.ObjectSelectorNested<N>> implements ValidatingWebhookFluent.ObjectSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) ValidatingWebhookFluentImpl.this.withObjectSelector(builder.build());
        }

        public N endObjectSelector() {
             return and();
        }
    }


    public class RulesNestedImpl<N> extends RuleWithOperationsFluentImpl<ValidatingWebhookFluent.RulesNested<N>> implements ValidatingWebhookFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuleWithOperationsBuilder builder;
        private final int index;

        RulesNestedImpl(int index,RuleWithOperations item) {
            this.index = index;
            this.builder = new RuleWithOperationsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new RuleWithOperationsBuilder(this);
        }

        public N and() {
             return (N) ValidatingWebhookFluentImpl.this.setToRules(index,builder.build());
        }

        public N endRule() {
             return and();
        }
    }


}
