package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class SubjectRulesReviewStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectRulesReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectRulesReviewStatusFluent<A> {

    private String evaluationError;
    private Boolean incomplete;
    private List<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> nonResourceRules =  new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>();
    private List<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> resourceRules =  new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>();

    public SubjectRulesReviewStatusFluentImpl() { 
    }


    public SubjectRulesReviewStatusFluentImpl(io.fabric8.kubernetes.api.model.authorization.v1beta1.SubjectRulesReviewStatus instance) { 
        this.withEvaluationError(instance.getEvaluationError()); 
        this.withIncomplete(instance.getIncomplete()); 
        this.withNonResourceRules(instance.getNonResourceRules()); 
        this.withResourceRules(instance.getResourceRules()); 
    }


    public String getEvaluationError() {
        return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError) {
        this.evaluationError=evaluationError; return (A) this;
    }

    public Boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    public A withNewEvaluationError(String arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(StringBuilder arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(StringBuffer arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public Boolean isIncomplete() {
        return this.incomplete;
    }

    public A withIncomplete(Boolean incomplete) {
        this.incomplete=incomplete; return (A) this;
    }

    public Boolean hasIncomplete() {
        return this.incomplete != null;
    }

    public A withNewIncomplete(String arg1) {
        return (A)withIncomplete(new Boolean(arg1));
    }

    public A withNewIncomplete(boolean arg1) {
        return (A)withIncomplete(new Boolean(arg1));
    }

    public A addToNonResourceRules(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>();}
        io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(index >= 0 ? index : _visitables.get("nonResourceRules").size(), builder);this.nonResourceRules.add(index >= 0 ? index : nonResourceRules.size(), builder); return (A)this;
    }

    public A setToNonResourceRules(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>();}
        io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("nonResourceRules").size()) { _visitables.get("nonResourceRules").add(builder); } else { _visitables.get("nonResourceRules").set(index, builder);}
        if (index < 0 || index >= nonResourceRules.size()) { nonResourceRules.add(builder); } else { nonResourceRules.set(index, builder);}
         return (A)this;
    }

    public A addToNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule... items) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A addAllToNonResourceRules(Collection<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule> items) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A removeFromNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule... items) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule> items) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> predicate) {
        if (nonResourceRules == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> each = nonResourceRules.iterator();
        final List visitables = _visitables.get("nonResourceRules");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNonResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule> getNonResourceRules() {
        return build(nonResourceRules);
    }

    public List<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule> buildNonResourceRules() {
        return build(nonResourceRules);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(nonResourceRules.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule buildMatchingNonResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingNonResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNonResourceRules(List<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule> nonResourceRules) {
        if (this.nonResourceRules != null) { _visitables.get("nonResourceRules").removeAll(this.nonResourceRules);}
        if (nonResourceRules != null) {this.nonResourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder>(); for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item : nonResourceRules){this.addToNonResourceRules(item);}} else { this.nonResourceRules = null;} return (A) this;
    }

    public A withNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule... nonResourceRules) {
        if (this.nonResourceRules != null) {this.nonResourceRules.clear();}
        if (nonResourceRules != null) {for (io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item :nonResourceRules){ this.addToNonResourceRules(item);}} return (A) this;
    }

    public Boolean hasNonResourceRules() {
        return nonResourceRules != null && !nonResourceRules.isEmpty();
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNestedImpl();
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item) {
        return new NonResourceRulesNestedImpl(-1, item);
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item) {
        return new NonResourceRulesNestedImpl(index, item);
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (nonResourceRules.size() <= index) throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (nonResourceRules.size() == 0) throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        return setNewNonResourceRuleLike(0, buildNonResourceRule(0));
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = nonResourceRules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<nonResourceRules.size();i++) { 
        if (predicate.test(nonResourceRules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public A addToResourceRules(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>();}
        io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(index >= 0 ? index : _visitables.get("resourceRules").size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
    }

    public A setToResourceRules(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>();}
        io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("resourceRules").size()) { _visitables.get("resourceRules").add(builder); } else { _visitables.get("resourceRules").set(index, builder);}
        if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
         return (A)this;
    }

    public A addToResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule... items) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A addAllToResourceRules(Collection<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule> items) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>();}
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A removeFromResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule... items) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromResourceRules(Collection<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule> items) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> predicate) {
        if (resourceRules == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> each = resourceRules.iterator();
        final List visitables = _visitables.get("resourceRules");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule> getResourceRules() {
        return build(resourceRules);
    }

    public List<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule> buildResourceRules() {
        return build(resourceRules);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule buildLastResourceRule() {
        return this.resourceRules.get(resourceRules.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule buildMatchingResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResourceRules(List<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule> resourceRules) {
        if (this.resourceRules != null) { _visitables.get("resourceRules").removeAll(this.resourceRules);}
        if (resourceRules != null) {this.resourceRules = new ArrayList<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder>(); for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
    }

    public A withResourceRules(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule... resourceRules) {
        if (this.resourceRules != null) {this.resourceRules.clear();}
        if (resourceRules != null) {for (io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
    }

    public Boolean hasResourceRules() {
        return resourceRules != null && !resourceRules.isEmpty();
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNestedImpl();
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item) {
        return new ResourceRulesNestedImpl(-1, item);
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item) {
        return new ResourceRulesNestedImpl(index, item);
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(int index) {
        if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule() {
        if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        return setNewResourceRuleLike(0, buildResourceRule(0));
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule() {
        int index = resourceRules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resourceRules.size();i++) { 
        if (predicate.test(resourceRules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectRulesReviewStatusFluentImpl that = (SubjectRulesReviewStatusFluentImpl) o;
        if (evaluationError != null ? !evaluationError.equals(that.evaluationError) :that.evaluationError != null) return false;
        if (incomplete != null ? !incomplete.equals(that.incomplete) :that.incomplete != null) return false;
        if (nonResourceRules != null ? !nonResourceRules.equals(that.nonResourceRules) :that.nonResourceRules != null) return false;
        if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(evaluationError,  incomplete,  nonResourceRules,  resourceRules,  super.hashCode());
    }

    public class NonResourceRulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluentImpl<SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>> implements SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder builder;
        private final int index;

        NonResourceRulesNestedImpl(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(this, item);
        }

        NonResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder(this);
        }

        public N and() {
             return (N) SubjectRulesReviewStatusFluentImpl.this.setToNonResourceRules(index,builder.build());
        }

        public N endNonResourceRule() {
             return and();
        }
    }


    public class ResourceRulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleFluentImpl<SubjectRulesReviewStatusFluent.ResourceRulesNested<N>> implements SubjectRulesReviewStatusFluent.ResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder builder;
        private final int index;

        ResourceRulesNestedImpl(int index,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRule item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(this, item);
        }

        ResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceRuleBuilder(this);
        }

        public N and() {
             return (N) SubjectRulesReviewStatusFluentImpl.this.setToResourceRules(index,builder.build());
        }

        public N endResourceRule() {
             return and();
        }
    }


}
