/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect.postgresql.sql;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.clause.PostgreSQLForClauseParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.clause.PostgreSQLLimitClauseParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.clause.facade.PostgreSQLSelectClauseParserFacade;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.AbstractSelectParser;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingjdbc.core.rule.ShardingRule;

public final class PostgreSQLSelectParser
extends AbstractSelectParser {
    private final PostgreSQLLimitClauseParser limitClauseParser;
    private final PostgreSQLForClauseParser forClauseParser;

    public PostgreSQLSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine, new PostgreSQLSelectClauseParserFacade(shardingRule, lexerEngine));
        this.limitClauseParser = new PostgreSQLLimitClauseParser(lexerEngine);
        this.forClauseParser = new PostgreSQLForClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseDistinct();
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseOrderBy(selectStatement);
        this.parseLimit(selectStatement);
        this.parseFor();
        this.parseSelectRest();
    }

    private void parseLimit(SelectStatement selectStatement) {
        this.limitClauseParser.parse(selectStatement);
    }

    private void parseFor() {
        this.forClauseParser.parse();
    }
}

