/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.util;

import com.google.common.base.CharMatcher;
import io.shardingjdbc.core.constant.DatabaseType;
import io.shardingjdbc.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;

public class SQLUtil {
    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static String getOriginalValue(String value, DatabaseType databaseType) {
        if (DatabaseType.MySQL == databaseType) {
            try {
                DefaultKeyword.valueOf(value.toUpperCase());
                MySQLKeyword.valueOf(value.toUpperCase());
                return String.format("`%s`", value);
            }
            catch (IllegalArgumentException ex) {
                return value;
            }
        }
        return value;
    }

    private SQLUtil() {
    }
}

