/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.yaml.sharding;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.config.strategy.ComplexShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.HintShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.InlineShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.NoneShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.ShardingStrategyConfiguration;
import io.shardingjdbc.core.api.config.strategy.StandardShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.strategy.YamlComplexShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.strategy.YamlHintShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.strategy.YamlInlineShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.strategy.YamlNoneShardingStrategyConfiguration;
import io.shardingjdbc.core.yaml.sharding.strategy.YamlStandardShardingStrategyConfiguration;

public class YamlShardingStrategyConfiguration {
    private YamlStandardShardingStrategyConfiguration standard;
    private YamlComplexShardingStrategyConfiguration complex;
    private YamlHintShardingStrategyConfiguration hint;
    private YamlInlineShardingStrategyConfiguration inline;
    private YamlNoneShardingStrategyConfiguration none;

    public ShardingStrategyConfiguration build() {
        int shardingStrategyConfigCount = 0;
        ShardingStrategyConfiguration result = null;
        if (null != this.standard) {
            ++shardingStrategyConfigCount;
            result = new StandardShardingStrategyConfiguration(this.standard.getShardingColumn(), this.standard.getPreciseAlgorithmClassName(), this.standard.getRangeAlgorithmClassName());
        }
        if (null != this.complex) {
            ++shardingStrategyConfigCount;
            result = new ComplexShardingStrategyConfiguration(this.complex.getShardingColumns(), this.complex.getAlgorithmClassName());
        }
        if (null != this.inline) {
            ++shardingStrategyConfigCount;
            result = new InlineShardingStrategyConfiguration(this.inline.getShardingColumn(), this.inline.getAlgorithmExpression());
        }
        if (null != this.hint) {
            ++shardingStrategyConfigCount;
            result = new HintShardingStrategyConfiguration(this.hint.getAlgorithmClassName());
        }
        if (null != this.none) {
            ++shardingStrategyConfigCount;
            result = new NoneShardingStrategyConfiguration();
        }
        Preconditions.checkArgument((shardingStrategyConfigCount <= 1 ? 1 : 0) != 0, (Object)"Only allowed 0 or 1 sharding strategy configuration.");
        return result;
    }

    public YamlStandardShardingStrategyConfiguration getStandard() {
        return this.standard;
    }

    public YamlComplexShardingStrategyConfiguration getComplex() {
        return this.complex;
    }

    public YamlHintShardingStrategyConfiguration getHint() {
        return this.hint;
    }

    public YamlInlineShardingStrategyConfiguration getInline() {
        return this.inline;
    }

    public YamlNoneShardingStrategyConfiguration getNone() {
        return this.none;
    }

    public void setStandard(YamlStandardShardingStrategyConfiguration standard) {
        this.standard = standard;
    }

    public void setComplex(YamlComplexShardingStrategyConfiguration complex) {
        this.complex = complex;
    }

    public void setHint(YamlHintShardingStrategyConfiguration hint) {
        this.hint = hint;
    }

    public void setInline(YamlInlineShardingStrategyConfiguration inline) {
        this.inline = inline;
    }

    public void setNone(YamlNoneShardingStrategyConfiguration none) {
        this.none = none;
    }
}

