/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.datatype.joda.deser;

import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.databind.DeserializationContext;
import io.trino.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.trino.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import io.trino.jdbc.$internal.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import io.trino.jdbc.$internal.joda.time.DateMidnight;
import io.trino.jdbc.$internal.joda.time.DateTimeZone;
import io.trino.jdbc.$internal.joda.time.LocalDate;
import java.io.IOException;

@Deprecated
public class DateMidnightDeserializer
extends JodaDateDeserializerBase<DateMidnight> {
    private static final long serialVersionUID = 1L;

    public DateMidnightDeserializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DateMidnightDeserializer(JacksonJodaDateFormat format) {
        super(DateMidnight.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new DateMidnightDeserializer(format);
    }

    @Override
    public DateMidnight deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            p.nextToken();
            int year = p.getIntValue();
            p.nextToken();
            int month = p.getIntValue();
            p.nextToken();
            int day = p.getIntValue();
            if (p.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "after DateMidnight ints");
            }
            DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
            return new DateMidnight(year, month, day, tz);
        }
        switch (p.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return new DateMidnight(p.getLongValue());
            }
            case VALUE_STRING: {
                String str = p.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                LocalDate local = this._format.createParser(ctxt).parseLocalDate(str);
                if (local == null) {
                    return null;
                }
                return local.toDateMidnight();
            }
        }
        throw ctxt.wrongTokenException(p, JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }
}

