/*
 * Decompiled with CFR 0.152.
 */
package com.easy;

import com.alibaba.fastjson.util.TypeUtils;
import com.codahale.metrics.annotation.Timed;
import com.easy.component.Aggregation;
import com.easy.component.BlockManager;
import com.easy.component.Combining;
import com.easy.component.Comparison;
import com.easy.component.Conversion;
import com.easy.component.Display;
import com.easy.component.Grouping;
import com.easy.component.Index;
import com.easy.component.Inspection;
import com.easy.component.Pivoting;
import com.easy.component.Selection;
import com.easy.component.Serialization;
import com.easy.component.Shaping;
import com.easy.component.Shell;
import com.easy.component.Sorting;
import com.easy.component.SparseBitSet;
import com.easy.component.Timeseries;
import com.easy.component.Transforms;
import com.easy.component.Views;
import java.awt.Container;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DataFrame<V>
implements Iterable<List<V>> {
    private final Index index;
    private final Index columns;
    private final BlockManager<V> data;
    private final Grouping groups;

    public DataFrame() {
        this(Collections.emptyList());
    }

    public DataFrame(String ... columns) {
        this((Collection<?>)Arrays.asList((Object[])columns));
    }

    public DataFrame(Collection<?> columns) {
        this(Collections.emptyList(), columns, Collections.emptyList());
    }

    public DataFrame(Collection<?> index, Collection<?> columns) {
        this(index, columns, Collections.emptyList());
    }

    public DataFrame(List<? extends List<? extends V>> data) {
        this(Collections.emptyList(), Collections.emptyList(), data);
    }

    public DataFrame(Collection<?> index, Collection<?> columns, List<? extends List<? extends V>> data) {
        BlockManager mgr = new BlockManager(data);
        mgr.reshape(Math.max(mgr.size(), columns.size()), Math.max(mgr.length(), index.size()));
        this.data = mgr;
        this.columns = new Index(columns, mgr.size());
        this.index = new Index(index, mgr.length());
        this.groups = new Grouping();
    }

    private DataFrame(Index index, Index columns, BlockManager<V> data, Grouping groups) {
        this.index = index;
        this.columns = columns;
        this.data = data;
        this.groups = groups;
    }

    public DataFrame<V> add(Object ... columns) {
        for (Object column : columns) {
            ArrayList values = new ArrayList(this.length());
            for (int r = 0; r < values.size(); ++r) {
                values.add(null);
            }
            this.add(column, values);
        }
        return this;
    }

    public DataFrame<V> add(List<V> values) {
        return this.add((Object)this.length(), values);
    }

    public DataFrame<V> add(Object column, List<V> values) {
        this.columns.add(column, this.data.size());
        this.index.extend(values.size());
        this.data.add(values);
        return this;
    }

    public DataFrame<V> add(Object column, Function<List<V>, V> function) {
        ArrayList<V> values = new ArrayList<V>();
        for (List row : this) {
            values.add(function.apply(row));
        }
        return this.add(column, values);
    }

    public DataFrame<V> drop(Object ... cols) {
        return this.drop(this.columns.indices(cols));
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame<V> drop(Integer ... cols) {
        void var6_8;
        ArrayList<Object> colnames = new ArrayList<Object>(this.columns.names());
        ArrayList todrop = new ArrayList(cols.length);
        Integer[] integerArray = cols;
        int n = integerArray.length;
        boolean i = false;
        while (var6_8 < n) {
            int col = integerArray[var6_8];
            todrop.add(colnames.get(col));
            ++var6_8;
        }
        colnames.removeAll(todrop);
        ArrayList<List<V>> keep = new ArrayList<List<V>>(colnames.size());
        for (Object e : colnames) {
            keep.add(this.col(e));
        }
        return new DataFrame<V>(this.index.names(), colnames, keep);
    }

    public DataFrame<V> dropna() {
        return this.dropna(Axis.ROWS);
    }

    public DataFrame<V> dropna(Axis direction) {
        switch (direction) {
            case ROWS: {
                return this.select(new Selection.DropNaPredicate());
            }
        }
        return this.transpose().select(new Selection.DropNaPredicate()).transpose();
    }

    public DataFrame<V> fillna(V fill) {
        return this.apply(new Views.FillNaFunction<V>(fill));
    }

    public DataFrame<V> retain(Object ... cols) {
        return this.retain(this.columns.indices(cols));
    }

    public DataFrame<V> retain(Integer ... cols) {
        HashSet<Integer> keep = new HashSet<Integer>(Arrays.asList(cols));
        Integer[] todrop = new Integer[this.size() - keep.size()];
        int i = 0;
        for (int c = 0; c < this.size(); ++c) {
            if (keep.contains(c)) continue;
            todrop[i++] = c;
        }
        return this.drop(todrop);
    }

    public DataFrame<V> reindex(Integer col, boolean drop) {
        DataFrame df = Index.reindex(this, col);
        return drop ? df.drop(col) : df;
    }

    public DataFrame<V> reindex(Integer[] cols, boolean drop) {
        DataFrame df = Index.reindex(this, cols);
        return drop ? df.drop(cols) : df;
    }

    public DataFrame<V> reindex(Integer ... cols) {
        return this.reindex(cols, true);
    }

    public DataFrame<V> reindex(Object col, boolean drop) {
        return this.reindex(this.columns.get(col), drop);
    }

    public DataFrame<V> reindex(Object[] cols, boolean drop) {
        return this.reindex(this.columns.indices(cols), drop);
    }

    public DataFrame<V> reindex(Object ... cols) {
        return this.reindex(this.columns.indices(cols), true);
    }

    public DataFrame<V> resetIndex() {
        return Index.reset(this);
    }

    public DataFrame<V> rename(Object old, Object name) {
        return this.rename(Collections.singletonMap(old, name));
    }

    public DataFrame<V> rename(Map<Object, Object> names) {
        this.columns.rename(names);
        return this;
    }

    public DataFrame<V> append(Object name, V[] row) {
        return this.append(name, Arrays.asList(row));
    }

    public DataFrame<V> append(List<? extends V> row) {
        return this.append((Object)this.length(), row);
    }

    @Timed
    public DataFrame<V> append(Object name, List<? extends V> row) {
        int len = this.length();
        this.index.add(name, len);
        this.columns.extend(row.size());
        this.data.reshape(this.columns.names().size(), len + 1);
        for (int c = 0; c < this.data.size(); ++c) {
            this.data.set(c < row.size() ? (Object)row.get(c) : null, c, len);
        }
        return this;
    }

    public DataFrame<V> reshape(Integer rows, Integer cols) {
        return Shaping.reshape(this, rows, cols);
    }

    public DataFrame<V> reshape(Collection<?> rows, Collection<?> cols) {
        return Shaping.reshape(this, rows, cols);
    }

    public final DataFrame<V> join(DataFrame<V> other) {
        return this.join(other, JoinType.LEFT, null);
    }

    public final DataFrame<V> join(DataFrame<V> other, JoinType join) {
        return this.join(other, join, null);
    }

    public final DataFrame<V> join(DataFrame<V> other, KeyFunction<V> on) {
        return this.join(other, JoinType.LEFT, on);
    }

    public final DataFrame<V> join(DataFrame<V> other, JoinType join, KeyFunction<V> on) {
        return Combining.join(this, other, join, on, on, null);
    }

    public final DataFrame<V> join(DataFrame<V> other, JoinType join, KeyFunction<V> onLeft, KeyFunction<V> onRight, JoinFunction<V> joinFunction) {
        return Combining.join(this, other, join, onLeft, onRight, joinFunction);
    }

    public final DataFrame<V> joinOn(DataFrame<V> other, Integer ... cols) {
        return this.joinOn(other, JoinType.LEFT, cols);
    }

    public final DataFrame<V> joinOn(DataFrame<V> other, JoinType join, Integer ... cols) {
        return Combining.joinOn(this, other, join, cols);
    }

    public final DataFrame<V> joinOn(DataFrame<V> other, Object ... cols) {
        return this.joinOn(other, JoinType.LEFT, cols);
    }

    public final DataFrame<V> joinOn(DataFrame<V> other, JoinType join, Object ... cols) {
        return this.joinOn(other, join, this.columns.indices(cols));
    }

    public final DataFrame<V> merge(DataFrame<V> other) {
        return this.merge(other, JoinType.LEFT);
    }

    public final DataFrame<V> merge(DataFrame<V> other, JoinType join) {
        return Combining.merge(this, other, join);
    }

    @SafeVarargs
    public final DataFrame<V> update(DataFrame<? extends V> ... others) {
        Combining.update(this, true, others);
        return this;
    }

    @SafeVarargs
    public final DataFrame<V> coalesce(DataFrame<? extends V> ... others) {
        Combining.update(this, false, others);
        return this;
    }

    public int size() {
        return this.data.size();
    }

    public int length() {
        return this.data.length();
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public Set<Object> index() {
        return this.index.names();
    }

    public Set<Object> columns() {
        return this.columns.names();
    }

    public V get(Object row, Object col) {
        return this.get(this.index.get(row), this.columns.get(col));
    }

    private String underlineToCamelCase(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.trim().length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(ch);
            }
        }
        return result.toString();
    }

    public String upperCaseFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public String lowerCaseFirst(String str) {
        return str != null && str.length() > 1 ? str.substring(0, 1).toLowerCase() + str.substring(1) : "";
    }

    public <T> T getObject(Integer row, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        T instance = clazz.newInstance();
        Field[] fields = instance.getClass().getDeclaredFields();
        Set<Object> colSet = this.columns();
        HashMap<String, Object> colMap = new HashMap<String, Object>();
        for (Object object : colSet) {
            String fieldName = this.lowerCaseFirst(this.underlineToCamelCase(object.toString()));
            colMap.put(fieldName, object);
        }
        HashMap configMap = new HashMap();
        for (Field field : fields) {
            String fieldName = this.lowerCaseFirst(this.underlineToCamelCase(field.getName()));
            if (!colMap.containsKey(fieldName)) continue;
            configMap.put(field, colMap.get(fieldName));
        }
        for (Field field : configMap.keySet()) {
            Object col = configMap.get(field);
            V value = this.get(row, this.columns.get(col));
            field.setAccessible(true);
            field.set(instance, TypeUtils.castToJavaBean(value, field.getType()));
        }
        return instance;
    }

    public Map<String, Object> getObject(Integer row) {
        Set<Object> colSet = this.columns();
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        for (Object colname : colSet) {
            columnMap.put(colname.toString(), colname);
        }
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
        for (String columnName : columnMap.keySet()) {
            Object columnObject = columnMap.get(columnName);
            V value = this.get(row, this.columns.get(columnObject));
            responseMap.put(columnName, value);
        }
        return responseMap;
    }

    public V get(Integer row, Integer col) {
        return this.data.get(col, row);
    }

    public DataFrame<V> slice(Object rowStart, Object rowEnd) {
        return this.slice(this.index.get(rowStart), this.index.get(rowEnd), 0, this.size());
    }

    public DataFrame<V> slice(Object rowStart, Object rowEnd, Object colStart, Object colEnd) {
        return this.slice(this.index.get(rowStart), this.index.get(rowEnd), this.columns.get(colStart), this.columns.get(colEnd));
    }

    public DataFrame<V> slice(Integer rowStart, Integer rowEnd) {
        return this.slice(rowStart, rowEnd, 0, this.size());
    }

    public DataFrame<V> slice(Integer rowStart, Integer rowEnd, Integer colStart, Integer colEnd) {
        SparseBitSet[] slice = Selection.slice(this, rowStart, rowEnd, colStart, colEnd);
        return new DataFrame<V>(Selection.select(this.index, slice[0]), Selection.select(this.columns, slice[1]), Selection.select(this.data, slice[0], slice[1]), new Grouping());
    }

    public void set(Object row, Object col, V value) {
        this.set(this.index.get(row), this.columns.get(col), value);
    }

    public void set(Integer row, Integer col, V value) {
        this.data.set(value, col, row);
    }

    public List<V> col(Object column) {
        return this.col(this.columns.get(column));
    }

    public List<V> col(Integer column) {
        return new Views.SeriesListView(this, column, true);
    }

    public List<V> row(Object row) {
        return this.row(this.index.get(row));
    }

    public List<V> row(Integer row) {
        return new Views.SeriesListView(this, row, false);
    }

    public DataFrame<V> select(Predicate<V> predicate) {
        SparseBitSet selected = Selection.select(this, predicate);
        return new DataFrame<V>(Selection.select(this.index, selected), this.columns, Selection.select(this.data, selected), new Grouping());
    }

    public DataFrame<V> head() {
        return this.head(10);
    }

    public DataFrame<V> head(int limit) {
        SparseBitSet selected = new SparseBitSet();
        selected.set(0, Math.min(limit, this.length()));
        return new DataFrame<V>(Selection.select(this.index, selected), this.columns, Selection.select(this.data, selected), new Grouping());
    }

    public DataFrame<V> tail() {
        return this.tail(10);
    }

    public DataFrame<V> tail(int limit) {
        SparseBitSet selected = new SparseBitSet();
        int len = this.length();
        selected.set(Math.max(len - limit, 0), len);
        return new DataFrame<V>(Selection.select(this.index, selected), this.columns, Selection.select(this.data, selected), new Grouping());
    }

    public List<V> flatten() {
        return new Views.FlatView(this);
    }

    public DataFrame<V> transpose() {
        return new DataFrame<V>(this.columns.names(), this.index.names(), new Views.ListView(this, true));
    }

    public <U> DataFrame<U> apply(Function<V, U> function) {
        return new DataFrame<V>(this.index.names(), this.columns.names(), new Views.TransformedView<V, U>(this, function, false));
    }

    public <U> DataFrame<U> transform(RowFunction<V, U> transform) {
        DataFrame<U> transformed = new DataFrame<U>(this.columns.names());
        Iterator<Object> it = this.index().iterator();
        for (List row : this) {
            for (List<U> trans : transform.apply(row)) {
                transformed.append(it.hasNext() ? it.next() : Integer.valueOf(transformed.length()), trans);
            }
        }
        return transformed;
    }

    public DataFrame<V> convert() {
        Conversion.convert(this);
        return this;
    }

    public DataFrame<V> convert(NumberDefault numDefault, String naString) {
        Conversion.convert(this, numDefault, naString);
        return this;
    }

    @SafeVarargs
    public final DataFrame<V> convert(Class<? extends V> ... columnTypes) {
        Conversion.convert(this, columnTypes);
        return this;
    }

    public DataFrame<Boolean> isnull() {
        return Conversion.isnull(this);
    }

    public DataFrame<Boolean> notnull() {
        return Conversion.notnull(this);
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size() * this.length()]);
    }

    public <U> U[] toArray(U[] array) {
        return new Views.FlatView(this).toArray(array);
    }

    public <U> U[][] toArray(U[][] array) {
        if (array.length >= this.size() && array.length > 0 && array[0].length >= this.length()) {
            for (int c = 0; c < this.size(); ++c) {
                for (int r = 0; r < this.length(); ++r) {
                    array[r][c] = this.get(r, c);
                }
            }
        }
        return (Object[][])this.toArray(array.getClass());
    }

    public <U> U toArray(Class<U> cls) {
        int dim = 0;
        Class<Object> type = cls;
        while (type.getComponentType() != null) {
            type = type.getComponentType();
            ++dim;
        }
        int size = this.size();
        int len = this.length();
        if (dim == 1) {
            Object array = Array.newInstance(type, size * len);
            for (int c = 0; c < size; ++c) {
                for (int r = 0; r < len; ++r) {
                    Array.set(array, c * len + r, this.data.get(c, r));
                }
            }
            return (U)array;
        }
        if (dim == 2) {
            Object array = Array.newInstance(type, len, size);
            for (int r = 0; r < len; ++r) {
                Object aa = Array.get(array, r);
                for (int c = 0; c < size; ++c) {
                    Array.set(aa, c, this.get(r, c));
                }
                Array.set(array, r, aa);
            }
            return (U)array;
        }
        throw new IllegalArgumentException("class must be an array class");
    }

    public double[][] toModelMatrix(double fillValue) {
        return Conversion.toModelMatrix(this, fillValue);
    }

    public DataFrame<Number> toModelMatrixDataFrame() {
        return Conversion.toModelMatrixDataFrame(this);
    }

    @Timed
    public DataFrame<V> groupBy(Object ... cols) {
        return this.groupBy(this.columns.indices(cols));
    }

    @Timed
    public DataFrame<V> groupBy(Integer ... cols) {
        return new DataFrame<V>(this.index, this.columns, this.data, new Grouping(this, cols));
    }

    @Timed
    public DataFrame<V> groupBy(KeyFunction<V> function) {
        return new DataFrame<V>(this.index, this.columns, this.data, new Grouping(this, function, new Integer[0]));
    }

    public Grouping groups() {
        return this.groups;
    }

    public Map<Object, DataFrame<V>> explode() {
        LinkedHashMap<Object, DataFrame<DataFrame<V>>> exploded = new LinkedHashMap<Object, DataFrame<DataFrame<V>>>();
        for (Map.Entry<Object, SparseBitSet> entry : this.groups) {
            SparseBitSet selected = entry.getValue();
            exploded.put(entry.getKey(), new DataFrame<V>(Selection.select(this.index, selected), this.columns, Selection.select(this.data, selected), new Grouping()));
        }
        return exploded;
    }

    public <U> DataFrame<V> aggregate(Aggregate<V, U> function) {
        return this.groups.apply(this, function);
    }

    @Timed
    public DataFrame<V> count() {
        return this.groups.apply(this, new Aggregation.Count());
    }

    public DataFrame<V> collapse() {
        return this.groups.apply(this, new Aggregation.Collapse());
    }

    public DataFrame<V> unique() {
        return this.groups.apply(this, new Aggregation.Unique());
    }

    @Timed
    public DataFrame<V> sum() {
        return this.groups.apply(this, new Aggregation.Sum());
    }

    @Timed
    public DataFrame<V> prod() {
        return this.groups.apply(this, new Aggregation.Product());
    }

    @Timed
    public DataFrame<V> mean() {
        return this.groups.apply(this, new Aggregation.Mean());
    }

    @Timed
    public DataFrame<V> percentile(double quantile) {
        return this.groups.apply(this, new Aggregation.Percentile(quantile));
    }

    @Timed
    public DataFrame<V> stddev() {
        return this.groups.apply(this, new Aggregation.StdDev());
    }

    @Timed
    public DataFrame<V> var() {
        return this.groups.apply(this, new Aggregation.Variance());
    }

    @Timed
    public DataFrame<V> skew() {
        return this.groups.apply(this, new Aggregation.Skew());
    }

    @Timed
    public DataFrame<V> kurt() {
        return this.groups.apply(this, new Aggregation.Kurtosis());
    }

    @Timed
    public DataFrame<V> min() {
        return this.groups.apply(this, new Aggregation.Min());
    }

    @Timed
    public DataFrame<V> max() {
        return this.groups.apply(this, new Aggregation.Max());
    }

    @Timed
    public DataFrame<V> median() {
        return this.groups.apply(this, new Aggregation.Median());
    }

    @Timed
    public DataFrame<Number> cov() {
        return Aggregation.cov(this);
    }

    @Timed
    public DataFrame<V> cumsum() {
        return this.groups.apply(this, new Transforms.CumulativeSum());
    }

    @Timed
    public DataFrame<V> cumprod() {
        return this.groups.apply(this, new Transforms.CumulativeProduct());
    }

    @Timed
    public DataFrame<V> cummin() {
        return this.groups.apply(this, new Transforms.CumulativeMin());
    }

    @Timed
    public DataFrame<V> cummax() {
        return this.groups.apply(this, new Transforms.CumulativeMax());
    }

    @Timed
    public DataFrame<V> describe() {
        return Aggregation.describe(this.groups.apply(this, new Aggregation.Describe()));
    }

    public DataFrame<V> pivot(Object row, Object col, Object ... values) {
        return this.pivot(Collections.singletonList(row), Collections.singletonList(col), Arrays.asList(values));
    }

    public DataFrame<V> pivot(List<Object> rows, List<Object> cols, List<Object> values) {
        return this.pivot(this.columns.indices(rows), this.columns.indices(cols), this.columns.indices(values));
    }

    public DataFrame<V> pivot(Integer row, Integer col, Integer ... values) {
        return this.pivot(new Integer[]{row}, new Integer[]{col}, values);
    }

    @Timed
    public DataFrame<V> pivot(Integer[] rows, Integer[] cols, Integer[] values) {
        return Pivoting.pivot(this, rows, cols, values);
    }

    @Timed
    public <U> DataFrame<U> pivot(KeyFunction<V> rows, KeyFunction<V> cols, Map<Integer, Aggregate<V, U>> values) {
        return Pivoting.pivot(this, rows, cols, values);
    }

    public DataFrame<V> sortBy(Object ... cols) {
        LinkedHashMap<Integer, SortDirection> sortCols = new LinkedHashMap<Integer, SortDirection>();
        for (Object col : cols) {
            String str = col instanceof String ? (String)String.class.cast(col) : "";
            SortDirection dir = str.startsWith("-") ? SortDirection.DESCENDING : SortDirection.ASCENDING;
            int c = this.columns.get(str.startsWith("-") ? str.substring(1) : col);
            sortCols.put(c, dir);
        }
        return Sorting.sort(this, sortCols);
    }

    @Timed
    public DataFrame<V> sortBy(Integer ... cols) {
        LinkedHashMap<Integer, SortDirection> sortCols = new LinkedHashMap<Integer, SortDirection>();
        Integer[] integerArray = cols;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int c = integerArray[i];
            SortDirection dir = c < 0 ? SortDirection.DESCENDING : SortDirection.ASCENDING;
            sortCols.put(Math.abs(c), dir);
        }
        return Sorting.sort(this, sortCols);
    }

    public DataFrame<V> sortBy(Comparator<List<V>> comparator) {
        return Sorting.sort(this, comparator);
    }

    public List<Class<?>> types() {
        return Inspection.types(this);
    }

    public DataFrame<Number> numeric() {
        SparseBitSet numeric = Inspection.numeric(this);
        Set<Object> keep = Selection.select(this.columns, numeric).names();
        return this.retain(keep.toArray(new Object[keep.size()])).cast(Number.class);
    }

    public DataFrame<V> nonnumeric() {
        SparseBitSet nonnumeric = Inspection.nonnumeric(this);
        Set<Object> keep = Selection.select(this.columns, nonnumeric).names();
        return this.retain(keep.toArray(new Object[keep.size()]));
    }

    @Override
    public ListIterator<List<V>> iterator() {
        return this.iterrows();
    }

    public ListIterator<List<V>> iterrows() {
        return new Views.ListView(this, true).listIterator();
    }

    public ListIterator<List<V>> itercols() {
        return new Views.ListView(this, false).listIterator();
    }

    public ListIterator<Map<Object, V>> itermap() {
        return new Views.MapView(this, true).listIterator();
    }

    public ListIterator<V> itervalues() {
        return new Views.FlatView(this).listIterator();
    }

    public <T> DataFrame<T> cast(Class<T> cls) {
        return this;
    }

    public Map<Object, List<V>> map() {
        LinkedHashMap<Object, List<List<V>>> m = new LinkedHashMap<Object, List<List<V>>>();
        int len = this.length();
        Iterator<Object> names = this.index.names().iterator();
        for (int r = 0; r < len; ++r) {
            Object name = names.hasNext() ? names.next() : Integer.valueOf(r);
            m.put(name, this.row(r));
        }
        return m;
    }

    public Map<V, List<V>> map(Object key, Object value) {
        return this.map(this.columns.get(key), this.columns.get(value));
    }

    public Map<V, List<V>> map(Integer key, Integer value) {
        LinkedHashMap<V, ArrayList<V>> m = new LinkedHashMap<V, ArrayList<V>>();
        int len = this.length();
        for (int r = 0; r < len; ++r) {
            V name = this.data.get(key, r);
            ArrayList<V> values = (ArrayList<V>)m.get(name);
            if (values == null) {
                values = new ArrayList<V>();
                m.put(name, values);
            }
            values.add(this.data.get(value, r));
        }
        return m;
    }

    public DataFrame<V> unique(Object ... cols) {
        return this.unique(this.columns.indices(cols));
    }

    public DataFrame<V> unique(Integer ... cols) {
        DataFrame<V> unique = new DataFrame<V>(this.columns.names());
        HashSet seen = new HashSet();
        ArrayList<V> key = new ArrayList<V>(cols.length);
        int len = this.length();
        for (int r = 0; r < len; ++r) {
            Integer[] integerArray = cols;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int c = integerArray[i];
                key.add(this.data.get(c, r));
            }
            if (!seen.contains(key)) {
                unique.append(this.row(r));
                seen.add(key);
            }
            key.clear();
        }
        return unique;
    }

    public DataFrame<V> diff() {
        return this.diff(1);
    }

    public DataFrame<V> diff(int period) {
        return Timeseries.diff(this, period);
    }

    public DataFrame<V> percentChange() {
        return this.percentChange(1);
    }

    public DataFrame<V> percentChange(int period) {
        return Timeseries.percentChange(this, period);
    }

    public DataFrame<V> rollapply(Function<List<V>, V> function) {
        return this.rollapply(function, 1);
    }

    public DataFrame<V> rollapply(Function<List<V>, V> function, int period) {
        return Timeseries.rollapply(this, function, period);
    }

    public final void plot() {
        this.plot(PlotType.LINE);
    }

    public final void plot(PlotType type) {
        Display.plot(this, type);
    }

    public final void draw(Container container) {
        Display.draw(this, container, PlotType.LINE);
    }

    public final void draw(Container container, PlotType type) {
        Display.draw(this, container, type);
    }

    public final void show() {
        Display.show(this);
    }

    public static final <V> DataFrame<String> compare(DataFrame<V> df1, DataFrame<V> df2) {
        return Comparison.compare(df1, df2);
    }

    public static final DataFrame<Object> readCsv(String file) throws IOException {
        return Serialization.readCsv(file);
    }

    public static final DataFrame<Object> readCsv(InputStream input) throws IOException {
        return Serialization.readCsv(input);
    }

    public static final DataFrame<Object> readCsv(String file, String separator) throws IOException {
        return Serialization.readCsv(file, separator, NumberDefault.LONG_DEFAULT);
    }

    public static final DataFrame<Object> readCsv(InputStream input, String separator) throws IOException {
        return Serialization.readCsv(input, separator, NumberDefault.LONG_DEFAULT, null);
    }

    public static final DataFrame<Object> readCsv(InputStream input, String separator, String naString) throws IOException {
        return Serialization.readCsv(input, separator, NumberDefault.LONG_DEFAULT, naString);
    }

    public static final DataFrame<Object> readCsv(InputStream input, String separator, String naString, boolean hasHeader) throws IOException {
        return Serialization.readCsv(input, separator, NumberDefault.LONG_DEFAULT, naString, hasHeader, new Class[0]);
    }

    public static final DataFrame<Object> readCsv(String file, String separator, String naString, boolean hasHeader) throws IOException {
        return Serialization.readCsv(file, separator, NumberDefault.LONG_DEFAULT, naString, hasHeader, new Class[0]);
    }

    public static final DataFrame<Object> readCsv(String file, String separator, NumberDefault numberDefault, String naString, boolean hasHeader, Class<?> ... columnTypes) throws IOException {
        return Serialization.readCsv(file, separator, numberDefault, naString, hasHeader, columnTypes);
    }

    public static final DataFrame<Object> readCsv(String file, String separator, NumberDefault longDefault) throws IOException {
        return Serialization.readCsv(file, separator, longDefault);
    }

    public static final DataFrame<Object> readCsv(String file, String separator, NumberDefault longDefault, String naString) throws IOException {
        return Serialization.readCsv(file, separator, longDefault, naString);
    }

    public static final DataFrame<Object> readCsv(InputStream input, String separator, NumberDefault longDefault) throws IOException {
        return Serialization.readCsv(input, separator, longDefault, null);
    }

    public final void writeCsv(String file) throws IOException {
        Serialization.writeCsv(this, new FileOutputStream(file));
    }

    public final void writeCsv(OutputStream output) throws IOException {
        Serialization.writeCsv(this, output);
    }

    public static final DataFrame<Object> readXls(String file) throws IOException {
        return Serialization.readXls(file);
    }

    public static final DataFrame<Object> readXls(InputStream input) throws IOException {
        return Serialization.readXls(input);
    }

    public final void writeXls(String file) throws IOException {
        Serialization.writeXls(this, new FileOutputStream(file));
    }

    public final void writeXls(OutputStream output) throws IOException {
        Serialization.writeXls(this, output);
    }

    public static final DataFrame<Object> readSql(Connection c, String sql, IndexFunction<Object> idxFunction) throws SQLException {
        try (Statement stmt = c.createStatement();){
            DataFrame<Object> dataFrame = DataFrame.readSql(stmt.executeQuery(sql), null, idxFunction);
            return dataFrame;
        }
    }

    public static final DataFrame<Object> readSql(Connection c, String sql, List<String> indexList) throws SQLException {
        try (Statement stmt = c.createStatement();){
            DataFrame<Object> dataFrame = DataFrame.readSql(stmt.executeQuery(sql), null, indexList);
            return dataFrame;
        }
    }

    public static final DataFrame<Object> readSql(ResultSet rs, TagFunction<Object> tagFunction, IndexFunction<Object> idxFunction) throws SQLException {
        return Serialization.readSql(rs, tagFunction, idxFunction);
    }

    public static final DataFrame<Object> readSql(ResultSet rs, TagFunction<Object> tagFunction, List<String> indexList) throws SQLException {
        return Serialization.readSql(rs, tagFunction, indexList);
    }

    public final void writeSql(Connection c, String sql) throws SQLException {
        this.writeSql(c.prepareStatement(sql));
    }

    public final void writeSql(PreparedStatement stmt) throws SQLException {
        Serialization.writeSql(this, stmt);
    }

    public final String toString(int limit) {
        return Serialization.toString(this, limit);
    }

    public String toString() {
        return this.toString(10);
    }

    public static final void main(String[] args) throws IOException {
        ArrayList<DataFrame<Object>> frames = new ArrayList<DataFrame<Object>>();
        for (int i = 1; i < args.length; ++i) {
            frames.add(DataFrame.readCsv(args[i]));
        }
        if (args.length > 0 && "plot".equalsIgnoreCase(args[0]) && frames.size() == 1) {
            ((DataFrame)frames.get(0)).plot();
            return;
        }
        if (args.length > 0 && "show".equalsIgnoreCase(args[0]) && frames.size() == 1) {
            ((DataFrame)frames.get(0)).show();
            return;
        }
        if (args.length > 0 && "compare".equalsIgnoreCase(args[0]) && frames.size() == 2) {
            System.out.println(DataFrame.compare((DataFrame)frames.get(0), (DataFrame)frames.get(1)));
            return;
        }
        if (args.length > 0 && "shell".equalsIgnoreCase(args[0])) {
            Shell.repl(frames);
            return;
        }
        System.err.printf("usage: %s [compare|plot|show|shell] [csv-file ...]\n", DataFrame.class.getCanonicalName());
        System.exit(255);
    }

    public static enum NumberDefault {
        LONG_DEFAULT,
        DOUBLE_DEFAULT;

    }

    public static enum Axis {
        ROWS,
        COLUMNS;

    }

    public static enum PlotType {
        SCATTER,
        SCATTER_WITH_TREND,
        LINE,
        LINE_AND_POINTS,
        AREA,
        BAR,
        GRID,
        GRID_WITH_TREND;

    }

    public static enum JoinType {
        INNER,
        OUTER,
        LEFT,
        RIGHT;

    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }

    public static interface Predicate<I>
    extends Function<List<I>, Boolean> {
    }

    public static interface Aggregate<I, O>
    extends Function<List<I>, O> {
    }

    public static interface IndexFunction<T> {
        public Object indexAction(List<String> var1, List<T> var2);
    }

    public static interface TagFunction<T> {
        public void tagColumn(List<String> var1);

        public void tagAction(List<String> var1, List<T> var2);
    }

    public static interface JoinFunction<T> {
        public boolean compare(List<Object> var1, List<T> var2);
    }

    public static interface KeyFunction<I>
    extends Function<List<I>, Object> {
    }

    public static interface RowFunction<I, O> {
        public List<List<O>> apply(List<I> var1);
    }

    public static interface Function<I, O> {
        public O apply(I var1);
    }
}

