/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.stat.correlation.StorelessCovariance;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class Aggregation {
    private static final Object name(DataFrame<?> df, Object row, Object stat) {
        return df.index().size() > 1 ? Arrays.asList(row, stat) : stat;
    }

    public static <V> DataFrame<V> describe(DataFrame<V> df) {
        DataFrame<Object> desc = new DataFrame<Object>();
        for (Object col : df.columns()) {
            for (Object row : df.index()) {
                V value = df.get(row, col);
                if (!(value instanceof StatisticalSummary)) continue;
                if (!desc.columns().contains(col)) {
                    desc.add(col);
                    if (desc.isEmpty()) {
                        for (Object r : df.index()) {
                            for (String stat : Arrays.asList("count", "mean", "std", "var", "max", "min")) {
                                Object name = Aggregation.name(df, r, stat);
                                desc.append(name, Collections.emptyList());
                            }
                        }
                    }
                }
                StatisticalSummary summary = (StatisticalSummary)StatisticalSummary.class.cast(value);
                desc.set(Aggregation.name(df, row, "count"), col, new Double(summary.getN()));
                desc.set(Aggregation.name(df, row, "mean"), col, new Double(summary.getMean()));
                desc.set(Aggregation.name(df, row, "std"), col, new Double(summary.getStandardDeviation()));
                desc.set(Aggregation.name(df, row, "var"), col, new Double(summary.getVariance()));
                desc.set(Aggregation.name(df, row, "max"), col, new Double(summary.getMax()));
                desc.set(Aggregation.name(df, row, "min"), col, new Double(summary.getMin()));
            }
        }
        return desc;
    }

    public static <V> DataFrame<Number> cov(DataFrame<V> df) {
        DataFrame<Number> num = df.numeric();
        StorelessCovariance cov = new StorelessCovariance(num.size());
        double[] data = new double[num.size()];
        for (List list : num) {
            for (int i = 0; i < list.size(); ++i) {
                data[i] = ((Number)list.get(i)).doubleValue();
            }
            cov.increment(data);
        }
        double[][] result = cov.getData();
        DataFrame<Number> dataFrame = new DataFrame<Number>(num.columns());
        ArrayList<Double> row = new ArrayList<Double>(num.size());
        for (int i = 0; i < result.length; ++i) {
            row.clear();
            for (int j = 0; j < result[i].length; ++j) {
                row.add(result[i][j]);
            }
            dataFrame.append(row);
        }
        return dataFrame;
    }

    public static class Describe<V>
    implements DataFrame.Aggregate<V, StatisticalSummary> {
        private final SummaryStatistics stat = new SummaryStatistics();

        @Override
        public StatisticalSummary apply(List<V> values) {
            this.stat.clear();
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof Boolean) {
                    value = (Boolean)Boolean.class.cast(value) != false ? 1 : 0;
                }
                this.stat.addValue(((Number)Number.class.cast(value)).doubleValue());
            }
            return this.stat.getSummary();
        }
    }

    public static class Percentile<V>
    extends AbstractStatistic<V> {
        public Percentile(double quantile) {
            super((UnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Percentile(quantile));
        }
    }

    public static class Median<V>
    extends AbstractStatistic<V> {
        public Median() {
            super((UnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Median());
        }
    }

    private static abstract class AbstractStatistic<V>
    implements DataFrame.Aggregate<V, Number> {
        protected final UnivariateStatistic stat;

        protected AbstractStatistic(UnivariateStatistic stat) {
            this.stat = stat;
        }

        @Override
        public Number apply(List<V> values) {
            int count = 0;
            double[] vals = new double[values.size()];
            for (int i = 0; i < vals.length; ++i) {
                V val = values.get(i);
                if (val == null) continue;
                vals[count++] = ((Number)Number.class.cast(val)).doubleValue();
            }
            return this.stat.evaluate(vals, 0, count);
        }
    }

    public static class Max<V>
    extends AbstractStorelessStatistic<V> {
        public Max() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Max());
        }
    }

    public static class Min<V>
    extends AbstractStorelessStatistic<V> {
        public Min() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.rank.Min());
        }
    }

    public static class Kurtosis<V>
    extends AbstractStorelessStatistic<V> {
        public Kurtosis() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Kurtosis());
        }
    }

    public static class Skew<V>
    extends AbstractStorelessStatistic<V> {
        public Skew() {
            super((StorelessUnivariateStatistic)new Skewness());
        }
    }

    public static class Variance<V>
    extends AbstractStorelessStatistic<V> {
        public Variance() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Variance());
        }
    }

    public static class StdDev<V>
    extends AbstractStorelessStatistic<V> {
        public StdDev() {
            super((StorelessUnivariateStatistic)new StandardDeviation());
        }
    }

    public static class Mean<V>
    extends AbstractStorelessStatistic<V> {
        public Mean() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.moment.Mean());
        }
    }

    public static class Product<V>
    extends AbstractStorelessStatistic<V> {
        public Product() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.summary.Product());
        }
    }

    public static class Sum<V>
    extends AbstractStorelessStatistic<V> {
        public Sum() {
            super((StorelessUnivariateStatistic)new org.apache.commons.math3.stat.descriptive.summary.Sum());
        }
    }

    private static abstract class AbstractStorelessStatistic<V>
    implements DataFrame.Aggregate<V, Number> {
        protected final StorelessUnivariateStatistic stat;

        protected AbstractStorelessStatistic(StorelessUnivariateStatistic stat) {
            this.stat = stat;
        }

        @Override
        public Number apply(List<V> values) {
            this.stat.clear();
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof Boolean) {
                    value = (Boolean)Boolean.class.cast(value) != false ? 1 : 0;
                }
                this.stat.increment(((Number)Number.class.cast(value)).doubleValue());
            }
            return this.stat.getResult();
        }
    }

    public static class Collapse<V>
    implements DataFrame.Aggregate<V, String> {
        private final String delimiter;

        public Collapse() {
            this(",");
        }

        public Collapse(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public String apply(List<V> values) {
            HashSet<V> seen = new HashSet<V>();
            StringBuilder sb = new StringBuilder();
            for (V value : values) {
                if (seen.contains(value)) continue;
                if (sb.length() > 0) {
                    sb.append(this.delimiter);
                }
                sb.append(String.valueOf(value));
                seen.add(value);
            }
            return sb.toString();
        }
    }

    public static class Unique<V>
    implements DataFrame.Aggregate<V, V> {
        @Override
        public V apply(List<V> values) {
            HashSet<V> unique = new HashSet<V>(values);
            if (unique.size() > 1) {
                throw new IllegalArgumentException("values not unique: " + unique);
            }
            return values.get(0);
        }
    }

    public static class Count<V>
    implements DataFrame.Aggregate<V, Number> {
        @Override
        public Number apply(List<V> values) {
            return new Integer(values.size());
        }
    }
}

