/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import com.easy.component.SparseBitSet;
import com.easy.component.Transforms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Grouping
implements Iterable<Map.Entry<Object, SparseBitSet>> {
    private final Map<Object, SparseBitSet> groups = new LinkedHashMap<Object, SparseBitSet>();
    private final Set<Integer> columns = new LinkedHashSet<Integer>();

    public Grouping() {
    }

    public <V> Grouping(DataFrame<V> df, DataFrame.KeyFunction<V> function, Integer ... columns) {
        Iterator iter = df.iterator();
        int r = 0;
        while (iter.hasNext()) {
            List row = (List)iter.next();
            Object key = function.apply(row);
            SparseBitSet group = this.groups.get(key);
            if (group == null) {
                group = new SparseBitSet();
                this.groups.put(key, group);
            }
            group.set(r);
            ++r;
        }
        Integer[] integerArray = columns;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int column = integerArray[i];
            this.columns.add(column);
        }
    }

    public <V> Grouping(DataFrame<V> df, final Integer ... columns) {
        this(df, columns.length == 1 ? new DataFrame.KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                return value.get(columns[0]);
            }
        } : new DataFrame.KeyFunction<V>(){

            @Override
            public Object apply(List<V> value) {
                ArrayList key = new ArrayList(columns.length);
                Integer[] integerArray = columns;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int column = integerArray[i];
                    key.add(value.get(column));
                }
                return Collections.unmodifiableList(key);
            }
        }, columns);
    }

    public <V> DataFrame<V> apply(DataFrame<V> df, DataFrame.Function<?, ?> function) {
        int r;
        if (df.isEmpty()) {
            return df;
        }
        ArrayList<List<Object>> grouped = new ArrayList<List<Object>>();
        ArrayList<Object> names = new ArrayList<Object>(df.columns());
        ArrayList newcols = new ArrayList();
        ArrayList<Object> index = new ArrayList<Object>();
        if (function instanceof DataFrame.Aggregate && !this.groups.isEmpty()) {
            for (Object key : this.groups.keySet()) {
                index.add(key);
            }
        }
        Iterator<Object> iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            int c = iterator.next();
            if (function instanceof DataFrame.Aggregate && !this.groups.isEmpty()) {
                ArrayList<V> column = new ArrayList<V>();
                for (Map.Entry<Object, SparseBitSet> entry : this.groups.entrySet()) {
                    SparseBitSet rows = entry.getValue();
                    r = rows.nextSetBit(0);
                    column.add(df.get(r, c));
                }
                grouped.add(column);
                newcols.add(names.get(c));
                continue;
            }
            grouped.add(df.col(c));
            newcols.add(names.get(c));
        }
        for (int c = 0; c < df.size(); ++c) {
            if (this.columns.contains(c)) continue;
            ArrayList column = new ArrayList();
            if (this.groups.isEmpty()) {
                try {
                    if (function instanceof DataFrame.Aggregate) {
                        column.add(((DataFrame.Aggregate)DataFrame.Aggregate.class.cast(function)).apply(df.col(c)));
                    } else {
                        for (int r2 = 0; r2 < df.length(); ++r2) {
                            column.add(((DataFrame.Function)DataFrame.Function.class.cast(function)).apply(df.get(r2, c)));
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (function instanceof Transforms.CumulativeFunction) {
                    ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
                }
            } else {
                for (Map.Entry<Object, SparseBitSet> entry : this.groups.entrySet()) {
                    SparseBitSet rows = entry.getValue();
                    try {
                        if (function instanceof DataFrame.Aggregate) {
                            ArrayList<V> values = new ArrayList<V>(rows.cardinality());
                            r = rows.nextSetBit(0);
                            while (r >= 0) {
                                values.add(df.get(r, c));
                                r = rows.nextSetBit(r + 1);
                            }
                            column.add(((DataFrame.Aggregate)DataFrame.Aggregate.class.cast(function)).apply(values));
                        } else {
                            int r3 = rows.nextSetBit(0);
                            while (r3 >= 0) {
                                column.add(((DataFrame.Function)DataFrame.Function.class.cast(function)).apply(df.get(r3, c)));
                                r3 = rows.nextSetBit(r3 + 1);
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (!(function instanceof Transforms.CumulativeFunction)) continue;
                    ((Transforms.CumulativeFunction)Transforms.CumulativeFunction.class.cast(function)).reset();
                }
            }
            if (column.isEmpty()) continue;
            grouped.add(column);
            newcols.add(names.get(c));
        }
        if (newcols.size() <= this.columns.size()) {
            throw new IllegalArgumentException("no results for aggregate function " + function.getClass().getSimpleName());
        }
        return new DataFrame(index, newcols, grouped);
    }

    public Set<Object> keys() {
        return this.groups.keySet();
    }

    public Set<Integer> columns() {
        return this.columns;
    }

    @Override
    public Iterator<Map.Entry<Object, SparseBitSet>> iterator() {
        return this.groups.entrySet().iterator();
    }
}

