/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import com.easy.component.FmtString;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class Serialization {
    private static final String EMPTY_DF_STRING = "[empty data frame]";
    private static final String ELLIPSES = "...";
    private static final String NEWLINE = "\n";
    private static final String DELIMITER = "\t";
    private static final Object INDEX_KEY = new Object();
    private static final int MAX_COLUMN_WIDTH = 20;

    public static String toString(DataFrame<?> df, int limit) {
        Object column;
        int c;
        int len = df.length();
        if (len == 0) {
            return EMPTY_DF_STRING;
        }
        StringBuilder sb = new StringBuilder();
        HashMap<Object, Integer> width = new HashMap<Object, Integer>();
        List<Class<?>> types = df.types();
        ArrayList<Object> columns = new ArrayList<Object>(df.columns());
        width.put(INDEX_KEY, 0);
        for (Object row : df.index()) {
            Class<?> rowClass = row == null ? null : row.getClass();
            width.put(INDEX_KEY, Serialization.clamp((Integer)width.get(INDEX_KEY), 20, Serialization.fmt(rowClass, row).length()));
        }
        for (c = 0; c < columns.size(); ++c) {
            column = columns.get(c);
            width.put(column, String.valueOf(column).length());
            for (int r = 0; r < df.length(); ++r) {
                width.put(column, Serialization.clamp((Integer)width.get(column), 20, Serialization.fmt(types.get(c), df.get(r, c)).length()));
            }
        }
        sb.append(Serialization.lpad("", (Integer)width.get(INDEX_KEY)));
        for (c = 0; c < columns.size(); ++c) {
            sb.append(DELIMITER);
            column = columns.get(c);
            sb.append(Serialization.lpad(column, (Integer)width.get(column)));
        }
        sb.append(NEWLINE);
        Iterator<Object> names = df.index().iterator();
        for (int r = 0; r < len; ++r) {
            int w = (Integer)width.get(INDEX_KEY);
            Object row = names.hasNext() ? names.next() : Integer.valueOf(r);
            Class<?> rowClass = row == null ? null : row.getClass();
            sb.append(Serialization.truncate(Serialization.lpad(Serialization.fmt(rowClass, row), w), w));
            for (int c2 = 0; c2 < df.size(); ++c2) {
                sb.append(DELIMITER);
                Class<?> cls = types.get(c2);
                w = (Integer)width.get(columns.get(c2));
                if (Number.class.isAssignableFrom(cls)) {
                    sb.append(Serialization.lpad(Serialization.fmt(cls, df.get(r, c2)), w));
                    continue;
                }
                sb.append(Serialization.truncate(Serialization.rpad(Serialization.fmt(cls, df.get(r, c2)), w), w));
            }
            sb.append(NEWLINE);
            if (limit - 3 >= r || r >= limit << 1 || r >= len - 4) continue;
            sb.append(NEWLINE).append(ELLIPSES).append(" ").append(len - limit).append(" rows skipped ").append(ELLIPSES).append(NEWLINE).append(NEWLINE);
            while (r < len - 2) {
                if (names.hasNext()) {
                    names.next();
                }
                ++r;
            }
        }
        return sb.toString();
    }

    private static final int clamp(int lower, int upper, int value) {
        return Math.max(lower, Math.min(upper, value));
    }

    private static final String lpad(Object o, int w) {
        StringBuilder sb = new StringBuilder();
        String value = String.valueOf(o);
        for (int i = value.length(); i < w; ++i) {
            sb.append(' ');
        }
        sb.append(value);
        return sb.toString();
    }

    private static final String rpad(Object o, int w) {
        StringBuilder sb = new StringBuilder();
        String value = String.valueOf(o);
        sb.append(value);
        for (int i = value.length(); i < w; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static final String truncate(Object o, int w) {
        String value = String.valueOf(o);
        return value.length() - ELLIPSES.length() > w ? value.substring(0, w - ELLIPSES.length()) + ELLIPSES : value;
    }

    private static final String fmt(Class<?> cls, Object o) {
        String s;
        if (cls == null) {
            return "null";
        }
        if (o instanceof Number) {
            s = Short.class.equals(cls) || Integer.class.equals(cls) || Long.class.equals(cls) || BigInteger.class.equals(cls) ? String.format("% d", ((Number)Number.class.cast(o)).longValue()) : String.format("% .8f", ((Number)Number.class.cast(o)).doubleValue());
        } else if (o instanceof Date) {
            Date dt = (Date)Date.class.cast(o);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dt);
            SimpleDateFormat fmt = new SimpleDateFormat(cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 ? "yyyy-MM-dd" : "yyyy-MM-dd'T'HH:mm:ssXXX");
            s = fmt.format(dt);
        } else {
            s = o != null ? String.valueOf(o) : "";
        }
        return s;
    }

    public static DataFrame<Object> readCsv(String file) throws IOException {
        return Serialization.readCsv(file.contains("://") ? new URL(file).openStream() : new FileInputStream(file), ",", DataFrame.NumberDefault.LONG_DEFAULT, null);
    }

    public static DataFrame<Object> readCsv(String file, String separator, DataFrame.NumberDefault numDefault) throws IOException {
        return Serialization.readCsv(file.contains("://") ? new URL(file).openStream() : new FileInputStream(file), separator, numDefault, null);
    }

    public static DataFrame<Object> readCsv(String file, String separator, DataFrame.NumberDefault numDefault, String naString) throws IOException {
        return Serialization.readCsv(file.contains("://") ? new URL(file).openStream() : new FileInputStream(file), separator, numDefault, naString);
    }

    public static DataFrame<Object> readCsv(String file, String separator, DataFrame.NumberDefault numDefault, String naString, boolean hasHeader, Class<?> ... columnTypes) throws IOException {
        return Serialization.readCsv(file.contains("://") ? new URL(file).openStream() : new FileInputStream(file), separator, numDefault, naString, hasHeader, columnTypes);
    }

    public static DataFrame<Object> readCsv(InputStream input) throws IOException {
        return Serialization.readCsv(input, ",", DataFrame.NumberDefault.LONG_DEFAULT, null);
    }

    public static DataFrame<Object> readCsv(InputStream input, String separator, DataFrame.NumberDefault numDefault, String naString) throws IOException {
        return Serialization.readCsv(input, separator, numDefault, naString, true, new Class[0]);
    }

    public static DataFrame<Object> readCsv(InputStream input, String separator, DataFrame.NumberDefault numDefault, String naString, boolean hasHeader, Class<?> ... columnTypes) throws IOException {
        CsvPreference csvPreference;
        switch (separator) {
            case "\\t": {
                csvPreference = CsvPreference.TAB_PREFERENCE;
                break;
            }
            case ",": {
                csvPreference = CsvPreference.STANDARD_PREFERENCE;
                break;
            }
            case ";": {
                csvPreference = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
                break;
            }
            case "|": {
                csvPreference = new CsvPreference.Builder('\"', 124, NEWLINE).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Separator: " + separator + " is not currently supported");
            }
        }
        try (CsvListReader reader = new CsvListReader((Reader)new InputStreamReader(input), csvPreference);){
            DataFrame<Object> dataFrame;
            DataFrame<Object> df;
            CellProcessor[] procs;
            List<String> header;
            if (hasHeader) {
                header = Arrays.asList(reader.getHeader(true));
                procs = new CellProcessor[header.size()];
                df = new DataFrame<Object>((Collection<?>)header);
            } else {
                reader.read();
                header = new ArrayList<String>();
                for (int i = 0; i < reader.length(); ++i) {
                    header.add("V" + i);
                }
                procs = new CellProcessor[header.size()];
                df = new DataFrame((Collection<?>)header);
                df.append(reader.executeProcessors(procs));
            }
            List row = reader.read(procs);
            while (row != null) {
                df.append(new ArrayList(row));
                row = reader.read(procs);
            }
            if (columnTypes.length > 0) {
                dataFrame = df.convert(columnTypes);
                return dataFrame;
            }
            dataFrame = df.convert(numDefault, naString);
            return dataFrame;
        }
    }

    public static <V> void writeCsv(DataFrame<V> df, String output) throws IOException {
        Serialization.writeCsv(df, new FileOutputStream(output));
    }

    public static <V> void writeCsv(DataFrame<V> df, OutputStream output) throws IOException {
        try (CsvListWriter writer = new CsvListWriter((Writer)new OutputStreamWriter(output), CsvPreference.STANDARD_PREFERENCE);){
            String[] header = new String[df.size()];
            Iterator<Object> it = df.columns().iterator();
            for (int c = 0; c < df.size(); ++c) {
                header[c] = String.valueOf(it.hasNext() ? it.next() : Integer.valueOf(c));
            }
            writer.writeHeader(header);
            CellProcessor[] procs = new CellProcessor[df.size()];
            List<Class<?>> types = df.types();
            for (int c = 0; c < df.size(); ++c) {
                Class<?> clazz = types.get(c);
                procs[c] = Date.class.isAssignableFrom(clazz) ? new ConvertNullTo((Object)"", (CellProcessor)new FmtDate("yyyy-MM-dd'T'HH:mm:ssXXX")) : (String.class.isAssignableFrom(clazz) ? new ConvertNullTo((Object)"", (CellProcessor)new FmtString()) : new ConvertNullTo((Object)""));
            }
            for (List list : df) {
                writer.write(list, procs);
            }
        }
    }

    public static DataFrame<Object> readXls(String file) throws IOException {
        return Serialization.readXls(file.contains("://") ? new URL(file).openStream() : new FileInputStream(file));
    }

    public static DataFrame<Object> readXls(InputStream input) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook(input);
        Sheet sheet = wb.getSheetAt(0);
        ArrayList<Object> columns = new ArrayList<Object>();
        ArrayList data = new ArrayList();
        for (Row row : sheet) {
            if (row.getRowNum() == 0) {
                for (Cell cell : row) {
                    columns.add(Serialization.readCell(cell));
                }
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Cell cell : row) {
                arrayList.add(Serialization.readCell(cell));
            }
            data.add(arrayList);
        }
        DataFrame df = new DataFrame((Collection<?>)columns);
        for (List list : data) {
            df.append(list);
        }
        return df.convert();
    }

    public static <V> void writeXls(DataFrame<V> df, String output) throws IOException {
        Serialization.writeXls(df, new FileOutputStream(output));
    }

    public static <V> void writeXls(DataFrame<V> df, OutputStream output) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(0);
        Iterator<Object> it = df.columns().iterator();
        for (int c = 0; c < df.size(); ++c) {
            Cell cell = row.createCell(c);
            Serialization.writeCell(cell, it.hasNext() ? it.next() : Integer.valueOf(c));
        }
        for (int r = 0; r < df.length(); ++r) {
            row = sheet.createRow(r + 1);
            for (int c = 0; c < df.size(); ++c) {
                Cell cell = row.createCell(c);
                Serialization.writeCell(cell, df.get(r, c));
            }
        }
        wb.write(output);
        output.close();
    }

    private static final Object readCell(Cell cell) {
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateUtil.getJavaDate((double)cell.getNumericCellValue());
                }
                return cell.getNumericCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return cell.getStringCellValue();
    }

    private static final void writeCell(Cell cell, Object value) {
        if (value instanceof Number) {
            cell.setCellType(0);
            cell.setCellValue(((Number)Number.class.cast(value)).doubleValue());
        } else if (value instanceof Date) {
            CellStyle style = cell.getSheet().getWorkbook().createCellStyle();
            style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            cell.setCellStyle(style);
            cell.setCellType(0);
            cell.setCellValue((Date)Date.class.cast(value));
        } else if (value instanceof Boolean) {
            cell.setCellType(4);
        } else {
            cell.setCellType(1);
            cell.setCellValue(value != null ? String.valueOf(value) : "");
        }
    }

    public static DataFrame<Object> readSql(ResultSet rs) throws SQLException {
        return Serialization.readSql(rs, null, null, null);
    }

    public static DataFrame<Object> readSql(ResultSet rs, DataFrame.TagFunction<Object> tagfunction, List<String> indexList) throws SQLException {
        return Serialization.readSql(rs, tagfunction, null, indexList);
    }

    public static DataFrame<Object> readSql(ResultSet rs, DataFrame.TagFunction<Object> tagfunction, DataFrame.IndexFunction<Object> idxFunction) throws SQLException {
        return Serialization.readSql(rs, tagfunction, idxFunction, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DataFrame<Object> readSql(ResultSet rs, DataFrame.TagFunction<Object> tagfunction, DataFrame.IndexFunction<Object> idxFunction, List<String> indexList) throws SQLException {
        try {
            ResultSetMetaData md = rs.getMetaData();
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                columns.add(md.getColumnLabel(i));
            }
            ArrayList<String> dataFrameCols = new ArrayList<String>();
            dataFrameCols.addAll(Collections.nCopies(columns.size(), null));
            Collections.copy(dataFrameCols, columns);
            if (tagfunction != null) {
                tagfunction.tagColumn(dataFrameCols);
            }
            DataFrame<Object> df = null;
            df = idxFunction != null || indexList == null || indexList.size() < 1 ? new DataFrame((Collection<?>)dataFrameCols) : new DataFrame(indexList, dataFrameCols);
            ArrayList<String> row = new ArrayList<String>(columns.size());
            while (rs.next()) {
                for (String c : columns) {
                    row.add(rs.getString(c));
                }
                if (tagfunction != null) {
                    tagfunction.tagAction(columns, row);
                }
                if (idxFunction != null) {
                    Object indexName = idxFunction.indexAction(columns, row);
                    df.append(indexName, row);
                } else {
                    df.append(row);
                }
                row.clear();
            }
            DataFrame dataFrame = df;
            return dataFrame;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> void writeSql(DataFrame<V> df, PreparedStatement stmt) throws SQLException {
        try {
            ParameterMetaData md = stmt.getParameterMetaData();
            ArrayList<Integer> columns = new ArrayList<Integer>();
            for (int i = 1; i <= md.getParameterCount(); ++i) {
                columns.add(md.getParameterType(i));
            }
            for (int r = 0; r < df.length(); ++r) {
                for (int c = 1; c <= df.size(); ++c) {
                    stmt.setObject(c, df.get(r, c - 1));
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            stmt.close();
        }
    }
}

