/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component;

import com.easy.DataFrame;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Timeseries {
    public static <V> DataFrame<V> rollapply(DataFrame<V> df, DataFrame.Function<List<V>, V> function, int period) {
        ArrayList data = new ArrayList(df.size());
        WindowFunction<V> f = new WindowFunction<V>(function, period);
        for (int c = 0; c < df.size(); ++c) {
            ArrayList column = new ArrayList(df.length());
            for (int r = 0; r < df.length(); ++r) {
                column.add(f.apply(df.get(r, c)));
            }
            data.add(column);
            f.reset();
        }
        return new DataFrame(df.index(), df.columns(), data);
    }

    public static <V> DataFrame<V> diff(DataFrame<V> df, int period) {
        DataFrame nonnumeric = df.nonnumeric();
        DataFrame diff = df.numeric().apply(new WindowFunction(new DiscreteDifferenceFunction(), period));
        return nonnumeric.isEmpty() ? diff : nonnumeric.join(diff);
    }

    public static <V> DataFrame<V> percentChange(DataFrame<V> df, int period) {
        DataFrame nonnumeric = df.nonnumeric();
        DataFrame diff = df.numeric().apply(new WindowFunction(new PercentChangeFunction(), period));
        return nonnumeric.isEmpty() ? diff : nonnumeric.join(diff);
    }

    private static class PercentChangeFunction
    implements DataFrame.Function<List<Number>, Number> {
        private PercentChangeFunction() {
        }

        @Override
        public Number apply(List<Number> values) {
            if (values.contains(null)) {
                return null;
            }
            double x1 = values.get(0).doubleValue();
            double x2 = values.get(values.size() - 1).doubleValue();
            return (x2 - x1) / x1;
        }
    }

    private static class DiscreteDifferenceFunction
    implements DataFrame.Function<List<Number>, Number> {
        private DiscreteDifferenceFunction() {
        }

        @Override
        public Number apply(List<Number> values) {
            if (values.contains(null)) {
                return null;
            }
            return values.get(values.size() - 1).doubleValue() - values.get(0).doubleValue();
        }
    }

    private static class WindowFunction<V>
    implements DataFrame.Function<V, V> {
        private final DataFrame.Function<List<V>, V> function;
        private final int period;
        protected final LinkedList<V> window;

        private WindowFunction(DataFrame.Function<List<V>, V> function, int period) {
            this.function = function;
            this.period = period;
            this.window = new LinkedList();
        }

        @Override
        public V apply(V value) {
            while (this.window.size() < this.period) {
                this.window.add(null);
            }
            this.window.add(value);
            V result = this.function.apply(this.window);
            this.window.remove();
            return result;
        }

        public void reset() {
            this.window.clear();
        }
    }
}

