/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils;

import com.easy.component.utils.ReleaseObject;
import com.easy.component.utils.sql.SQLBaseDataFrame;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class DBUtils
extends SQLBaseDataFrame {
    private static DBUtils service;

    private static synchronized void initInstance() {
        if (service == null) {
            service = new DBUtils();
        }
    }

    public static DBUtils getInstance() {
        if (service == null) {
            DBUtils.initInstance();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onGenerateTemporaryTable(Connection conn, String querySQL, String tableName) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer buffer = new StringBuffer();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(querySQL);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String colName = rsmd.getColumnLabel(i + 1);
                String colType = rsmd.getColumnTypeName(i + 1);
                int colWidth = rsmd.getPrecision(i + 1);
                int colScale = rsmd.getScale(i + 1);
                System.out.println(String.format("colname:%1$s coltype:%2$s colwidth:%3$d colscale:%4$d", colName, colType, colWidth, colScale));
                buffer.append(String.format("\t%1$-30s%2$s%3$s\r\n", colName, this.onConvertDbType(colType, colWidth, colScale), i + 1 < rsmd.getColumnCount() ? "," : ""));
            }
        }
        catch (Throwable throwable) {
            ReleaseObject.release(rs);
            ReleaseObject.release(stmt);
            throw throwable;
        }
        ReleaseObject.release(rs);
        ReleaseObject.release(stmt);
        return String.format("CREATE TEMPORARY TABLE %1$s\r\n(\r\n%2$s)", tableName, buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onGenerateTableInsert(Connection conn, String querySQL, String tableName, int breakColCount) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer columnBuffer = new StringBuffer();
        StringBuffer bindBuffer = new StringBuffer();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(querySQL);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String colName = rsmd.getColumnLabel(i + 1);
                String colType = rsmd.getColumnTypeName(i + 1);
                String breakString = "";
                if (breakColCount > 0 && (i + 1) % breakColCount == 0 && i + 1 < rsmd.getColumnCount()) {
                    breakString = "\r\n";
                }
                columnBuffer.append(String.format("%1$s%2$s%3$s", colName, i + 1 < rsmd.getColumnCount() ? "," : "", breakString));
                bindBuffer.append(String.format("${%1$s,%2$s}%3$s%4$s", colName, this.onConvertBeanType(colType), i + 1 < rsmd.getColumnCount() ? "," : "", breakString));
            }
        }
        catch (Throwable throwable) {
            ReleaseObject.release(rs);
            ReleaseObject.release(stmt);
            throw throwable;
        }
        ReleaseObject.release(rs);
        ReleaseObject.release(stmt);
        return String.format("INSERT INTO %1$s(%2$s)\r\nVALUES(%3$s)", tableName, columnBuffer.toString(), bindBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onCreateModel(Connection conn, String querySQL, String modelName) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer buffer = new StringBuffer();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(querySQL);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                String colName = rsmd.getColumnLabel(i + 1);
                String colType = rsmd.getColumnTypeName(i + 1);
                System.out.println(String.format("colname:%1$s coltype:%2$s", colName, colType));
                buffer.append(String.format("\t%1$-30s%2$s;\r\n", this.onConvertBeanType(colType), colName));
            }
        }
        catch (Throwable throwable) {
            ReleaseObject.release(rs);
            ReleaseObject.release(stmt);
            throw throwable;
        }
        ReleaseObject.release(rs);
        ReleaseObject.release(stmt);
        return String.format("public class %1$s {\r\n%2$s}\r\n", modelName, buffer.toString());
    }
}

