/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.sql;

import com.alibaba.fastjson.util.TypeUtils;
import com.easy.component.utils.ClassMapper;
import com.easy.component.utils.ReleaseObject;
import com.easy.component.utils.sql.SQLBaseAssist;
import com.easy.component.utils.sql.SQLBaseParser;
import com.easy.entity.ExpertReponse;
import com.easy.intf.FieldHandler;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBaseAction
extends SQLBaseAssist {
    private static final Logger log = LoggerFactory.getLogger((String)"sqlConnectionLogger");
    private Map<String, HikariConfig> configMap = new ConcurrentHashMap<String, HikariConfig>();
    private Map<String, HikariDataSource> dataSourceMap = new ConcurrentHashMap<String, HikariDataSource>();

    private void logConnectionInfo(String option, String tagName, HikariConfig config) {
        String dataSourceClass = config.getDataSourceClassName();
        if (!StringUtils.isEmpty((CharSequence)config.getJdbcUrl())) {
            String jdbcURL = config.getJdbcUrl();
            log.info("{} driver: {} jdbcURL: {}", new Object[]{option, dataSourceClass, jdbcURL});
        } else {
            Properties properties = config.getDataSourceProperties();
            String serverName = properties.getProperty("serverName");
            String serverPort = properties.getProperty("port");
            String dbName = properties.getProperty("databaseName");
            log.info("{} driver: {} jdbcURL: {}:{}@{}", new Object[]{option, dataSourceClass, serverName, serverPort, dbName});
        }
    }

    private synchronized void addConfig(String tagName, HikariConfig config) {
        this.logConnectionInfo("addConfig", tagName, config);
        this.configMap.put(tagName, config);
    }

    public void addMySQLConfig(String tagName, int maxPoolSize, String jdbcURL, String userName, String userPass) {
        String driverClass = "com.mysql.jdbc.Driver";
        this.addConfig(tagName, maxPoolSize, driverClass, jdbcURL, userName, userPass);
    }

    public void addMySQLConfig(String tagName, int maxPoolSize, String serverName, int dbPort, String dbName, String userName, String userPass) {
        String dataSourceClass = "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
        this.addConfig(tagName, maxPoolSize, dataSourceClass, dbName, dbPort, dbName, userName, userPass);
    }

    public void addConfig(String tagName, int maxPoolSize, String dataSourceClass, String serverName, int dbPort, String dbName, String userName, String userPass) {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(maxPoolSize);
        config.setDataSourceClassName(dataSourceClass);
        config.addDataSourceProperty("serverName", (Object)serverName);
        config.addDataSourceProperty("port", (Object)Integer.toString(dbPort));
        config.addDataSourceProperty("databaseName", (Object)dbName);
        config.addDataSourceProperty("user", (Object)userName);
        config.addDataSourceProperty("password", (Object)userPass);
        this.addConfig(tagName, config);
    }

    public void addConfig(String tagName, int maxPoolSize, String driverClass, String jdbcURL, String userName, String userPass) {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(maxPoolSize);
        config.setDriverClassName(driverClass);
        config.setJdbcUrl(jdbcURL);
        config.setUsername(userName);
        config.setPassword(userPass);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.setConnectionTimeout(28800L);
        this.addConfig(tagName, config);
    }

    private HikariConfig getConfig(String tagName) {
        if (this.configMap == null || !this.configMap.containsKey(tagName)) {
            throw new RuntimeException(String.format("tagName:%1$s is not init", tagName));
        }
        return this.configMap.get(tagName);
    }

    public boolean hasConfig(String tagName) {
        return this.configMap != null || this.configMap.containsKey(tagName);
    }

    public Connection getConnection(String tagName) throws SQLException {
        HikariConfig config = this.getConfig(tagName);
        this.logConnectionInfo("getConnection", tagName, config);
        if (this.dataSourceMap.containsKey(tagName)) {
            HikariDataSource dataSource = this.dataSourceMap.get(tagName);
            return dataSource.getConnection();
        }
        HikariDataSource dataSource = new HikariDataSource(config);
        this.dataSourceMap.put(tagName, dataSource);
        return dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> onQuery(String tagName, String querySQL, T model) throws Exception {
        try (Connection conn = this.getConnection(tagName);){
            List<T> list = this.onQuery(conn, querySQL, model);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> onQuery(Connection conn, String querySQL, T model) throws Exception {
        ArrayList response = new ArrayList();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            HashBasedTable paramsTable = HashBasedTable.create();
            String statement = SQLBaseAction.onParamsObject(querySQL, (Table<Integer, String, Object>)paramsTable);
            if (!paramsTable.isEmpty()) {
                pstmt = conn.prepareStatement(statement);
                SQLBaseAction.onParamsSet(pstmt, (Table<Integer, String, Object>)paramsTable, model);
                rs = pstmt.executeQuery();
                logger.warn("PreparedStatement Query:{}", (Object)statement);
            } else {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(statement);
                logger.warn("Statement Query:{}", (Object)statement);
            }
            if (rs != null) {
                ResultSetMetaData rsmd = rs.getMetaData();
                HashBasedTable resultTable = HashBasedTable.create();
                for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                    String colName = rsmd.getColumnLabel(i + 1);
                    String colType = rsmd.getColumnTypeName(i + 1);
                    resultTable.put((Object)i, (Object)"colName", (Object)colName);
                    resultTable.put((Object)i, (Object)"colType", (Object)colType);
                }
                ClassMapper.onFieldMapper(model, new FieldHandler((Table)resultTable){
                    final /* synthetic */ Table val$resultTable;
                    {
                        this.val$resultTable = table;
                    }

                    @Override
                    public boolean action(Field field) throws Exception {
                        for (int i = 0; i < this.val$resultTable.rowMap().size(); ++i) {
                            String colName = TypeUtils.castToString((Object)this.val$resultTable.get((Object)i, (Object)"colName"));
                            if (!field.getName().equalsIgnoreCase(colName)) continue;
                            field.setAccessible(true);
                            this.val$resultTable.put((Object)i, (Object)"sField", (Object)field);
                            break;
                        }
                        return false;
                    }
                });
                while (rs.next()) {
                    Object row = model.getClass().newInstance();
                    for (int i = 0; i < resultTable.rowMap().size(); ++i) {
                        Object value = rs.getObject(i + 1);
                        if (value == null) continue;
                        Class<?> dbType = value.getClass();
                        if (!resultTable.contains((Object)i, (Object)"sField")) continue;
                        Field field = (Field)resultTable.get((Object)i, (Object)"sField");
                        if (!field.getType().equals(dbType)) {
                            field.set(row, this.onConvert(value, field.getType()));
                            continue;
                        }
                        field.set(row, value);
                    }
                    response.add(row);
                }
            }
        }
        catch (Throwable throwable) {
            ReleaseObject.release(rs);
            ReleaseObject.release(stmt);
            ReleaseObject.release(pstmt);
            throw throwable;
        }
        ReleaseObject.release(rs);
        ReleaseObject.release(stmt);
        ReleaseObject.release(pstmt);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean onUpdate(String tagName, String updateSQL, T model) throws Exception {
        try (Connection conn = this.getConnection(tagName);){
            boolean bl = this.onUpdate(conn, updateSQL, model);
            return bl;
        }
    }

    public <T> boolean onUpdate(Connection conn, String updateSQL, T model) throws Exception {
        ExpertReponse<Object> response = this.onUpdateAndReturn(conn, updateSQL, model);
        return response.isSuccessful();
    }

    public <T> ExpertReponse<Object> onUpdateAndReturn(Connection conn, String updateSQL, T model) throws Exception {
        ExpertReponse<Object> response;
        Statement stmt;
        PreparedStatement pstmt;
        block8: {
            boolean state = false;
            pstmt = null;
            stmt = null;
            response = new ExpertReponse<Object>();
            HashBasedTable paramsTable = HashBasedTable.create();
            String statement = SQLBaseAction.onParamsObject(updateSQL, (Table<Integer, String, Object>)paramsTable);
            try {
                if (!paramsTable.isEmpty()) {
                    pstmt = conn.prepareStatement(statement);
                    SQLBaseAction.onParamsSet(pstmt, (Table<Integer, String, Object>)paramsTable, model);
                    state = pstmt.execute();
                    if (state) {
                        response.setSuccessful(state, pstmt.getResultSet());
                        logger.warn("PreparedStatement Update SQL:{}", (Object)updateSQL);
                    } else {
                        int updateCount = pstmt.getUpdateCount();
                        response.setSuccessful(state, updateCount);
                        logger.warn("PreparedStatement Update Count:{} SQL:{}", (Object)updateCount, (Object)updateSQL);
                    }
                    break block8;
                }
                stmt = conn.createStatement();
                state = stmt.execute(statement);
                if (state) {
                    response.setSuccessful(state, stmt.getResultSet());
                    logger.warn("Statement Update SQL:{}", (Object)updateSQL);
                    break block8;
                }
                int updateCount = stmt.getUpdateCount();
                response.setSuccessful(state, updateCount);
                logger.warn("Statement Update Count:{} SQL:{}", (Object)updateCount, (Object)updateSQL);
            }
            catch (Exception e) {
                try {
                    logger.error("\u6267\u884cSQL:{} \u53d1\u751f\u5f02\u5e38:{}", (Object)updateSQL, (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    ReleaseObject.release(stmt);
                    ReleaseObject.release(pstmt);
                    throw throwable;
                }
            }
        }
        ReleaseObject.release(stmt);
        ReleaseObject.release(pstmt);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int[] onUpdate(Connection conn, String updateSQL, List<T> modelList) throws Exception {
        String statement;
        Statement stmt;
        PreparedStatement pstmt;
        block4: {
            int[] nArray;
            pstmt = null;
            stmt = null;
            try {
                HashBasedTable paramsTable = HashBasedTable.create();
                statement = SQLBaseParser.onParamsObject(updateSQL, (Table<Integer, String, Object>)paramsTable);
                if (paramsTable.isEmpty()) break block4;
                pstmt = conn.prepareStatement(statement);
                for (T model : modelList) {
                    SQLBaseAction.onParamsSet(pstmt, (Table<Integer, String, Object>)paramsTable, model);
                    pstmt.addBatch();
                }
                int[] batchResult = pstmt.executeBatch();
                logger.warn("PreparedStatement BatchUpdate SQL:{}", (Object)updateSQL);
                nArray = batchResult;
            }
            catch (Throwable throwable) {
                ReleaseObject.release(stmt);
                ReleaseObject.release(pstmt);
                throw throwable;
            }
            ReleaseObject.release(stmt);
            ReleaseObject.release(pstmt);
            return nArray;
        }
        stmt = conn.createStatement();
        int returnSize = stmt.executeUpdate(statement);
        logger.warn("Statement Update SQL:{}", (Object)updateSQL);
        int[] nArray = new int[]{returnSize};
        ReleaseObject.release(stmt);
        ReleaseObject.release(pstmt);
        return nArray;
    }

    private String toSQL(String statement, Map<Integer, Object> traceMap) {
        Pattern pattern = Pattern.compile("[?]");
        Matcher matcher = pattern.matcher(statement);
        StringBuffer content = new StringBuffer();
        Integer index = 0;
        while (matcher.find()) {
            Object value = traceMap.get(index = Integer.valueOf(index + 1));
            value = value == null ? "null" : (value instanceof Date ? String.format("'%1$s'", formatter.format((Date)value)) : (value instanceof String ? String.format("'%1$s'", TypeUtils.castToString((Object)value)) : TypeUtils.castToString((Object)value)));
            matcher.appendReplacement(content, value.toString());
        }
        matcher.appendTail(content);
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<Integer, Integer> onUpsert(Connection conn, String updateSQL, String insertSQL, List<T> modelList) throws Exception {
        Integer insertCount;
        Integer updateCount;
        HashMap<Integer, Integer> responseMap;
        Statement stmt;
        PreparedStatement pUpdateStmt;
        block9: {
            PreparedStatement pInsertStmt = null;
            pUpdateStmt = null;
            stmt = null;
            responseMap = new HashMap<Integer, Integer>();
            updateCount = 0;
            insertCount = 0;
            HashBasedTable updateParamsTable = HashBasedTable.create();
            String updateStatement = SQLBaseAction.onParamsObject(updateSQL, (Table<Integer, String, Object>)updateParamsTable);
            HashBasedTable insertParamsTable = HashBasedTable.create();
            String insertStatement = SQLBaseAction.onParamsObject(insertSQL, (Table<Integer, String, Object>)insertParamsTable);
            try {
                if (!updateParamsTable.isEmpty()) {
                    pUpdateStmt = conn.prepareStatement(updateStatement);
                    pInsertStmt = conn.prepareStatement(insertStatement);
                    for (T model : modelList) {
                        HashMap<Integer, Object> traceMap = new HashMap<Integer, Object>();
                        SQLBaseAction.onParamsSet(pUpdateStmt, (Table<Integer, String, Object>)updateParamsTable, model, traceMap);
                        boolean bState = pUpdateStmt.execute();
                        if (bState) continue;
                        int rowCount = pUpdateStmt.getUpdateCount();
                        if (logger.isInfoEnabled()) {
                            logger.info("PreparedStatement Update SQL:{}", (Object)this.toSQL(updateStatement, traceMap));
                        } else {
                            logger.warn("PreparedStatement Update SQL:{}", (Object)updateStatement);
                        }
                        if (rowCount < 1) {
                            SQLBaseAction.onParamsSet(pInsertStmt, (Table<Integer, String, Object>)insertParamsTable, model, traceMap);
                            bState = pInsertStmt.execute();
                            if (bState) continue;
                            rowCount = pInsertStmt.getUpdateCount();
                            if (logger.isInfoEnabled()) {
                                logger.info("PreparedStatement Update SQL:{}", (Object)this.toSQL(insertStatement, traceMap));
                            } else {
                                logger.warn("PreparedStatement UpdateInsert SQL:{}", (Object)insertStatement);
                            }
                            insertCount = insertCount + rowCount;
                            continue;
                        }
                        updateCount = updateCount + rowCount;
                    }
                    break block9;
                }
                stmt = conn.createStatement();
                stmt.execute(updateStatement);
                logger.warn("Statement Update SQL:{}", (Object)updateStatement);
            }
            catch (Throwable throwable) {
                ReleaseObject.release(stmt);
                ReleaseObject.release(pUpdateStmt);
                throw throwable;
            }
        }
        ReleaseObject.release(stmt);
        ReleaseObject.release(pUpdateStmt);
        responseMap.put(1, updateCount);
        responseMap.put(2, insertCount);
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onExecuteDDL(Connection conn, String statement) throws Exception {
        boolean response = false;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            response = stmt.execute(statement);
            logger.warn("Statement DDL:{}", (Object)statement);
        }
        finally {
            ReleaseObject.release(stmt);
        }
        return response;
    }
}

