/*
 * Decompiled with CFR 0.152.
 */
package com.easy.component.utils.sql;

import com.alibaba.fastjson.util.TypeUtils;
import com.easy.component.utils.ClassMapper;
import com.easy.component.utils.field.convert.FieldTypeConvert;
import com.easy.component.utils.sql.SQLBaseAction;
import com.easy.component.utils.sql.SQLBaseParser;
import com.easy.component.utils.sql.convert.DatabaseTypeConvert;
import com.easy.constant.VARTYPE;
import com.easy.intf.FieldHandler;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class SQLBaseAssist
extends SQLBaseParser {
    public static <T> Object onParamsGet(final String colName, final T model) throws Exception {
        if (model != null) {
            if (model instanceof Map) {
                Map row = (Map)model;
                if (row.containsKey(colName)) {
                    return row.get(colName);
                }
            } else {
                final ArrayList response = new ArrayList();
                ClassMapper.onFieldMapper(model, new FieldHandler(){

                    @Override
                    public boolean action(Field field) throws Exception {
                        if (field.getName().equalsIgnoreCase(colName)) {
                            field.setAccessible(true);
                            response.add(field.get(model));
                            return true;
                        }
                        return false;
                    }
                });
                if (response.size() > 0) {
                    return response.get(0);
                }
            }
        }
        return null;
    }

    public static <T> void onParamsSet(PreparedStatement pstmt, int parameterIndex, String colName, VARTYPE colType, T model) throws Exception {
        SQLBaseAssist.onParamsSet(pstmt, parameterIndex, colName, colType, model, null);
    }

    public static <T> void onParamsSet(PreparedStatement pstmt, int parameterIndex, String colName, VARTYPE colType, T model, Map<Integer, Object> traceMap) throws Exception {
        Object value = SQLBaseAction.onParamsGet(colName, model);
        if (traceMap != null) {
            traceMap.put(parameterIndex, value);
        }
        DatabaseTypeConvert.Create(colType, pstmt).onSetValue(parameterIndex, value);
    }

    protected static <T> void onParamsSet(PreparedStatement pstat, Table<Integer, String, Object> table, T model) throws Exception {
        SQLBaseAssist.onParamsSet(pstat, table, model, null);
    }

    protected static <T> void onParamsSet(PreparedStatement pstat, Table<Integer, String, Object> table, T model, Map<Integer, Object> traceMap) throws Exception {
        for (int i = 0; i < table.rowMap().size(); ++i) {
            String colName = TypeUtils.castToString((Object)table.get((Object)i, (Object)"colName"));
            VARTYPE colType = VARTYPE.valueOf(TypeUtils.castToString((Object)table.get((Object)i, (Object)"colType")));
            try {
                SQLBaseAction.onParamsSet(pstat, i + 1, colName, colType, model, traceMap);
                continue;
            }
            catch (Exception e) {
                System.out.println(String.format("Query paramsSet %1$s(%2$s) Msg:%3$s", new Object[]{colName, colType, e.getLocalizedMessage()}));
                throw e;
            }
        }
    }

    protected <T> T onConvert(Object source, Class<?> beanType) {
        if (source instanceof Timestamp && Date.class.equals(beanType)) {
            return (T)TypeUtils.castToDate((Object)source);
        }
        if (source instanceof Integer && Boolean.class.equals(beanType)) {
            return (T)TypeUtils.castToBoolean((Object)source);
        }
        if (source instanceof Boolean && Integer.class.equals(beanType)) {
            return (T)(TypeUtils.castToBoolean((Object)source) != false ? Integer.valueOf(1) : Integer.valueOf(0));
        }
        System.out.println(String.format("Convert:%1$s to %2$s", source.getClass().getName(), beanType.getTypeName()));
        return (T)source;
    }

    protected void onFieldSet(Object source, Field field, Object value) throws Exception {
        FieldTypeConvert.Create(field).onSetValue(source, value);
    }

    protected String onConvertBeanType(String dbType) {
        if ("BIGINT".equalsIgnoreCase(dbType)) {
            return "Long";
        }
        if ("VARCHAR".equalsIgnoreCase(dbType)) {
            return "String";
        }
        if ("INT".equalsIgnoreCase(dbType)) {
            return "Integer";
        }
        if ("TINYINT".equalsIgnoreCase(dbType)) {
            return "Integer";
        }
        if ("DECIMAL".equalsIgnoreCase(dbType)) {
            return "Double";
        }
        if ("DOUBLE".equalsIgnoreCase(dbType)) {
            return "Double";
        }
        if ("FLOAT".equalsIgnoreCase(dbType)) {
            return "Float";
        }
        if ("SMALLINT".equalsIgnoreCase(dbType)) {
            return "Boolean";
        }
        if ("DATETIME".equalsIgnoreCase(dbType)) {
            return "Date";
        }
        if ("CHAR".equalsIgnoreCase(dbType)) {
            return "String";
        }
        return "@String";
    }

    protected String onConvertDbType(String dbType, int precision, int scale) {
        if ("BIGINT".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        if ("VARCHAR".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        if ("INT".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        if ("TINYINT".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        if ("DECIMAL".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d,%3$d)", dbType, precision, scale);
        }
        if ("DOUBLE".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d,%3$d)", dbType, precision, scale);
        }
        if ("FLOAT".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d,%3$d)", dbType, precision, scale);
        }
        if ("SMALLINT".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        if ("DATETIME".equalsIgnoreCase(dbType)) {
            return "DATETIME";
        }
        if ("CHAR".equalsIgnoreCase(dbType)) {
            return String.format("%1$s(%2$d)", dbType, precision);
        }
        return "@String";
    }
}

