/*
 * Decompiled with CFR 0.152.
 */
package com.easy.util;

import com.easy.DataFrame;
import com.easy.component.SparseBitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DataFrameUtils {
    public static <V, U> DataFrame<V> transform(DataFrame<U> dataFrame, final RowTrasformFunction<U, V> function) {
        final DataRowSelector<U> selector = new DataRowSelector<U>(dataFrame);
        DataFrame transformed = dataFrame.transform(new DataFrame.RowFunction<U, V>(){

            @Override
            public List<List<V>> apply(List<U> values) {
                selector.init(values);
                return function.apply(selector, values);
            }
        });
        return transformed;
    }

    public static <T> DataFrame<T> select(DataFrame<T> dataFrame, final RowSelectFunction<T> function, boolean resetIndex) {
        final DataRowSelector<T> selector = new DataRowSelector<T>(dataFrame);
        DataFrame<T> selected = dataFrame.select(new DataFrame.Predicate<T>(){

            @Override
            public Boolean apply(List<T> values) {
                selector.init(values);
                return function.apply(selector, values);
            }
        });
        if (resetIndex) {
            return selected.resetIndex();
        }
        return selected;
    }

    public static <T> DataFrame<T> aggregate(DataFrame<T> dataFrame, final AggregateFunction<T> function, boolean resetIndex) {
        final AggregateSelector<T> selector = new AggregateSelector<T>(dataFrame);
        DataFrame<T> dfAggregate = dataFrame.aggregate(new DataFrame.Aggregate<T, T>(){

            @Override
            public T apply(List<T> values) {
                selector.next();
                return function.apply(selector, values);
            }
        });
        if (resetIndex) {
            return dfAggregate.resetIndex();
        }
        return dfAggregate;
    }

    public static class DataRowSelector<T>
    implements SelectorHandler<T> {
        private List<T> dataList = new ArrayList<T>();
        private Map<Object, Integer> columnMap = new HashMap<Object, Integer>();

        public DataRowSelector(DataFrame<T> dataFrame) {
            int i = 0;
            for (Object columnName : dataFrame.columns()) {
                this.columnMap.put(columnName, i++);
            }
        }

        @Override
        public void init(List<T> values) {
            this.dataList.clear();
            this.dataList.addAll(values);
        }

        @Override
        public List<T> get() {
            ArrayList<T> response = new ArrayList<T>();
            response.addAll(this.dataList);
            return response;
        }

        private Integer valid(Object columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("\u5217\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            Integer index = this.columnMap.get(columnName);
            if (index == null || index < 0) {
                throw new IllegalArgumentException(String.format("\u5217[%1$s]\u4e0d\u5b58\u5728", columnName));
            }
            return index;
        }

        @Override
        public T getValue(Object columnName) {
            Integer index = this.valid(columnName);
            return this.dataList.get(index);
        }

        @Override
        public void setValue(Object columnName, T value) {
            Integer index = this.valid(columnName);
            this.dataList.set(index, value);
        }
    }

    public static class AggregateSelector<T>
    implements AggregateHandler<T> {
        private Map<Object, Integer> columnAllMap = new HashMap<Object, Integer>();
        private Map<Integer, Object> columnAggMap = new HashMap<Integer, Object>();
        private List<Object> columnGroup = new ArrayList<Object>();
        private List<Object> groupList = new ArrayList<Object>();
        private AtomicInteger counter = new AtomicInteger(-1);

        public AggregateSelector(DataFrame<T> dataFrame) {
            Set<Object> originalColumns = dataFrame.columns();
            Set<Integer> groupColumns = dataFrame.groups().columns();
            int i = 0;
            for (Object columnName : originalColumns) {
                this.columnAllMap.put(columnName, i);
                if (groupColumns.contains(i)) {
                    this.columnGroup.add(columnName);
                } else {
                    this.columnAggMap.put(this.columnAggMap.size(), columnName);
                }
                ++i;
            }
            for (Map.Entry<Object, SparseBitSet> entry : dataFrame.groups()) {
                Object groupValue = entry.getKey();
                this.groupList.add(groupValue);
            }
        }

        public Integer next() {
            return this.counter.incrementAndGet();
        }

        @Override
        public Integer getColumnIndex() {
            return this.counter.get() % this.columnAggMap.size();
        }

        @Override
        public Object getColumnName() {
            return this.columnAggMap.get(this.getColumnIndex());
        }

        @Override
        public Object getGroupColumn() {
            return this.columnGroup;
        }

        @Override
        public Object getGroupValue() {
            Integer rowIndex = this.counter.get() / this.columnAggMap.size();
            return this.groupList.get(rowIndex);
        }
    }

    @FunctionalInterface
    public static interface RowSelectFunction<T> {
        public Boolean apply(SelectorHandler<T> var1, List<T> var2);
    }

    @FunctionalInterface
    public static interface RowTrasformFunction<V, U> {
        public List<List<U>> apply(SelectorHandler<V> var1, List<V> var2);
    }

    public static interface SelectorHandler<T> {
        public void init(List<T> var1);

        public List<T> get();

        public T getValue(Object var1);

        public void setValue(Object var1, T var2);
    }

    @FunctionalInterface
    public static interface AggregateFunction<T> {
        public T apply(AggregateHandler<T> var1, List<T> var2);
    }

    public static interface AggregateHandler<T> {
        public Integer getColumnIndex();

        public Object getColumnName();

        public Object getGroupColumn();

        public Object getGroupValue();
    }
}

