/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.exception;

import org.apache.velocity.exception.ExtendedParseException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;

public class ParseErrorException
extends VelocityException {
    private static final long serialVersionUID = -6665197935086306472L;
    private int columnNumber = -1;
    private int lineNumber = -1;
    private String templateName = "*unset*";

    public ParseErrorException(String exceptionMessage) {
        super(exceptionMessage);
    }

    public ParseErrorException(ParseException pex) {
        super(pex.getMessage());
        if (pex instanceof ExtendedParseException) {
            ExtendedParseException xpex = (ExtendedParseException)((Object)pex);
            this.columnNumber = xpex.getColumnNumber();
            this.lineNumber = xpex.getLineNumber();
            this.templateName = xpex.getTemplateName();
        } else if (pex.currentToken != null && pex.currentToken.next != null) {
            this.columnNumber = pex.currentToken.next.beginColumn;
            this.lineNumber = pex.currentToken.next.beginLine;
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

