/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class Parse
extends InputBase {
    public String getName() {
        return "parse";
    }

    public int getType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object[] templateStack;
        if (!context.getAllowRendering()) {
            return true;
        }
        if (node.jjtGetChild(0) == null) {
            this.rsvc.getLog().error("#parse() null argument");
            return false;
        }
        Object value = node.jjtGetChild(0).value(context);
        if (value == null) {
            this.rsvc.getLog().error("#parse() null argument");
            return false;
        }
        String sourcearg = value.toString();
        String arg = EventHandlerUtil.includeEvent(this.rsvc, context, sourcearg, context.getCurrentTemplateName(), this.getName());
        boolean blockinput = false;
        if (arg == null) {
            blockinput = true;
        }
        if ((templateStack = context.getTemplateNameStack()).length >= this.rsvc.getInt("directive.parse.max.depth", 20)) {
            StringBuffer path = new StringBuffer();
            for (int i = 0; i < templateStack.length; ++i) {
                path.append(" > " + templateStack[i]);
            }
            this.rsvc.getLog().error("Max recursion depth reached (" + templateStack.length + ')' + " File stack:" + path);
            return false;
        }
        Template t = null;
        try {
            if (!blockinput) {
                t = this.rsvc.getTemplate(arg, this.getInputEncoding(context));
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.rsvc.getLog().error("#parse(): cannot find template '" + arg + "', called from template " + context.getCurrentTemplateName() + " at (" + this.getLine() + ", " + this.getColumn() + ")");
            throw rnfe;
        }
        catch (ParseErrorException pee) {
            this.rsvc.getLog().error("#parse(): syntax error in #parse()-ed template '" + arg + "', called from template " + context.getCurrentTemplateName() + " at (" + this.getLine() + ", " + this.getColumn() + ")");
            throw pee;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.rsvc.getLog().error("#parse() : arg = " + arg + '.', e);
            return false;
        }
        try {
            if (!blockinput) {
                context.pushCurrentTemplateName(arg);
                ((SimpleNode)t.getData()).render(context, writer);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            this.rsvc.getLog().error("Exception rendering #parse(" + arg + ')', e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!blockinput) {
                context.popCurrentTemplateName();
            }
        }
        return true;
    }
}

