/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import java.io.File;
import java.io.IOException;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.log.VelocityFormatter;

public class AvalonLogChute
implements LogChute {
    private Logger logger = null;
    private RuntimeServices rsvc = null;

    public void init(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        String name = (String)this.rsvc.getProperty("runtime.log.logsystem.avalon.logger");
        if (name != null) {
            this.logger = Hierarchy.getDefaultHierarchy().getLoggerFor(name);
        } else {
            this.logger = Hierarchy.getDefaultHierarchy().getLoggerFor(this.rsvc.toString());
            String file = (String)this.rsvc.getProperty("runtime.log");
            if (file != null && file.length() > 0) {
                this.initTarget(file);
            }
        }
    }

    private void initTarget(String file) throws Exception {
        try {
            VelocityFormatter vf = new VelocityFormatter("%{time} %{message}\\n%{throwable}");
            FileTarget target = new FileTarget(new File(file), false, (Formatter)vf);
            this.logger.setPriority(Priority.DEBUG);
            this.logger.setLogTargets(new LogTarget[]{target});
            this.log(0, "AvalonLogChute initialized using file '" + file + '\'');
        }
        catch (IOException ioe) {
            this.rsvc.getLog().warn("Unable to create log file for AvalonLogChute", ioe);
            throw new Exception("Error configuring AvalonLogChute : " + ioe);
        }
    }

    public void init(String file) throws Exception {
        this.logger = Hierarchy.getDefaultHierarchy().getLoggerFor(this.rsvc.toString());
        this.initTarget(file);
        this.log(2, "You shouldn't be using the init(String file) method!");
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn("  [warn] " + message);
                break;
            }
            case 1: {
                this.logger.info("  [info] " + message);
                break;
            }
            case 0: {
                this.logger.debug(" [debug] " + message);
                break;
            }
            case -1: {
                this.logger.debug(" [trace] " + message);
                break;
            }
            case 3: {
                this.logger.error(" [error] " + message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.logger.warn("  [warn] " + message, t);
                break;
            }
            case 1: {
                this.logger.info("  [info] " + message, t);
                break;
            }
            case 0: {
                this.logger.debug(" [debug] " + message, t);
                break;
            }
            case -1: {
                this.logger.debug(" [trace] " + message, t);
                break;
            }
            case 3: {
                this.logger.error(" [error] " + message, t);
                break;
            }
            default: {
                this.logger.info(message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case -1: 
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        this.logger.unsetLogTargets();
    }
}

