/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import org.apache.velocity.runtime.log.HoldingLogChute;
import org.apache.velocity.runtime.log.LogChute;

public class Log {
    private LogChute chute;

    public Log() {
        this.chute = new HoldingLogChute();
    }

    public Log(LogChute chute) {
        if (chute == null) {
            throw new NullPointerException("The LogChute cannot be set to null!");
        }
        this.chute = chute;
    }

    protected void setLogChute(LogChute newLogChute) {
        this.chute = newLogChute;
    }

    protected LogChute getLogChute() {
        return this.chute;
    }

    private void log(int level, Object message) {
        this.chute.log(level, String.valueOf(message));
    }

    private void log(int level, Object message, Throwable t) {
        this.chute.log(level, String.valueOf(message), t);
    }

    public boolean isTraceEnabled() {
        return this.chute.isLevelEnabled(-1);
    }

    public void trace(Object message) {
        this.log(-1, message);
    }

    public void trace(Object message, Throwable t) {
        this.log(-1, message, t);
    }

    public boolean isDebugEnabled() {
        return this.chute.isLevelEnabled(0);
    }

    public void debug(Object message) {
        this.log(0, message);
    }

    public void debug(Object message, Throwable t) {
        this.log(0, message, t);
    }

    public boolean isInfoEnabled() {
        return this.chute.isLevelEnabled(1);
    }

    public void info(Object message) {
        this.log(1, message);
    }

    public void info(Object message, Throwable t) {
        this.log(1, message, t);
    }

    public boolean isWarnEnabled() {
        return this.chute.isLevelEnabled(2);
    }

    public void warn(Object message) {
        this.log(2, message);
    }

    public void warn(Object message, Throwable t) {
        this.log(2, message, t);
    }

    public boolean isErrorEnabled() {
        return this.chute.isLevelEnabled(3);
    }

    public void error(Object message) {
        this.log(3, message);
    }

    public void error(Object message, Throwable t) {
        this.log(3, message, t);
    }
}

