/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.log;

import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class StandardOutLogChute
implements LogChute {
    public static final String RUNTIME_LOG_LEVEL_KEY = "runtime.log.logsystem.stdout.level";
    private int enabled = -1;

    public void init(RuntimeServices rs) throws Exception {
        String level = (String)rs.getProperty(RUNTIME_LOG_LEVEL_KEY);
        if (level != null) {
            if (level.equalsIgnoreCase("debug")) {
                this.setEnabledLevel(0);
            } else if (level.equalsIgnoreCase("info")) {
                this.setEnabledLevel(1);
            } else if (level.equalsIgnoreCase("warn")) {
                this.setEnabledLevel(2);
            } else if (level.equalsIgnoreCase("error")) {
                this.setEnabledLevel(3);
            }
        }
    }

    protected String getPrefix(int level) {
        switch (level) {
            case 2: {
                return "  [warn] ";
            }
            case 1: {
                return "  [info] ";
            }
            case 0: {
                return " [debug] ";
            }
            case -1: {
                return " [trace] ";
            }
            case 3: {
                return " [error] ";
            }
        }
        return "  [info] ";
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        String prefix = this.getPrefix(level);
        if (level > 2) {
            System.err.print(prefix);
            System.err.println(message);
            if (t != null) {
                System.err.println(t.getMessage());
                t.printStackTrace();
            }
        } else {
            System.out.print(prefix);
            System.out.println(message);
            if (t != null) {
                System.out.println(t.getMessage());
                t.printStackTrace(System.out);
            }
        }
    }

    public void setEnabledLevel(int level) {
        this.enabled = level;
    }

    public int getEnabledLevel() {
        return this.enabled;
    }

    public boolean isLevelEnabled(int level) {
        return level >= this.enabled;
    }
}

