/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private String methodName = "";
    private int paramCount = 0;

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.methodName = this.getFirstToken().image;
        this.paramCount = this.jjtGetNumChildren() - 1;
        return data;
    }

    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        VelMethod method = null;
        Object[] params = new Object[this.paramCount];
        try {
            Class[] paramClasses = new Class[this.paramCount];
            for (int j = 0; j < this.paramCount; ++j) {
                params[j] = this.jjtGetChild(j + 1).value(context);
                if (params[j] == null) continue;
                paramClasses[j] = params[j].getClass();
            }
            MethodCacheKey mck = new MethodCacheKey(paramClasses);
            IntrospectionCacheData icd = context.icacheGet(mck);
            if (icd != null && o != null && icd.contextData == o.getClass()) {
                method = (VelMethod)icd.thingy;
            } else {
                for (int j = 0; j < this.paramCount; ++j) {
                    params[j] = this.jjtGetChild(j + 1).value(context);
                }
                method = this.rsvc.getUberspect().getMethod(o, this.methodName, params, new Info(context.getCurrentTemplateName(), this.getLine(), this.getColumn()));
                if (method != null && o != null) {
                    icd = new IntrospectionCacheData();
                    icd.contextData = o.getClass();
                    icd.thingy = method;
                    context.icachePut(mck, icd);
                }
            }
            if (method == null) {
                return null;
            }
        }
        catch (MethodInvocationException mie) {
            throw mie;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("ASTMethod.execute() : exception from introspection", e);
            return null;
        }
        try {
            Object obj = method.invoke(o, params);
            if (obj == null && method.getReturnType() == Void.TYPE) {
                return "";
            }
            return obj;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                try {
                    return EventHandlerUtil.methodException(this.rsvc, context, o.getClass(), this.methodName, (Exception)t);
                }
                catch (Exception e) {
                    throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " in template " + context.getCurrentTemplateName() + " at line=" + this.getLine() + " column=" + this.getColumn() + " threw exception " + e.getClass() + " : " + e.getMessage(), e, this.methodName);
                }
            }
            throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " in template " + context.getCurrentTemplateName() + " at line=" + this.getLine() + " column=" + this.getColumn() + " threw exception " + ite.getTargetException().getClass() + " : " + ite.getTargetException().getMessage(), ite.getTargetException(), this.methodName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("ASTMethod.execute() : exception invoking method '" + this.methodName + "' in " + o.getClass(), e);
            return null;
        }
    }

    class MethodCacheKey {
        Class[] params;

        MethodCacheKey(Class[] params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof MethodCacheKey && this.hashCode() == o.hashCode();
        }

        public int hashCode() {
            return this.params.hashCode() * 37 + ASTMethod.this.hashCode();
        }
    }
}

