/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.exception.ReferenceException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.ParserVisitor;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.VelPropertySet;

public class ASTReference
extends SimpleNode {
    private static final int NORMAL_REFERENCE = 1;
    private static final int FORMAL_REFERENCE = 2;
    private static final int QUIET_REFERENCE = 3;
    private static final int RUNT = 4;
    private int referenceType;
    private String nullString;
    private String rootString;
    private boolean escaped = false;
    private boolean computableReference = true;
    private boolean logOnNull = true;
    private String escPrefix = "";
    private String morePrefix = "";
    private String identifier = "";
    private String literal = null;
    private int numChildren = 0;
    protected Info uberInfo;

    public ASTReference(int id) {
        super(id);
    }

    public ASTReference(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.rootString = this.getRoot();
        this.numChildren = this.jjtGetNumChildren();
        if (this.numChildren > 0) {
            this.identifier = this.jjtGetChild((int)(this.numChildren - 1)).getFirstToken().image;
        }
        this.uberInfo = new Info(context.getCurrentTemplateName(), this.getLine(), this.getColumn());
        this.logOnNull = this.rsvc.getBoolean("runtime.log.invalid.references", true);
        return data;
    }

    public String getRootString() {
        return this.rootString;
    }

    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        if (this.referenceType == 4) {
            return null;
        }
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            return null;
        }
        try {
            for (int i = 0; i < this.numChildren && (result = this.jjtGetChild(i).execute(result, context)) != null; ++i) {
            }
            return result;
        }
        catch (MethodInvocationException mie) {
            this.log.error("Method " + mie.getMethodName() + " threw exception for reference $" + this.rootString + " in template " + context.getCurrentTemplateName() + " at " + " [" + this.getLine() + "," + this.getColumn() + "]");
            mie.setReferenceName(this.rootString);
            throw mie;
        }
    }

    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        if (this.referenceType == 4) {
            if (context.getAllowRendering()) {
                writer.write(this.rootString);
            }
            return true;
        }
        Object value = this.execute(null, context);
        if (this.escaped) {
            if (value == null) {
                if (context.getAllowRendering()) {
                    writer.write(this.escPrefix);
                    writer.write("\\");
                    writer.write(this.nullString);
                }
            } else if (context.getAllowRendering()) {
                writer.write(this.escPrefix);
                writer.write(this.nullString);
            }
            return true;
        }
        value = EventHandlerUtil.referenceInsert(this.rsvc, context, this.literal(), value);
        if (value == null || value.toString() == null) {
            if (context.getAllowRendering()) {
                writer.write(this.escPrefix);
                writer.write(this.escPrefix);
                writer.write(this.morePrefix);
                writer.write(this.nullString);
            }
            if (this.logOnNull && this.referenceType != 3 && this.log.isInfoEnabled()) {
                this.log.info("Null reference [template '" + context.getCurrentTemplateName() + "', line " + this.getLine() + ", column " + this.getColumn() + "] : " + this.literal() + " cannot be resolved.");
            }
            return true;
        }
        if (context.getAllowRendering()) {
            writer.write(this.escPrefix);
            writer.write(this.morePrefix);
            writer.write(value.toString());
        }
        return true;
    }

    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        Object value = this.execute(null, context);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false;
        }
        return true;
    }

    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        return this.computableReference ? this.execute(null, context) : null;
    }

    public boolean setValue(InternalContextAdapter context, Object value) throws MethodInvocationException {
        if (this.jjtGetNumChildren() == 0) {
            context.put(this.rootString, value);
            return true;
        }
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            this.log.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
            return false;
        }
        for (int i = 0; i < this.numChildren - 1; ++i) {
            result = this.jjtGetChild(i).execute(result, context);
            if (result != null) continue;
            this.log.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
            return false;
        }
        try {
            VelPropertySet vs = this.rsvc.getUberspect().getPropertySet(result, this.identifier, value, this.uberInfo);
            if (vs == null) {
                return false;
            }
            vs.invoke(result, value);
        }
        catch (InvocationTargetException ite) {
            throw new MethodInvocationException("ASTReference : Invocation of method '" + this.identifier + "' in  " + result.getClass() + " threw exception " + ite.getTargetException().getClass(), ite.getTargetException(), this.identifier);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("ASTReference setValue() : exception : " + e + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
            return false;
        }
        return true;
    }

    private String getRoot() {
        int loc1;
        Token t = this.getFirstToken();
        int slashbang = t.image.indexOf("\\!");
        if (slashbang != -1) {
            int i = 0;
            int len = t.image.length();
            i = t.image.indexOf(36);
            if (i == -1) {
                this.log.error("ASTReference.getRoot() : internal error : no $ found for slashbang.");
                this.computableReference = false;
                this.nullString = t.image;
                return this.nullString;
            }
            while (i < len && t.image.charAt(i) != '\\') {
                ++i;
            }
            int start = i;
            int count = 0;
            while (i < len && t.image.charAt(i++) == '\\') {
                ++count;
            }
            this.nullString = t.image.substring(0, start);
            this.nullString = this.nullString + t.image.substring(start, start + count - 1);
            this.nullString = this.nullString + t.image.substring(start + count);
            this.computableReference = false;
            return this.nullString;
        }
        this.escaped = false;
        if (t.image.startsWith("\\")) {
            int i;
            int len = t.image.length();
            for (i = 0; i < len && t.image.charAt(i) == '\\'; ++i) {
            }
            if (i % 2 != 0) {
                this.escaped = true;
            }
            if (i > 0) {
                this.escPrefix = t.image.substring(0, i / 2);
            }
            t.image = t.image.substring(i);
        }
        if ((loc1 = t.image.lastIndexOf(36)) > 0) {
            this.morePrefix = this.morePrefix + t.image.substring(0, loc1);
            t.image = t.image.substring(loc1);
        }
        this.nullString = this.literal();
        if (t.image.startsWith("$!")) {
            this.referenceType = 3;
            if (!this.escaped) {
                this.nullString = "";
            }
            if (t.image.startsWith("$!{")) {
                return t.next.image;
            }
            return t.image.substring(2);
        }
        if (t.image.equals("${")) {
            this.referenceType = 2;
            return t.next.image;
        }
        if (t.image.startsWith("$")) {
            this.referenceType = 1;
            return t.image.substring(1);
        }
        this.referenceType = 4;
        return t.image;
    }

    public Object getVariableValue(Context context, String variable) throws MethodInvocationException {
        return context.get(variable);
    }

    public void setLiteral(String literal) {
        if (this.literal == null) {
            this.literal = literal;
        }
    }

    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        return super.literal();
    }
}

