/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";
    private String interpolateimage = "";
    private boolean containsLineComment;

    public ASTStringLiteral(int id) {
        super(id);
    }

    public ASTStringLiteral(Parser p, int id) {
        super(p, id);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate.string.literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(36) != -1 || this.getFirstToken().image.indexOf(35) != -1);
        this.image = this.getFirstToken().image.substring(1, this.getFirstToken().image.length() - 1);
        this.containsLineComment = this.image.indexOf("##") != -1;
        this.interpolateimage = !this.containsLineComment ? this.image + " " : this.image;
        if (this.interpolate) {
            BufferedReader br = new BufferedReader(new StringReader(this.interpolateimage));
            this.nodeTree = this.rsvc.parse(br, context != null ? context.getCurrentTemplateName() : "StringLiteral", false);
            this.nodeTree.init(context, this.rsvc);
        }
        return data;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(InternalContextAdapter context) {
        if (this.interpolate) {
            try {
                StringWriter writer = new StringWriter();
                this.nodeTree.render(context, writer);
                String ret = writer.toString();
                if (!this.containsLineComment && ret.length() > 0) {
                    return ret.substring(0, ret.length() - 1);
                }
                return ret;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ParseErrorException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (MethodInvocationException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (ResourceNotFoundException e) {
                this.log.error("Error in interpolating string literal", e);
            }
            catch (IOException e) {
                this.log.error("Error in interpolating string literal", e);
            }
        }
        return this.image;
    }
}

