/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.runtime.RuntimeLogger;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.log.RuntimeLoggerLog;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.runtime.parser.node.BooleanPropertyExecutor;
import org.apache.velocity.runtime.parser.node.GetExecutor;
import org.apache.velocity.runtime.parser.node.PropertyExecutor;
import org.apache.velocity.util.ArrayIterator;
import org.apache.velocity.util.EnumerationIterator;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.UberspectLoggable;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;

public class UberspectImpl
implements Uberspect,
UberspectLoggable {
    private Log log;
    protected Introspector introspector;
    static /* synthetic */ Class class$java$util$Map;

    public void init() {
        this.introspector = new Introspector(this.log);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setRuntimeLogger(RuntimeLogger runtimeLogger) {
        this.setLog(new RuntimeLoggerLog(runtimeLogger));
    }

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Iterator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The iterative object in the #foreach() loop at " + i + " is of type java.util.Iterator.  Because " + "it is not resettable, if used in more than once it " + "may lead to unexpected results.");
            }
            return (Iterator)obj;
        }
        if (obj instanceof Enumeration) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The iterative object in the #foreach() loop at " + i + " is of type java.util.Enumeration.  Because " + "it is not resettable, if used in more than once it " + "may lead to unexpected results.");
            }
            return new EnumerationIterator((Enumeration)obj);
        }
        this.log.info("Could not determine type of iterator in #foreach loop at " + i);
        return null;
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        if (obj == null) {
            return null;
        }
        Method m = this.introspector.getMethod(obj.getClass(), methodName, args);
        return m != null ? new VelMethodImpl(m) : null;
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        if (obj == null) {
            return null;
        }
        Class<?> claz = obj.getClass();
        AbstractExecutor executor = new PropertyExecutor(this.log, this.introspector, claz, identifier);
        if (!executor.isAlive()) {
            executor = new GetExecutor(this.log, this.introspector, claz, identifier);
        }
        if (!executor.isAlive()) {
            executor = new BooleanPropertyExecutor(this.log, this.introspector, claz, identifier);
        }
        return executor.isAlive() ? new VelGetterImpl(executor) : null;
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        VelMethod vm;
        block8: {
            Class<?> claz = obj.getClass();
            vm = null;
            try {
                Object[] params = new Object[]{arg};
                try {
                    vm = this.getMethod(obj, "set" + identifier, params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException nsme2) {
                    StringBuffer sb = new StringBuffer("set");
                    sb.append(identifier);
                    if (Character.isLowerCase(sb.charAt(3))) {
                        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
                    } else {
                        sb.setCharAt(3, Character.toLowerCase(sb.charAt(3)));
                    }
                    vm = this.getMethod(obj, sb.toString(), params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
            }
            catch (NoSuchMethodException nsme) {
                Object[] params;
                if (!(class$java$util$Map == null ? (class$java$util$Map = UberspectImpl.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(claz) || (vm = this.getMethod(obj, "put", params = new Object[]{new Object(), new Object()}, i)) == null) break block8;
                return new VelSetterImpl(vm, identifier);
            }
        }
        return vm != null ? new VelSetterImpl(vm) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VelSetterImpl
    implements VelPropertySet {
        VelMethod vm = null;
        String putKey = null;

        public VelSetterImpl(VelMethod velmethod) {
            this.vm = velmethod;
        }

        public VelSetterImpl(VelMethod velmethod, String key) {
            this.vm = velmethod;
            this.putKey = key;
        }

        private VelSetterImpl() {
        }

        public Object invoke(Object o, Object value) throws Exception {
            ArrayList<Object> al = new ArrayList<Object>();
            if (this.putKey != null) {
                al.add(this.putKey);
                al.add(value);
            } else {
                al.add(value);
            }
            return this.vm.invoke(o, al.toArray());
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.vm.getMethodName();
        }
    }

    public static class VelGetterImpl
    implements VelPropertyGet {
        AbstractExecutor ae = null;

        public VelGetterImpl(AbstractExecutor exec) {
            this.ae = exec;
        }

        private VelGetterImpl() {
        }

        public Object invoke(Object o) throws Exception {
            return this.ae.execute(o);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.ae.getMethod().getName();
        }
    }

    public static class VelMethodImpl
    implements VelMethod {
        Method method = null;

        public VelMethodImpl(Method m) {
            this.method = m;
        }

        private VelMethodImpl() {
        }

        public Object invoke(Object o, Object[] params) throws Exception {
            return this.method.invoke(o, params);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }
    }
}

