/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.StringUtils;

public class UrlBuilder {
    private final Map<String, Object> params = new LinkedHashMap<String, Object>(7);
    private String baseUrl;

    private UrlBuilder() {
    }

    public static UrlBuilder fromBaseUrl(String baseUrl) {
        UrlBuilder builder = new UrlBuilder();
        builder.setBaseUrl(baseUrl);
        return builder;
    }

    public UrlBuilder queryParam(String key, Object value) {
        Assert.notBlank((CharSequence)key, (String)"\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String valueAsString = value != null ? value.toString() : null;
        this.params.put(key, valueAsString);
        return this;
    }

    public String build() {
        return this.build(false);
    }

    public String build(boolean encode) {
        if (MapUtil.isEmpty(this.params)) {
            return this.baseUrl;
        }
        String baseUrl = StringUtils.appendIfNotContain(this.baseUrl, "?", "&");
        String paramString = GlobalAuthUtil.parseMapToString(this.params, encode);
        return baseUrl + paramString;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

