/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonParser$
implements ScalaObject {
    public static final JsonParser$ MODULE$;
    private final BigDecimal BrokenDouble;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    private final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(new JsonParser.Buffer(new StringReader(s), false));
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically) {
        return this.parse(new JsonParser.Buffer(s, closeAutomatically));
    }

    /*
     * WARNING - void declaration
     */
    public Option<JsonAST.JValue> parseOpt(String s) {
        void var2_2;
        Option<JsonAST.JValue> exceptionResult1 = null;
        try {
            exceptionResult1 = this.parse(s).toOpt();
        }
        catch (Exception exception) {
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically) {
        void var3_3;
        Option<JsonAST.JValue> exceptionResult2 = null;
        try {
            exceptionResult2 = this.parse(s, closeAutomatically).toOpt();
        }
        catch (Exception exception) {
            exceptionResult2 = None$.MODULE$;
        }
        return var3_3;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse((Reader)new StringReader(s), p);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return (A)p.apply((Object)new JsonParser.Parser(new JsonParser.Buffer(s, false)));
    }

    private JsonAST.JValue parse(JsonParser.Buffer buf) {
        JsonAST.JValue exceptionResult3 = null;
        try {
            exceptionResult3 = (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf));
            return exceptionResult3;
        }
        catch (Exception exception) {
            throw new JsonParser.ParseException("parsing failed", exception);
        }
        catch (JsonParser.ParseException parseException) {
            throw parseException;
        }
        finally {
            buf.release();
        }
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public boolean parse$default$2() {
        return true;
    }

    public String unquote(String string) {
        return this.unquote(new JsonParser.Buffer(new StringReader(string), false));
    }

    public String unquote(JsonParser.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c = buf.next();
        while (c != '\"') {
            if (c == '\\') {
                String s = this.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s;
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    private BigDecimal BrokenDouble() {
        return this.BrokenDouble;
    }

    public double parseDouble(String s) {
        BigDecimal d = package$.MODULE$.BigDecimal().apply(s);
        if (BoxesRunTime.equalsNumNum((Number)d, (Number)this.BrokenDouble())) {
            throw scala.sys.package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public final char net$liftweb$json$JsonParser$$EOF() {
        return this.net$liftweb$json$JsonParser$$EOF;
    }

    private final String unquote0$1(JsonParser.Buffer buf, String base) {
        StringBuilder s = new StringBuilder(base);
        char c = '\\';
        while (c != '\"') {
            StringBuilder stringBuilder;
            if (c == '\\') {
                char c2 = buf.next();
                switch (c2) {
                    default: {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case '/': {
                        stringBuilder = s.append('/');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s.append('\r');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s.append('\b');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s.append('\f');
                        break;
                    }
                    case 'u': {
                        char[] chars = Array$.MODULE$.apply(buf.next(), (Seq)Predef$.MODULE$.wrapCharArray(new char[]{buf.next(), buf.next(), buf.next()}));
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s.append('\n');
                        break;
                    }
                }
            } else {
                stringBuilder = s.append(c);
            }
            c = buf.next();
        }
        return s.toString();
    }

    private JsonParser$() {
        MODULE$ = this;
        this.BrokenDouble = package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
        this.astParser = new anonfun.2();
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

