/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.NClob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
@Controller(value="mdiyModelAction")
@RequestMapping(value={"/${ms.manager.path}/mdiy/model"})
public class ModelAction
extends BaseAction {
    private static final String TYPE = "model";
    @Autowired
    private IModelBiz modelBiz;
    private Pattern filePattern = Pattern.compile("(src|href)=\"(upload/.*?(png|jpg|gif))");

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/model/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="modelTableName", value="\u6a21\u578b\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="modelJson", value="json", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        modelEntity.setModelCustomType(TYPE);
        BasicUtil.startPage();
        List modelList = this.modelBiz.query(modelEntity);
        return ResultData.build().success((Object)new EUListBean(modelList, (int)BasicUtil.endPage((List)modelList).getTotal()));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        if (modelEntity.getId() != null) {
            BaseEntity _modelEntity = this.modelBiz.getEntity(Integer.parseInt(modelEntity.getId()));
            modelMap.addAttribute("modelEntity", (Object)_modelEntity);
        }
        return "/mdiy/model/form";
    }

    @GetMapping(value={"/data"})
    @ResponseBody
    public ResultData data(Integer modelId, String linkId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        List listMap;
        ModelEntity model = (ModelEntity)this.modelBiz.getEntity(modelId);
        HashMap data = null;
        if (ObjectUtil.isNotNull((Object)((Object)model)) && (listMap = (List)this.modelBiz.excuteSql(StrUtil.format((CharSequence)"select * from {} where link_id = '{}'", (Object[])new Object[]{model.getModelTableName(), linkId}))).size() > 0) {
            data = new HashMap();
            for (Object o : ((Map)listMap.get(0)).keySet()) {
                Object _o = ((Map)listMap.get(0)).get(o);
                if (_o instanceof NClob) {
                    _o = StringUtil.nclobStr((NClob)((NClob)_o));
                }
                data.put(this.getCamelCaseString(o.toString(), false), _o);
            }
        }
        return ResultData.build().success(data);
    }

    private String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        block3: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) continue block3;
                    nextUpperCase = true;
                    continue block3;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        continue block3;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    @LogAnn(title="\u4fdd\u5b58\u6a21\u578b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/data/save"})
    @ResponseBody
    public ResultData save(Integer modelId, String linkId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        ModelEntity model = (ModelEntity)this.modelBiz.getEntity(modelId);
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            Map requestMap = BasicUtil.assemblyRequestMap();
            Map fieldMap = model.getFieldMap();
            HashMap fields = new HashMap();
            for (String s : requestMap.keySet()) {
                if (!fieldMap.containsKey(s)) continue;
                fields.put(fieldMap.get(s).toString(), requestMap.get(s));
            }
            fields.put("link_id", linkId);
            this.modelBiz.insertBySQL(model.getModelTableName(), fields);
            return ResultData.build().success();
        }
        return ResultData.build().error();
    }

    @LogAnn(title="\u66f4\u65b0\u5206\u7c7b", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/data/update"})
    @ResponseBody
    public ResultData update(Integer modelId, String linkId, HttpServletResponse response, HttpServletRequest request, ModelMap modelMap) {
        ModelEntity model = (ModelEntity)this.modelBiz.getEntity(modelId);
        Object data = null;
        if (ObjectUtil.isNotNull((Object)((Object)model)) && StringUtils.isNotBlank((CharSequence)linkId)) {
            Map requestMap = BasicUtil.assemblyRequestMap();
            Map fieldMap = model.getFieldMap();
            HashMap fields = new HashMap();
            for (String s : requestMap.keySet()) {
                if (!fieldMap.containsKey(s)) continue;
                fields.put(fieldMap.get(s).toString(), requestMap.get(s));
            }
            HashMap<String, String> where = new HashMap<String, String>();
            where.put("link_id", linkId);
            this.modelBiz.updateBySQL(model.getModelTableName(), fields, where);
            return ResultData.build().success();
        }
        return ResultData.build().error();
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap modelMap) {
        if (modelEntity.getId() == null) {
            return null;
        }
        modelEntity.setModelCustomType(TYPE);
        ModelEntity _model = (ModelEntity)this.modelBiz.getEntity(Integer.parseInt(modelEntity.getId()));
        return ResultData.build().success((Object)_model);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelJson", value="json", required=true, paramType="query")})
    @LogAnn(title="\u5bfc\u5165\u5206\u7c7b", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/importJson"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:importJson"})
    public ResultData importJson(@ModelAttribute @ApiIgnore ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        String model = "mdiy_model_";
        if (StringUtil.isBlank((Object)modelEntity.getModelJson())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.json")}));
        }
        Map map = new HashMap();
        try {
            map = (Map)JSONObject.parseObject((String)modelEntity.getModelJson(), Map.class);
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.json")}));
        }
        ModelEntity _modelEntity = new ModelEntity();
        String tableName = model + map.get("tableName");
        _modelEntity.setModelTableName(tableName);
        modelEntity.setModelCustomType(TYPE);
        if (ObjectUtil.isNotNull((Object)this.modelBiz.getEntity(_modelEntity))) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("table.name")}));
        }
        HashMap json = new HashMap();
        json.put("html", map.get("html"));
        json.put("script", map.get("script"));
        String sql = map.get("sql").toString().replace("{model}", model);
        this.LOG.info("\u4e0b\u9762\u8f93\u51fasql\u8bed\u53e5\n{}", (Object)sql);
        this.modelBiz.excuteSql(sql);
        modelEntity.setModelField(map.get("field").toString());
        modelEntity.setModelTableName(tableName);
        modelEntity.setModelName(map.get("title").toString());
        modelEntity.setModelJson(net.mingsoft.base.util.JSONObject.toJSONString(json));
        this.modelBiz.saveEntity(modelEntity);
        return ResultData.build().success((Object)modelEntity);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:model:del"})
    public ResultData delete(@RequestBody List<ModelEntity> models, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[models.size()];
        for (int i = 0; i < models.size(); ++i) {
            ids[i] = Integer.parseInt(models.get(i).getId());
        }
        this.modelBiz.delete(ids);
        return ResultData.build().success();
    }
}

