/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.util;

import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.commons.lang3.StringUtils;

public class DictUtil {
    public static DictEntity get(String dictType, String dictLabel, String dictValue) {
        DictEntity dict = new DictEntity();
        dict.setDictLabel(dictLabel);
        dict.setDictType(dictType);
        dict.setDictValue(dictValue);
        return (DictEntity)((Object)((IDictBiz)SpringUtil.getBean(IDictBiz.class)).getEntity(dict));
    }

    public static List<DictEntity> list(String dictType) {
        DictEntity dict = new DictEntity();
        dict.setDictType(dictType);
        return ((IDictBiz)SpringUtil.getBean(IDictBiz.class)).query(dict);
    }

    public static String getDictValue(String dictType, String dictLabel, String defaultValue) {
        DictEntity dictEntity;
        if (StringUtils.isNotBlank((CharSequence)dictType) && StringUtils.isNotBlank((CharSequence)dictLabel) && ObjectUtil.isNotNull((Object)((Object)(dictEntity = DictUtil.get(dictType, dictLabel, null))))) {
            return dictEntity.getDictValue();
        }
        return defaultValue;
    }

    public static String getDictValue(String dictType, String dictLabel) {
        return DictUtil.getDictValue(dictType, dictLabel, "");
    }

    public static String getDictLabel(String dictType, String dictValue, String defaultValue) {
        DictEntity dictEntity;
        if (StringUtils.isNotBlank((CharSequence)dictType) && StringUtils.isNotBlank((CharSequence)dictValue) && ObjectUtil.isNotNull((Object)((Object)(dictEntity = DictUtil.get(dictType, null, dictValue))))) {
            return dictEntity.getDictLabel();
        }
        return defaultValue;
    }

    public static String getDictLabel(String dictType, String dictValue) {
        return DictUtil.getDictLabel(dictType, dictValue, "");
    }

    public static String getDictLabels(String dictType, String dictValues, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)dictType) && StringUtils.isNotBlank((CharSequence)dictValues)) {
            ArrayList<String> labels = new ArrayList<String>();
            String[] values = dictValues.split(",");
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                String dictLabel = DictUtil.getDictLabel(dictType, value, defaultValue);
                if (StringUtils.isBlank((CharSequence)dictLabel)) continue;
                labels.add(dictLabel);
            }
            return StringUtils.join(labels, (String)",");
        }
        return defaultValue;
    }

    public static String getDictLabels(String dictType, String dictValues) {
        return DictUtil.getDictLabels(dictType, dictValues, "");
    }

    public static String getDictValues(String dictType, String dictLabels, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)dictType) && StringUtils.isNotBlank((CharSequence)dictLabels)) {
            ArrayList<String> values = new ArrayList<String>();
            String[] labels = dictLabels.split(",");
            for (int i = 0; i < labels.length; ++i) {
                String value = labels[i];
                values.add(DictUtil.getDictValue(dictType, value, defaultValue));
            }
            return StringUtils.join(values, (String)",");
        }
        return defaultValue;
    }

    public static String getDictValues(String dictType, String dictLabels) {
        return DictUtil.getDictValues(dictType, dictLabels, "");
    }
}

