/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.action.people;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.people.action.BaseAction;
import net.mingsoft.people.biz.IPeopleBiz;
import net.mingsoft.people.biz.IPeopleUserBiz;
import net.mingsoft.people.constant.e.PeopleEnum;
import net.mingsoft.people.entity.PeopleEntity;
import net.mingsoft.people.entity.PeopleUserEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u8be6\u7ec6\u7528\u6237\u4fe1\u606f\u63a5\u53e3")
@Controller(value="webPeopleUser")
@RequestMapping(value={"/people/user"})
public class PeopleUserAction
extends BaseAction {
    @Autowired
    private IPeopleUserBiz peopleUserBiz;
    @Autowired
    private IPeopleBiz peopleBiz;

    @ApiOperation(value="\u67e5\u8be2\u4eba\u5458\u8868\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="people", value="\u5f53\u524d\u7528\u6237", required=true, paramType="query")})
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore PeopleUserEntity people, HttpServletResponse response, HttpServletRequest request, ModelMap model, BindingResult result) {
        PeopleUserEntity _people = this.peopleUserBiz.getByEntity(people);
        return ResultData.build().success(BasicUtil.filter((Object)((Object)_people), (String[])new String[]{"peopleOldPassword", "peoplePassword"}));
    }

    @ApiOperation(value="\u8bfb\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/info"})
    @ResponseBody
    public ResultData info(HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        PeopleUserEntity peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(Integer.parseInt(people.getId()));
        if (peopleUser == null) {
            return ResultData.build().error();
        }
        return ResultData.build().success(BasicUtil.filter((Object)((Object)peopleUser), (String[])new String[]{"peopleOldPassword", "peoplePassword"}));
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="puRealName", value="\u7528\u6237\u771f\u5b9e\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="puAddress", value="\u7528\u6237\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puIcon", value="\u7528\u6237\u5934\u50cf\u56fe\u6807\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="puNickname", value="\u7528\u6237\u6635\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="puSex", value="\u7528\u6237\u6027\u522b(0.\u672a\u77e5\u30011.\u7537\u30012.\u5973)", required=false, paramType="query"), @ApiImplicitParam(name="puBirthday", value="\u7528\u6237\u51fa\u751f\u5e74\u6708\u65e5", required=false, paramType="query"), @ApiImplicitParam(name="puCard", value="\u8eab\u4efd\u8bc1", required=false, paramType="query"), @ApiImplicitParam(name="puProvince", value="\u7701", required=false, paramType="query"), @ApiImplicitParam(name="puCity", value="\u57ce\u5e02", required=false, paramType="query"), @ApiImplicitParam(name="puDistrict", value="\u533a", required=false, paramType="query"), @ApiImplicitParam(name="puStreet", value="\u8857\u9053", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleByMail;
        if (peopleUser == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("people")}));
        }
        if (StringUtils.isNotEmpty((CharSequence)peopleUser.getPeopleMail()) && ObjectUtil.isNotNull((Object)((Object)(peopleByMail = this.peopleBiz.getEntityByMailOrPhone(peopleUser.getPeopleMail()))))) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("people.mail")}));
        }
        String peopleId = this.getPeopleBySession().getId();
        peopleUser.setId(peopleId);
        peopleUser.setPeopleId(Integer.parseInt(peopleId));
        peopleUser.setPeoplePhone(null);
        peopleUser.setPeoplePhoneCheck(-1);
        peopleUser.setPeopleName(null);
        peopleUser.setPeopleMail(null);
        peopleUser.setPeopleMailCheck(-1);
        PeopleUserEntity pue = (PeopleUserEntity)this.peopleUserBiz.getEntity(Integer.parseInt(peopleUser.getId()));
        if (pue.getPeopleId() == 0) {
            this.peopleUserBiz.saveEntity(peopleUser);
        } else {
            this.peopleUserBiz.updatePeople(peopleUser);
        }
        return ResultData.build().success((Object)this.getResString("success"));
    }

    @ApiOperation(value="\u66f4\u65b0\u90ae\u7bb1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleMail", value="\u90ae\u7bb1", required=false, paramType="query")})
    @PostMapping(value={"/updateMail"})
    @ResponseBody
    public ResultData updateMail(String peopleMail, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleByMail;
        if (StrUtil.isBlank((CharSequence)peopleMail)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("people.mail")}));
        }
        if (StringUtils.isNotEmpty((CharSequence)peopleMail) && ObjectUtil.isNotNull((Object)((Object)(peopleByMail = this.peopleBiz.getEntityByMailOrPhone(peopleMail))))) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("people.mail")}));
        }
        String peopleId = this.getPeopleBySession().getId();
        PeopleUserEntity peopleUser = new PeopleUserEntity();
        peopleUser.setId(peopleId);
        peopleUser.setPeopleId(Integer.parseInt(peopleId));
        peopleUser.setPeopleMail(peopleMail);
        peopleUser.setPeopleMailCheck(PeopleEnum.MAIL_CHECK);
        this.peopleBiz.updatePeople(peopleUser);
        return ResultData.build().success((Object)this.getResString("success"));
    }

    @Deprecated
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u5934\u50cf(\u5305\u542b\u5934\u50cf)\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="puIcon", value="\u7528\u6237\u5934\u50cf", required=true, paramType="query"), @ApiImplicitParam(name="peopleMail", value="\u7528\u6237\u624b\u673a", required=false, paramType="query"), @ApiImplicitParam(name="peoplePhone", value="\u7528\u6237\u90ae\u7bb1", required=false, paramType="query")})
    @PostMapping(value={"/saveUserIcon"})
    @ResponseBody
    public ResultData saveUserIcon(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        if (peopleUser == null) {
            return ResultData.build().error(this.getResString("people.user.msg.null.error"));
        }
        PeopleEntity people = this.getPeopleBySession();
        String imgPath = peopleUser.getPuIcon().trim();
        if (!StringUtils.isBlank((CharSequence)imgPath)) {
            peopleUser.setPuIcon(imgPath);
        }
        peopleUser.setId(people.getId());
        this.peopleUserBiz.saveEntity(peopleUser);
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeopleMail())) {
            people.setPeopleMail(peopleUser.getPeopleMail());
        }
        if (!StringUtils.isBlank((CharSequence)peopleUser.getPeoplePhone())) {
            people.setPeoplePhone(peopleUser.getPeoplePhone());
        }
        this.peopleBiz.updateEntity(people);
        return ResultData.build().success((Object)this.getResString("people.user.save.msg.success"));
    }

    @Deprecated
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f(\u5305\u542b\u5934\u50cf)\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="puIcon", value="\u7528\u6237\u5934\u50cf", required=false, paramType="query")})
    @PostMapping(value={"/updateUserIcon"})
    @ResponseBody
    public ResultData updateUserIcon(@ModelAttribute @ApiIgnore PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        if (peopleUser == null) {
            return ResultData.build().error(this.getResString("people.user.msg.null.error"));
        }
        PeopleEntity people = this.getPeopleBySession();
        PeopleUserEntity oldPeopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(Integer.parseInt(people.getId()));
        String imgPath = peopleUser.getPuIcon().trim();
        if (!StringUtils.isBlank((CharSequence)imgPath)) {
            oldPeopleUser.setPuIcon(imgPath);
        }
        this.peopleUserBiz.updatePeople(oldPeopleUser);
        return ResultData.build().success((Object)this.getResString("people.user.update.msg.success"));
    }
}

