/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.interceptor;

import cn.hutool.core.util.ObjectUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.BaseSessionEnum;
import net.mingsoft.basic.constant.ErrorCodeEnum;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.interceptor.BaseInterceptor;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.people.constant.e.SessionConstEnum;
import org.apache.commons.lang3.StringUtils;

public class ActionInterceptor
extends BaseInterceptor {
    private String loginUrl;

    public ActionInterceptor() {
    }

    public ActionInterceptor(String loginUrl, String mobileLoginUrl) {
        this.loginUrl = loginUrl;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (ObjectUtil.isNull((Object)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.PEOPLE_SESSION))) {
            if (StringUtils.isBlank((CharSequence)this.loginUrl) || !StringUtils.isBlank((CharSequence)request.getHeader("x-requested-with")) && request.getHeader("x-requested-with").equals("XMLHttpRequest")) {
                throw new BusinessException(ErrorCodeEnum.CLIENT_UNAUTHORIZED.toString(), "\u767b\u5f55\u5931\u6548");
            }
            String login = URLDecoder.decode(this.loginUrl, "utf-8");
            String backUrl = BasicUtil.getUrl() + request.getServletPath();
            if (request.getQueryString() != null) {
                backUrl = backUrl + "?" + request.getQueryString();
            }
            login = login.indexOf("?") > 0 ? login + "&url=" + URLEncoder.encode(backUrl, "utf-8") : login + "?url=" + URLEncoder.encode(backUrl, "utf-8");
            response.sendRedirect(login);
            return false;
        }
        return true;
    }
}

