/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.AbstractTask;
import org.apache.tools.ant.BuildException;

public class CleanTask
extends AbstractTask {
    private boolean logs = true;
    private boolean workarea = true;
    private boolean dropins = false;
    private boolean apps = false;

    public void execute() throws BuildException {
        this.initTask();
        try {
            this.doClean();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void doClean() throws Exception {
        if (this.logs) {
            this.cleanLogs();
        }
        if (this.workarea) {
            this.cleanWorkArea();
        }
        if (this.dropins) {
            this.cleanDropins();
        }
        if (this.apps) {
            this.cleanApps();
        }
    }

    private void cleanLogs() throws Exception {
        File logsDir = new File(this.serverOutputDir.getAbsolutePath(), "logs");
        if (logsDir.exists()) {
            this.cleanDir(logsDir);
            this.log(MessageFormat.format(messages.getString("info.element.cleaned"), "logs"));
        } else {
            this.log(MessageFormat.format(messages.getString("info.directory.noexist"), logsDir.getAbsolutePath()));
        }
    }

    private void cleanWorkArea() {
        File workareaDir = new File(this.serverOutputDir.getAbsolutePath(), "workarea");
        if (workareaDir.exists()) {
            this.cleanDir(workareaDir);
            this.log(MessageFormat.format(messages.getString("info.element.cleaned"), "workarea"));
        } else {
            this.log(MessageFormat.format(messages.getString("info.directory.noexist"), workareaDir.getAbsolutePath()));
        }
    }

    private void cleanDropins() {
        File dropinsDir = new File(this.serverConfigDir.getAbsolutePath(), "dropins");
        if (dropinsDir.exists()) {
            this.cleanDir(dropinsDir);
            this.log(MessageFormat.format(messages.getString("info.element.cleaned"), "dropins"));
        } else {
            this.log(MessageFormat.format(messages.getString("info.directory.noexist"), dropinsDir.getAbsolutePath()));
        }
    }

    private void cleanApps() {
        File AppsDir = new File(this.serverConfigDir.getAbsolutePath(), "apps");
        if (AppsDir.exists()) {
            this.cleanDir(AppsDir);
            this.log(MessageFormat.format(messages.getString("info.element.cleaned"), "apps"));
        } else {
            this.log(MessageFormat.format(messages.getString("info.directory.noexist"), AppsDir.getAbsolutePath()));
        }
    }

    private void cleanDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    this.cleanDir(file);
                }
                if (file.delete()) continue;
                throw new BuildException(MessageFormat.format(messages.getString("error.cannot.delete.file"), file.getAbsolutePath()));
            }
        }
    }

    public boolean isLogs() {
        return this.logs;
    }

    public void setLogs(boolean logs) {
        this.logs = logs;
    }

    public boolean isWorkarea() {
        return this.workarea;
    }

    public void setWorkarea(boolean workarea) {
        this.workarea = workarea;
    }

    public boolean isDropins() {
        return this.dropins;
    }

    public void setDropins(boolean dropins) {
        this.dropins = dropins;
    }

    public boolean isApps() {
        return this.apps;
    }

    public void setApps(boolean apps) {
        this.apps = apps;
    }
}

