/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.wasdev.wlp.ant.install.InstallLibertyTask;
import net.wasdev.wlp.ant.install.InstallUtils;
import net.wasdev.wlp.ant.install.Installer;
import org.apache.tools.ant.BuildException;

public class ArchiveInstaller
implements Installer {
    private static final String LICENSE_REGEX = "D/N:\\s*(.*)\\s*";
    private String runtimeUrl;
    private String extendedUrl;
    private String licenseCode;

    public String getRuntimeUrl() {
        return this.runtimeUrl;
    }

    public void setRuntimeUrl(String runtimeUrl) {
        this.runtimeUrl = runtimeUrl;
    }

    public String getExtendedUrl() {
        return this.extendedUrl;
    }

    public void setExtendedUrl(String extendedUrl) {
        this.extendedUrl = extendedUrl;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    @Override
    public void install(InstallLibertyTask task) throws Exception {
        if (this.runtimeUrl == null) {
            throw new BuildException("Rumtime URL must be specified.");
        }
        File cacheDir = new File(task.getCacheDir());
        InstallUtils.createDirectory(cacheDir);
        this.install(task, cacheDir, this.runtimeUrl);
        if (this.extendedUrl != null) {
            this.install(task, cacheDir, this.extendedUrl);
        }
    }

    private void install(InstallLibertyTask task, File cacheDir, String url) throws Exception {
        URL downloadURL = new URL(url);
        File cachedFile = new File(cacheDir, InstallUtils.getFile(downloadURL));
        if (url.endsWith(".jar")) {
            task.checkLicenseSet();
            task.downloadFile(downloadURL, cachedFile);
            task.checkLicense(this.getLicenseCode(cachedFile));
            task.installLiberty(cachedFile);
        } else {
            task.downloadFile(downloadURL, cachedFile);
            task.unzipLiberty(cachedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLicenseCode(File jarFile) throws Exception {
        String string;
        JarFile jar = new JarFile(jarFile);
        InputStream in = null;
        try {
            ZipEntry entry = jar.getEntry("wlp/lafiles/LI_en");
            if (entry == null) {
                throw new BuildException("Unable to find license file in " + jarFile);
            }
            in = jar.getInputStream(entry);
            string = InstallUtils.getLicenseCode(in, "UTF-16", LICENSE_REGEX);
        }
        catch (Throwable throwable) {
            InstallUtils.close(in);
            jar.close();
            throw throwable;
        }
        InstallUtils.close(in);
        jar.close();
        return string;
    }
}

