/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.wasdev.wlp.ant.AbstractTask;
import net.wasdev.wlp.ant.install.ArchiveInstaller;
import net.wasdev.wlp.ant.install.Installer;
import net.wasdev.wlp.ant.install.OpenLibertyInstaller;
import net.wasdev.wlp.ant.install.Unzip;
import net.wasdev.wlp.ant.install.WasDevInstaller;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.taskdefs.Java;

public class InstallLibertyTask
extends AbstractTask {
    private String baseDir;
    private String cacheDir;
    private boolean verbose;
    private String licenseCode;
    private String version;
    private String type;
    private String runtimeUrl;
    private String username;
    private String password;
    private long maxDownloadTime;
    private boolean offline;
    private boolean useOpenLiberty;

    public void execute() throws BuildException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void doExecute() throws Exception {
        Installer installer;
        File wlpDir;
        if (this.baseDir == null) {
            this.baseDir = ".";
        }
        if ((wlpDir = new File(this.baseDir, "wlp")).exists()) {
            this.log("Liberty profile is already installed.");
            return;
        }
        if (this.cacheDir == null) {
            File dir = new File(System.getProperty("java.io.tmpdir"), "wlp-cache");
            this.cacheDir = dir.getAbsolutePath();
        }
        if (this.runtimeUrl == null) {
            if (this.useOpenLiberty) {
                installer = new OpenLibertyInstaller();
                ((OpenLibertyInstaller)installer).setVersion(this.version);
                ((OpenLibertyInstaller)installer).setType(this.type);
                ((OpenLibertyInstaller)installer).install(this);
            } else {
                installer = new WasDevInstaller();
                ((WasDevInstaller)installer).setVersion(this.version);
                ((WasDevInstaller)installer).setLicenseCode(this.licenseCode);
                ((WasDevInstaller)installer).setType(this.type);
                ((WasDevInstaller)installer).install(this);
            }
        } else {
            installer = new ArchiveInstaller();
            ((ArchiveInstaller)installer).setRuntimeUrl(this.runtimeUrl);
            ((ArchiveInstaller)installer).setLicenseCode(this.licenseCode);
            ((ArchiveInstaller)installer).install(this);
        }
    }

    protected void downloadFile(URL source, File dest) throws IOException {
        if (this.offline) {
            this.offlineDownload(source, dest);
        } else {
            this.onlineDownload(source, dest);
        }
    }

    private void offlineDownload(URL source, File dest) throws IOException {
        if (!dest.exists()) {
            throw new BuildException("Offline mode. File " + dest.getName() + " is not available in the cache.");
        }
        this.log("Offline mode. Using " + dest + " for " + source);
    }

    private void onlineDownload(URL source, File dest) throws IOException {
        Get get = (Get)this.getProject().createTask("get");
        Get.VerboseProgress progress = null;
        if (this.verbose) {
            progress = new Get.VerboseProgress(System.out);
        }
        get.setUseTimestamp(true);
        get.setUsername(this.username);
        get.setPassword(this.password);
        get.setMaxTime(this.maxDownloadTime);
        get.doGet(source, dest, 2, (Get.DownloadProgress)progress);
    }

    protected void installLiberty(File jarFile) throws Exception {
        Java java = (Java)this.getProject().createTask("java");
        java.setJar(jarFile);
        java.setFork(true);
        java.createArg().setValue("-acceptLicense");
        java.createArg().setValue(this.baseDir);
        int exitCode = java.executeJava();
        if (exitCode != 0) {
            throw new BuildException("Error installing Liberty.");
        }
    }

    protected void unzipLiberty(File zipFile) throws Exception {
        Unzip.unzipToDirectory(zipFile, new File(this.baseDir));
    }

    protected void checkLicense(String actualLicenseCode) {
        if (actualLicenseCode == null) {
            throw new BuildException("License code not found.");
        }
        if (!this.licenseCode.equals(actualLicenseCode)) {
            throw new BuildException("License code does not match. Expected: " + this.licenseCode + ", Actual: " + actualLicenseCode);
        }
    }

    protected void checkLicenseSet() {
        if (this.licenseCode == null) {
            throw new BuildException("Liberty license code must be specified.");
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getRuntimeUrl() {
        return this.runtimeUrl;
    }

    public void setRuntimeUrl(String runtimeUrl) {
        this.runtimeUrl = runtimeUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getMaxDownloadTime() {
        return this.maxDownloadTime;
    }

    public void setMaxDownloadTime(long maxDownloadTime) {
        this.maxDownloadTime = maxDownloadTime;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setUseOpenLiberty(boolean useOpenLiberty) {
        this.useOpenLiberty = useOpenLiberty;
    }

    public boolean getUseOpenLiberty() {
        return this.useOpenLiberty;
    }
}

