/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wasdev.wlp.ant.install.InstallUtils;
import net.wasdev.wlp.ant.install.LibertyInfo;

public class LibertyYaml {
    public static List<LibertyInfo> parse(File file) throws IOException {
        List<LibertyInfo> list;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            list = LibertyYaml.parse(new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8")));
        }
        catch (Throwable throwable) {
            InstallUtils.close(in);
            throw throwable;
        }
        InstallUtils.close(in);
        return list;
    }

    public static List<LibertyInfo> parse(BufferedReader reader) throws IOException {
        ArrayList<LibertyInfo> values = new ArrayList<LibertyInfo>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("---") || line.trim().isEmpty()) continue;
            String[] parts = line.split(":");
            String version = parts[0].trim();
            Map<String, String> map = LibertyYaml.parseContent(reader);
            LibertyInfo info = new LibertyInfo(version, map);
            values.add(info);
        }
        return values;
    }

    private static Map<String, String> parseContent(BufferedReader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        String line = null;
        while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
            int pos;
            if (!line.startsWith(" ") || (pos = line.indexOf(58)) == -1) continue;
            String key = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            map.put(key.trim(), value.trim());
        }
        return map;
    }
}

