/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "UserTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        UserTask userTask = (UserTask)baseElement;
        String assignee = userTask.getAssignee();
        String owner = userTask.getOwner();
        if (StringUtils.isNotEmpty((CharSequence)assignee) || StringUtils.isNotEmpty((CharSequence)owner) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups())) {
            ObjectNode candidateNode;
            ArrayNode candidateArrayNode;
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                assignmentValuesNode.put("assignee", assignee);
            }
            if (StringUtils.isNotEmpty((CharSequence)owner)) {
                assignmentValuesNode.put("owner", owner);
            }
            if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers())) {
                candidateArrayNode = this.objectMapper.createArrayNode();
                for (String candidateUser : userTask.getCandidateUsers()) {
                    candidateNode = this.objectMapper.createObjectNode();
                    candidateNode.put("value", candidateUser);
                    candidateArrayNode.add((JsonNode)candidateNode);
                }
                assignmentValuesNode.put("candidateUsers", (JsonNode)candidateArrayNode);
            }
            if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups())) {
                candidateArrayNode = this.objectMapper.createArrayNode();
                for (String candidateGroup : userTask.getCandidateGroups()) {
                    candidateNode = this.objectMapper.createObjectNode();
                    candidateNode.put("value", candidateGroup);
                    candidateArrayNode.add((JsonNode)candidateNode);
                }
                assignmentValuesNode.put("candidateGroups", (JsonNode)candidateArrayNode);
            }
            assignmentNode.put("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.put("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
        }
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode assignmentDefNode;
        UserTask task = new UserTask();
        task.setPriority(this.getPropertyValueAsString("prioritydefinition", elementNode));
        String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            task.setFormKey(formKey);
        }
        task.setDueDate(this.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setCategory(this.getPropertyValueAsString("categorydefinition", elementNode));
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (assignmentDefNode = assignmentNode.get("assignment")) != null) {
            JsonNode ownerNode;
            JsonNode assigneeNode = assignmentDefNode.get("assignee");
            if (assigneeNode != null && !assigneeNode.isNull()) {
                task.setAssignee(assigneeNode.asText());
            }
            if ((ownerNode = assignmentDefNode.get("owner")) != null && !ownerNode.isNull()) {
                task.setOwner(ownerNode.asText());
            }
            task.setCandidateUsers(this.getValueAsList("candidateUsers", assignmentDefNode));
            task.setCandidateGroups(this.getValueAsList("candidateGroups", assignmentDefNode));
        }
        this.convertJsonToFormProperties(elementNode, (BaseElement)task);
        return task;
    }
}

