/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapred;

import com.hadoop.compression.lzo.LzoIndex;
import com.hadoop.compression.lzo.LzopCodec;
import com.hadoop.mapred.DeprecatedLzoLineRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedLzoTextInputFormat
extends FileInputFormat<LongWritable, Text> {
    public static final String LZO_INDEX_SUFFIX = ".index";
    private final Map<Path, LzoIndex> indexes = new HashMap<Path, LzoIndex>();

    protected FileStatus[] listStatus(JobConf conf) throws IOException {
        ArrayList<FileStatus> files = new ArrayList<FileStatus>(Arrays.asList(super.listStatus(conf)));
        String fileExtension = new LzopCodec().getDefaultExtension();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileStatus fileStatus = (FileStatus)it.next();
            Path file = fileStatus.getPath();
            if (!file.toString().endsWith(fileExtension)) {
                it.remove();
                continue;
            }
            FileSystem fs = file.getFileSystem((Configuration)conf);
            LzoIndex index = LzoIndex.readIndex(fs, file);
            this.indexes.put(file, index);
        }
        return files.toArray(new FileStatus[0]);
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        LzoIndex index = this.indexes.get(filename);
        return !index.isEmpty();
    }

    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        FileSplit[] splits = (FileSplit[])super.getSplits(conf, numSplits);
        ArrayList<FileSplit> result = new ArrayList<FileSplit>();
        for (FileSplit fileSplit : splits) {
            Path file = fileSplit.getPath();
            FileSystem fs = file.getFileSystem((Configuration)conf);
            LzoIndex index = this.indexes.get(file);
            if (index == null) {
                throw new IOException("Index not found for " + file);
            }
            if (index.isEmpty()) {
                result.add(fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long lzoStart = index.alignSliceStartToIndex(start, end);
            long lzoEnd = index.alignSliceEndToIndex(end, fs.getFileStatus(file).getLen());
            if (lzoStart == -1L || lzoEnd == -1L) continue;
            result.add(new FileSplit(file, lzoStart, lzoEnd - lzoStart, fileSplit.getLocations()));
        }
        return (InputSplit[])result.toArray(new FileSplit[result.size()]);
    }

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new DeprecatedLzoLineRecordReader((Configuration)conf, (FileSplit)split);
    }
}

