/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapreduce;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.anarres.lzo.LzopInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoSplitRecordReader
extends RecordReader<Path, LongWritable> {
    private static final Log LOG = LogFactory.getLog(LzoSplitRecordReader.class);
    private final int LOG_EVERY_N_BLOCKS = 1000;
    private final LongWritable curValue = new LongWritable(-1L);
    private FSDataInputStream rawInputStream;
    private TaskAttemptContext context;
    private int numBlocksRead = 0;
    private int numDecompressedChecksums = -1;
    private int numCompressedChecksums = -1;
    private long totalFileSize = 0L;
    private Path lzoFile;

    public void initialize(InputSplit genericSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        this.context = taskAttemptContext;
        FileSplit fileSplit = (FileSplit)genericSplit;
        this.lzoFile = fileSplit.getPath();
        this.totalFileSize = fileSplit.getLength();
        Configuration conf = this.context.getConfiguration();
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodec(this.lzoFile);
        ((Configurable)codec).setConf(conf);
        FileSystem fs = this.lzoFile.getFileSystem(conf);
        this.rawInputStream = fs.open(this.lzoFile);
        LzopInputStream lzis = new LzopInputStream((InputStream)this.rawInputStream);
        this.numCompressedChecksums = lzis.getCompressedChecksumCount();
        this.numDecompressedChecksums = lzis.getUncompressedChecksumCount();
    }

    public boolean nextKeyValue() throws IOException {
        int uncompressedBlockSize = this.rawInputStream.readInt();
        if (uncompressedBlockSize == 0) {
            return false;
        }
        if (uncompressedBlockSize < 0) {
            throw new EOFException("Could not read uncompressed block size at position " + this.rawInputStream.getPos() + " in file " + this.lzoFile);
        }
        int compressedBlockSize = this.rawInputStream.readInt();
        if (compressedBlockSize <= 0) {
            throw new EOFException("Could not read compressed block size at position " + this.rawInputStream.getPos() + " in file " + this.lzoFile);
        }
        boolean isUncompressedBlock = uncompressedBlockSize == compressedBlockSize;
        int numChecksumsToSkip = isUncompressedBlock ? this.numDecompressedChecksums : this.numDecompressedChecksums + this.numCompressedChecksums;
        long pos = this.rawInputStream.getPos();
        this.curValue.set(pos - 8L);
        this.rawInputStream.seek(pos + (long)compressedBlockSize + (long)(4 * numChecksumsToSkip));
        ++this.numBlocksRead;
        if (this.numBlocksRead % 1000 == 0) {
            LOG.info((Object)("Reading block " + this.numBlocksRead + " at pos " + pos + " of " + this.totalFileSize + ". Read is " + 100.0 * (double)this.getProgress() + "% done. "));
        }
        return true;
    }

    public Path getCurrentKey() {
        return this.lzoFile;
    }

    public LongWritable getCurrentValue() {
        return this.curValue;
    }

    public float getProgress() throws IOException {
        if (this.totalFileSize == 0L) {
            return 0.0f;
        }
        return (float)this.rawInputStream.getPos() / (float)this.totalFileSize;
    }

    public void close() throws IOException {
        LOG.info((Object)("Closing input stream after reading " + this.numBlocksRead + " blocks from " + this.lzoFile));
        this.rawInputStream.close();
    }
}

