/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.format.BlockletMinMaxIndex;
import org.apache.carbondata.format.ChunkCompressionMeta;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.PresenceMeta;
import org.apache.carbondata.format.SortState;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataChunk2
implements TBase<DataChunk2, _Fields>,
Serializable,
Cloneable,
Comparable<DataChunk2> {
    private static final TStruct STRUCT_DESC = new TStruct("DataChunk2");
    private static final TField CHUNK_META_FIELD_DESC = new TField("chunk_meta", 12, 1);
    private static final TField ROW_MAJOR_FIELD_DESC = new TField("rowMajor", 2, 2);
    private static final TField DATA_PAGE_LENGTH_FIELD_DESC = new TField("data_page_length", 8, 3);
    private static final TField ROWID_PAGE_LENGTH_FIELD_DESC = new TField("rowid_page_length", 8, 4);
    private static final TField RLE_PAGE_LENGTH_FIELD_DESC = new TField("rle_page_length", 8, 5);
    private static final TField PRESENCE_FIELD_DESC = new TField("presence", 12, 6);
    private static final TField SORT_STATE_FIELD_DESC = new TField("sort_state", 8, 7);
    private static final TField ENCODERS_FIELD_DESC = new TField("encoders", 15, 8);
    private static final TField ENCODER_META_FIELD_DESC = new TField("encoder_meta", 15, 9);
    private static final TField MIN_MAX_FIELD_DESC = new TField("min_max", 12, 10);
    private static final TField NUMBER_OF_ROWS_INPAGE_FIELD_DESC = new TField("numberOfRowsInpage", 8, 11);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ChunkCompressionMeta chunk_meta;
    public boolean rowMajor;
    public int data_page_length;
    public int rowid_page_length;
    public int rle_page_length;
    public PresenceMeta presence;
    public SortState sort_state;
    public List<Encoding> encoders;
    public List<ByteBuffer> encoder_meta;
    public BlockletMinMaxIndex min_max;
    public int numberOfRowsInpage;
    private static final int __ROWMAJOR_ISSET_ID = 0;
    private static final int __DATA_PAGE_LENGTH_ISSET_ID = 1;
    private static final int __ROWID_PAGE_LENGTH_ISSET_ID = 2;
    private static final int __RLE_PAGE_LENGTH_ISSET_ID = 3;
    private static final int __NUMBEROFROWSINPAGE_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public DataChunk2() {
    }

    public DataChunk2(ChunkCompressionMeta chunk_meta, boolean rowMajor, int data_page_length) {
        this();
        this.chunk_meta = chunk_meta;
        this.rowMajor = rowMajor;
        this.setRowMajorIsSet(true);
        this.data_page_length = data_page_length;
        this.setData_page_lengthIsSet(true);
    }

    public DataChunk2(DataChunk2 other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetChunk_meta()) {
            this.chunk_meta = new ChunkCompressionMeta(other.chunk_meta);
        }
        this.rowMajor = other.rowMajor;
        this.data_page_length = other.data_page_length;
        this.rowid_page_length = other.rowid_page_length;
        this.rle_page_length = other.rle_page_length;
        if (other.isSetPresence()) {
            this.presence = new PresenceMeta(other.presence);
        }
        if (other.isSetSort_state()) {
            this.sort_state = other.sort_state;
        }
        if (other.isSetEncoders()) {
            ArrayList<Encoding> __this__encoders = new ArrayList<Encoding>(other.encoders.size());
            for (Encoding other_element : other.encoders) {
                __this__encoders.add(other_element);
            }
            this.encoders = __this__encoders;
        }
        if (other.isSetEncoder_meta()) {
            ArrayList<ByteBuffer> __this__encoder_meta = new ArrayList<ByteBuffer>(other.encoder_meta);
            this.encoder_meta = __this__encoder_meta;
        }
        if (other.isSetMin_max()) {
            this.min_max = new BlockletMinMaxIndex(other.min_max);
        }
        this.numberOfRowsInpage = other.numberOfRowsInpage;
    }

    public DataChunk2 deepCopy() {
        return new DataChunk2(this);
    }

    public void clear() {
        this.chunk_meta = null;
        this.setRowMajorIsSet(false);
        this.rowMajor = false;
        this.setData_page_lengthIsSet(false);
        this.data_page_length = 0;
        this.setRowid_page_lengthIsSet(false);
        this.rowid_page_length = 0;
        this.setRle_page_lengthIsSet(false);
        this.rle_page_length = 0;
        this.presence = null;
        this.sort_state = null;
        this.encoders = null;
        this.encoder_meta = null;
        this.min_max = null;
        this.setNumberOfRowsInpageIsSet(false);
        this.numberOfRowsInpage = 0;
    }

    public ChunkCompressionMeta getChunk_meta() {
        return this.chunk_meta;
    }

    public DataChunk2 setChunk_meta(ChunkCompressionMeta chunk_meta) {
        this.chunk_meta = chunk_meta;
        return this;
    }

    public void unsetChunk_meta() {
        this.chunk_meta = null;
    }

    public boolean isSetChunk_meta() {
        return this.chunk_meta != null;
    }

    public void setChunk_metaIsSet(boolean value) {
        if (!value) {
            this.chunk_meta = null;
        }
    }

    public boolean isRowMajor() {
        return this.rowMajor;
    }

    public DataChunk2 setRowMajor(boolean rowMajor) {
        this.rowMajor = rowMajor;
        this.setRowMajorIsSet(true);
        return this;
    }

    public void unsetRowMajor() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetRowMajor() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setRowMajorIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getData_page_length() {
        return this.data_page_length;
    }

    public DataChunk2 setData_page_length(int data_page_length) {
        this.data_page_length = data_page_length;
        this.setData_page_lengthIsSet(true);
        return this;
    }

    public void unsetData_page_length() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetData_page_length() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setData_page_lengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getRowid_page_length() {
        return this.rowid_page_length;
    }

    public DataChunk2 setRowid_page_length(int rowid_page_length) {
        this.rowid_page_length = rowid_page_length;
        this.setRowid_page_lengthIsSet(true);
        return this;
    }

    public void unsetRowid_page_length() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetRowid_page_length() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setRowid_page_lengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getRle_page_length() {
        return this.rle_page_length;
    }

    public DataChunk2 setRle_page_length(int rle_page_length) {
        this.rle_page_length = rle_page_length;
        this.setRle_page_lengthIsSet(true);
        return this;
    }

    public void unsetRle_page_length() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetRle_page_length() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setRle_page_lengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public PresenceMeta getPresence() {
        return this.presence;
    }

    public DataChunk2 setPresence(PresenceMeta presence) {
        this.presence = presence;
        return this;
    }

    public void unsetPresence() {
        this.presence = null;
    }

    public boolean isSetPresence() {
        return this.presence != null;
    }

    public void setPresenceIsSet(boolean value) {
        if (!value) {
            this.presence = null;
        }
    }

    public SortState getSort_state() {
        return this.sort_state;
    }

    public DataChunk2 setSort_state(SortState sort_state) {
        this.sort_state = sort_state;
        return this;
    }

    public void unsetSort_state() {
        this.sort_state = null;
    }

    public boolean isSetSort_state() {
        return this.sort_state != null;
    }

    public void setSort_stateIsSet(boolean value) {
        if (!value) {
            this.sort_state = null;
        }
    }

    public int getEncodersSize() {
        return this.encoders == null ? 0 : this.encoders.size();
    }

    public Iterator<Encoding> getEncodersIterator() {
        return this.encoders == null ? null : this.encoders.iterator();
    }

    public void addToEncoders(Encoding elem) {
        if (this.encoders == null) {
            this.encoders = new ArrayList<Encoding>();
        }
        this.encoders.add(elem);
    }

    public List<Encoding> getEncoders() {
        return this.encoders;
    }

    public DataChunk2 setEncoders(List<Encoding> encoders) {
        this.encoders = encoders;
        return this;
    }

    public void unsetEncoders() {
        this.encoders = null;
    }

    public boolean isSetEncoders() {
        return this.encoders != null;
    }

    public void setEncodersIsSet(boolean value) {
        if (!value) {
            this.encoders = null;
        }
    }

    public int getEncoder_metaSize() {
        return this.encoder_meta == null ? 0 : this.encoder_meta.size();
    }

    public Iterator<ByteBuffer> getEncoder_metaIterator() {
        return this.encoder_meta == null ? null : this.encoder_meta.iterator();
    }

    public void addToEncoder_meta(ByteBuffer elem) {
        if (this.encoder_meta == null) {
            this.encoder_meta = new ArrayList<ByteBuffer>();
        }
        this.encoder_meta.add(elem);
    }

    public List<ByteBuffer> getEncoder_meta() {
        return this.encoder_meta;
    }

    public DataChunk2 setEncoder_meta(List<ByteBuffer> encoder_meta) {
        this.encoder_meta = encoder_meta;
        return this;
    }

    public void unsetEncoder_meta() {
        this.encoder_meta = null;
    }

    public boolean isSetEncoder_meta() {
        return this.encoder_meta != null;
    }

    public void setEncoder_metaIsSet(boolean value) {
        if (!value) {
            this.encoder_meta = null;
        }
    }

    public BlockletMinMaxIndex getMin_max() {
        return this.min_max;
    }

    public DataChunk2 setMin_max(BlockletMinMaxIndex min_max) {
        this.min_max = min_max;
        return this;
    }

    public void unsetMin_max() {
        this.min_max = null;
    }

    public boolean isSetMin_max() {
        return this.min_max != null;
    }

    public void setMin_maxIsSet(boolean value) {
        if (!value) {
            this.min_max = null;
        }
    }

    public int getNumberOfRowsInpage() {
        return this.numberOfRowsInpage;
    }

    public DataChunk2 setNumberOfRowsInpage(int numberOfRowsInpage) {
        this.numberOfRowsInpage = numberOfRowsInpage;
        this.setNumberOfRowsInpageIsSet(true);
        return this;
    }

    public void unsetNumberOfRowsInpage() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetNumberOfRowsInpage() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setNumberOfRowsInpageIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CHUNK_META: {
                if (value == null) {
                    this.unsetChunk_meta();
                    break;
                }
                this.setChunk_meta((ChunkCompressionMeta)value);
                break;
            }
            case ROW_MAJOR: {
                if (value == null) {
                    this.unsetRowMajor();
                    break;
                }
                this.setRowMajor((Boolean)value);
                break;
            }
            case DATA_PAGE_LENGTH: {
                if (value == null) {
                    this.unsetData_page_length();
                    break;
                }
                this.setData_page_length((Integer)value);
                break;
            }
            case ROWID_PAGE_LENGTH: {
                if (value == null) {
                    this.unsetRowid_page_length();
                    break;
                }
                this.setRowid_page_length((Integer)value);
                break;
            }
            case RLE_PAGE_LENGTH: {
                if (value == null) {
                    this.unsetRle_page_length();
                    break;
                }
                this.setRle_page_length((Integer)value);
                break;
            }
            case PRESENCE: {
                if (value == null) {
                    this.unsetPresence();
                    break;
                }
                this.setPresence((PresenceMeta)value);
                break;
            }
            case SORT_STATE: {
                if (value == null) {
                    this.unsetSort_state();
                    break;
                }
                this.setSort_state((SortState)((Object)value));
                break;
            }
            case ENCODERS: {
                if (value == null) {
                    this.unsetEncoders();
                    break;
                }
                this.setEncoders((List)value);
                break;
            }
            case ENCODER_META: {
                if (value == null) {
                    this.unsetEncoder_meta();
                    break;
                }
                this.setEncoder_meta((List)value);
                break;
            }
            case MIN_MAX: {
                if (value == null) {
                    this.unsetMin_max();
                    break;
                }
                this.setMin_max((BlockletMinMaxIndex)value);
                break;
            }
            case NUMBER_OF_ROWS_INPAGE: {
                if (value == null) {
                    this.unsetNumberOfRowsInpage();
                    break;
                }
                this.setNumberOfRowsInpage((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CHUNK_META: {
                return this.getChunk_meta();
            }
            case ROW_MAJOR: {
                return this.isRowMajor();
            }
            case DATA_PAGE_LENGTH: {
                return this.getData_page_length();
            }
            case ROWID_PAGE_LENGTH: {
                return this.getRowid_page_length();
            }
            case RLE_PAGE_LENGTH: {
                return this.getRle_page_length();
            }
            case PRESENCE: {
                return this.getPresence();
            }
            case SORT_STATE: {
                return this.getSort_state();
            }
            case ENCODERS: {
                return this.getEncoders();
            }
            case ENCODER_META: {
                return this.getEncoder_meta();
            }
            case MIN_MAX: {
                return this.getMin_max();
            }
            case NUMBER_OF_ROWS_INPAGE: {
                return this.getNumberOfRowsInpage();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CHUNK_META: {
                return this.isSetChunk_meta();
            }
            case ROW_MAJOR: {
                return this.isSetRowMajor();
            }
            case DATA_PAGE_LENGTH: {
                return this.isSetData_page_length();
            }
            case ROWID_PAGE_LENGTH: {
                return this.isSetRowid_page_length();
            }
            case RLE_PAGE_LENGTH: {
                return this.isSetRle_page_length();
            }
            case PRESENCE: {
                return this.isSetPresence();
            }
            case SORT_STATE: {
                return this.isSetSort_state();
            }
            case ENCODERS: {
                return this.isSetEncoders();
            }
            case ENCODER_META: {
                return this.isSetEncoder_meta();
            }
            case MIN_MAX: {
                return this.isSetMin_max();
            }
            case NUMBER_OF_ROWS_INPAGE: {
                return this.isSetNumberOfRowsInpage();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof DataChunk2) {
            return this.equals((DataChunk2)that);
        }
        return false;
    }

    public boolean equals(DataChunk2 that) {
        if (that == null) {
            return false;
        }
        boolean this_present_chunk_meta = this.isSetChunk_meta();
        boolean that_present_chunk_meta = that.isSetChunk_meta();
        if (this_present_chunk_meta || that_present_chunk_meta) {
            if (!this_present_chunk_meta || !that_present_chunk_meta) {
                return false;
            }
            if (!this.chunk_meta.equals(that.chunk_meta)) {
                return false;
            }
        }
        boolean this_present_rowMajor = true;
        boolean that_present_rowMajor = true;
        if (this_present_rowMajor || that_present_rowMajor) {
            if (!this_present_rowMajor || !that_present_rowMajor) {
                return false;
            }
            if (this.rowMajor != that.rowMajor) {
                return false;
            }
        }
        boolean this_present_data_page_length = true;
        boolean that_present_data_page_length = true;
        if (this_present_data_page_length || that_present_data_page_length) {
            if (!this_present_data_page_length || !that_present_data_page_length) {
                return false;
            }
            if (this.data_page_length != that.data_page_length) {
                return false;
            }
        }
        boolean this_present_rowid_page_length = this.isSetRowid_page_length();
        boolean that_present_rowid_page_length = that.isSetRowid_page_length();
        if (this_present_rowid_page_length || that_present_rowid_page_length) {
            if (!this_present_rowid_page_length || !that_present_rowid_page_length) {
                return false;
            }
            if (this.rowid_page_length != that.rowid_page_length) {
                return false;
            }
        }
        boolean this_present_rle_page_length = this.isSetRle_page_length();
        boolean that_present_rle_page_length = that.isSetRle_page_length();
        if (this_present_rle_page_length || that_present_rle_page_length) {
            if (!this_present_rle_page_length || !that_present_rle_page_length) {
                return false;
            }
            if (this.rle_page_length != that.rle_page_length) {
                return false;
            }
        }
        boolean this_present_presence = this.isSetPresence();
        boolean that_present_presence = that.isSetPresence();
        if (this_present_presence || that_present_presence) {
            if (!this_present_presence || !that_present_presence) {
                return false;
            }
            if (!this.presence.equals(that.presence)) {
                return false;
            }
        }
        boolean this_present_sort_state = this.isSetSort_state();
        boolean that_present_sort_state = that.isSetSort_state();
        if (this_present_sort_state || that_present_sort_state) {
            if (!this_present_sort_state || !that_present_sort_state) {
                return false;
            }
            if (!this.sort_state.equals((Object)that.sort_state)) {
                return false;
            }
        }
        boolean this_present_encoders = this.isSetEncoders();
        boolean that_present_encoders = that.isSetEncoders();
        if (this_present_encoders || that_present_encoders) {
            if (!this_present_encoders || !that_present_encoders) {
                return false;
            }
            if (!this.encoders.equals(that.encoders)) {
                return false;
            }
        }
        boolean this_present_encoder_meta = this.isSetEncoder_meta();
        boolean that_present_encoder_meta = that.isSetEncoder_meta();
        if (this_present_encoder_meta || that_present_encoder_meta) {
            if (!this_present_encoder_meta || !that_present_encoder_meta) {
                return false;
            }
            if (!this.encoder_meta.equals(that.encoder_meta)) {
                return false;
            }
        }
        boolean this_present_min_max = this.isSetMin_max();
        boolean that_present_min_max = that.isSetMin_max();
        if (this_present_min_max || that_present_min_max) {
            if (!this_present_min_max || !that_present_min_max) {
                return false;
            }
            if (!this.min_max.equals(that.min_max)) {
                return false;
            }
        }
        boolean this_present_numberOfRowsInpage = this.isSetNumberOfRowsInpage();
        boolean that_present_numberOfRowsInpage = that.isSetNumberOfRowsInpage();
        if (this_present_numberOfRowsInpage || that_present_numberOfRowsInpage) {
            if (!this_present_numberOfRowsInpage || !that_present_numberOfRowsInpage) {
                return false;
            }
            if (this.numberOfRowsInpage != that.numberOfRowsInpage) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_chunk_meta = this.isSetChunk_meta();
        list.add(present_chunk_meta);
        if (present_chunk_meta) {
            list.add(this.chunk_meta);
        }
        boolean present_rowMajor = true;
        list.add(present_rowMajor);
        if (present_rowMajor) {
            list.add(this.rowMajor);
        }
        boolean present_data_page_length = true;
        list.add(present_data_page_length);
        if (present_data_page_length) {
            list.add(this.data_page_length);
        }
        boolean present_rowid_page_length = this.isSetRowid_page_length();
        list.add(present_rowid_page_length);
        if (present_rowid_page_length) {
            list.add(this.rowid_page_length);
        }
        boolean present_rle_page_length = this.isSetRle_page_length();
        list.add(present_rle_page_length);
        if (present_rle_page_length) {
            list.add(this.rle_page_length);
        }
        boolean present_presence = this.isSetPresence();
        list.add(present_presence);
        if (present_presence) {
            list.add(this.presence);
        }
        boolean present_sort_state = this.isSetSort_state();
        list.add(present_sort_state);
        if (present_sort_state) {
            list.add(this.sort_state.getValue());
        }
        boolean present_encoders = this.isSetEncoders();
        list.add(present_encoders);
        if (present_encoders) {
            list.add(this.encoders);
        }
        boolean present_encoder_meta = this.isSetEncoder_meta();
        list.add(present_encoder_meta);
        if (present_encoder_meta) {
            list.add(this.encoder_meta);
        }
        boolean present_min_max = this.isSetMin_max();
        list.add(present_min_max);
        if (present_min_max) {
            list.add(this.min_max);
        }
        boolean present_numberOfRowsInpage = this.isSetNumberOfRowsInpage();
        list.add(present_numberOfRowsInpage);
        if (present_numberOfRowsInpage) {
            list.add(this.numberOfRowsInpage);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(DataChunk2 other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetChunk_meta()).compareTo(other.isSetChunk_meta());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetChunk_meta() && (lastComparison = TBaseHelper.compareTo((Comparable)this.chunk_meta, (Comparable)other.chunk_meta)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRowMajor()).compareTo(other.isSetRowMajor());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRowMajor() && (lastComparison = TBaseHelper.compareTo((boolean)this.rowMajor, (boolean)other.rowMajor)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetData_page_length()).compareTo(other.isSetData_page_length());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData_page_length() && (lastComparison = TBaseHelper.compareTo((int)this.data_page_length, (int)other.data_page_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRowid_page_length()).compareTo(other.isSetRowid_page_length());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRowid_page_length() && (lastComparison = TBaseHelper.compareTo((int)this.rowid_page_length, (int)other.rowid_page_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRle_page_length()).compareTo(other.isSetRle_page_length());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRle_page_length() && (lastComparison = TBaseHelper.compareTo((int)this.rle_page_length, (int)other.rle_page_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPresence()).compareTo(other.isSetPresence());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPresence() && (lastComparison = TBaseHelper.compareTo((Comparable)this.presence, (Comparable)other.presence)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSort_state()).compareTo(other.isSetSort_state());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSort_state() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sort_state), (Comparable)((Object)other.sort_state))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncoders()).compareTo(other.isSetEncoders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncoders() && (lastComparison = TBaseHelper.compareTo(this.encoders, other.encoders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncoder_meta()).compareTo(other.isSetEncoder_meta());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncoder_meta() && (lastComparison = TBaseHelper.compareTo(this.encoder_meta, other.encoder_meta)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMin_max()).compareTo(other.isSetMin_max());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMin_max() && (lastComparison = TBaseHelper.compareTo((Comparable)this.min_max, (Comparable)other.min_max)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumberOfRowsInpage()).compareTo(other.isSetNumberOfRowsInpage());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumberOfRowsInpage() && (lastComparison = TBaseHelper.compareTo((int)this.numberOfRowsInpage, (int)other.numberOfRowsInpage)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataChunk2(");
        boolean first = true;
        sb.append("chunk_meta:");
        if (this.chunk_meta == null) {
            sb.append("null");
        } else {
            sb.append(this.chunk_meta);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("rowMajor:");
        sb.append(this.rowMajor);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("data_page_length:");
        sb.append(this.data_page_length);
        first = false;
        if (this.isSetRowid_page_length()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("rowid_page_length:");
            sb.append(this.rowid_page_length);
            first = false;
        }
        if (this.isSetRle_page_length()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("rle_page_length:");
            sb.append(this.rle_page_length);
            first = false;
        }
        if (this.isSetPresence()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("presence:");
            if (this.presence == null) {
                sb.append("null");
            } else {
                sb.append(this.presence);
            }
            first = false;
        }
        if (this.isSetSort_state()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sort_state:");
            if (this.sort_state == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.sort_state);
            }
            first = false;
        }
        if (this.isSetEncoders()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encoders:");
            if (this.encoders == null) {
                sb.append("null");
            } else {
                sb.append(this.encoders);
            }
            first = false;
        }
        if (this.isSetEncoder_meta()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encoder_meta:");
            if (this.encoder_meta == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.encoder_meta, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetMin_max()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("min_max:");
            if (this.min_max == null) {
                sb.append("null");
            } else {
                sb.append(this.min_max);
            }
            first = false;
        }
        if (this.isSetNumberOfRowsInpage()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("numberOfRowsInpage:");
            sb.append(this.numberOfRowsInpage);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.chunk_meta == null) {
            throw new TProtocolException("Required field 'chunk_meta' was not present! Struct: " + this.toString());
        }
        if (this.chunk_meta != null) {
            this.chunk_meta.validate();
        }
        if (this.presence != null) {
            this.presence.validate();
        }
        if (this.min_max != null) {
            this.min_max.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new DataChunk2StandardSchemeFactory());
        schemes.put(TupleScheme.class, new DataChunk2TupleSchemeFactory());
        optionals = new _Fields[]{_Fields.ROWID_PAGE_LENGTH, _Fields.RLE_PAGE_LENGTH, _Fields.PRESENCE, _Fields.SORT_STATE, _Fields.ENCODERS, _Fields.ENCODER_META, _Fields.MIN_MAX, _Fields.NUMBER_OF_ROWS_INPAGE};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CHUNK_META, new FieldMetaData("chunk_meta", 1, (FieldValueMetaData)new StructMetaData(12, ChunkCompressionMeta.class)));
        tmpMap.put(_Fields.ROW_MAJOR, new FieldMetaData("rowMajor", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.DATA_PAGE_LENGTH, new FieldMetaData("data_page_length", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ROWID_PAGE_LENGTH, new FieldMetaData("rowid_page_length", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.RLE_PAGE_LENGTH, new FieldMetaData("rle_page_length", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PRESENCE, new FieldMetaData("presence", 2, (FieldValueMetaData)new StructMetaData(12, PresenceMeta.class)));
        tmpMap.put(_Fields.SORT_STATE, new FieldMetaData("sort_state", 2, (FieldValueMetaData)new EnumMetaData(16, SortState.class)));
        tmpMap.put(_Fields.ENCODERS, new FieldMetaData("encoders", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new EnumMetaData(16, Encoding.class))));
        tmpMap.put(_Fields.ENCODER_META, new FieldMetaData("encoder_meta", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.MIN_MAX, new FieldMetaData("min_max", 2, (FieldValueMetaData)new StructMetaData(12, BlockletMinMaxIndex.class)));
        tmpMap.put(_Fields.NUMBER_OF_ROWS_INPAGE, new FieldMetaData("numberOfRowsInpage", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(DataChunk2.class, metaDataMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataChunk2TupleScheme
    extends TupleScheme<DataChunk2> {
        private DataChunk2TupleScheme() {
        }

        public void write(TProtocol prot, DataChunk2 struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.chunk_meta.write((TProtocol)oprot);
            oprot.writeBool(struct.rowMajor);
            oprot.writeI32(struct.data_page_length);
            BitSet optionals = new BitSet();
            if (struct.isSetRowid_page_length()) {
                optionals.set(0);
            }
            if (struct.isSetRle_page_length()) {
                optionals.set(1);
            }
            if (struct.isSetPresence()) {
                optionals.set(2);
            }
            if (struct.isSetSort_state()) {
                optionals.set(3);
            }
            if (struct.isSetEncoders()) {
                optionals.set(4);
            }
            if (struct.isSetEncoder_meta()) {
                optionals.set(5);
            }
            if (struct.isSetMin_max()) {
                optionals.set(6);
            }
            if (struct.isSetNumberOfRowsInpage()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetRowid_page_length()) {
                oprot.writeI32(struct.rowid_page_length);
            }
            if (struct.isSetRle_page_length()) {
                oprot.writeI32(struct.rle_page_length);
            }
            if (struct.isSetPresence()) {
                struct.presence.write((TProtocol)oprot);
            }
            if (struct.isSetSort_state()) {
                oprot.writeI32(struct.sort_state.getValue());
            }
            if (struct.isSetEncoders()) {
                oprot.writeI32(struct.encoders.size());
                for (Encoding _iter64 : struct.encoders) {
                    oprot.writeI32(_iter64.getValue());
                }
            }
            if (struct.isSetEncoder_meta()) {
                oprot.writeI32(struct.encoder_meta.size());
                for (ByteBuffer _iter65 : struct.encoder_meta) {
                    oprot.writeBinary(_iter65);
                }
            }
            if (struct.isSetMin_max()) {
                struct.min_max.write((TProtocol)oprot);
            }
            if (struct.isSetNumberOfRowsInpage()) {
                oprot.writeI32(struct.numberOfRowsInpage);
            }
        }

        public void read(TProtocol prot, DataChunk2 struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.chunk_meta = new ChunkCompressionMeta();
            struct.chunk_meta.read((TProtocol)iprot);
            struct.setChunk_metaIsSet(true);
            struct.rowMajor = iprot.readBool();
            struct.setRowMajorIsSet(true);
            struct.data_page_length = iprot.readI32();
            struct.setData_page_lengthIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.rowid_page_length = iprot.readI32();
                struct.setRowid_page_lengthIsSet(true);
            }
            if (incoming.get(1)) {
                struct.rle_page_length = iprot.readI32();
                struct.setRle_page_lengthIsSet(true);
            }
            if (incoming.get(2)) {
                struct.presence = new PresenceMeta();
                struct.presence.read((TProtocol)iprot);
                struct.setPresenceIsSet(true);
            }
            if (incoming.get(3)) {
                struct.sort_state = SortState.findByValue(iprot.readI32());
                struct.setSort_stateIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list66 = new TList(8, iprot.readI32());
                struct.encoders = new ArrayList<Encoding>(_list66.size);
                for (int _i68 = 0; _i68 < _list66.size; ++_i68) {
                    Encoding _elem67 = Encoding.findByValue(iprot.readI32());
                    struct.encoders.add(_elem67);
                }
                struct.setEncodersIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list69 = new TList(11, iprot.readI32());
                struct.encoder_meta = new ArrayList<ByteBuffer>(_list69.size);
                for (int _i71 = 0; _i71 < _list69.size; ++_i71) {
                    ByteBuffer _elem70 = iprot.readBinary();
                    struct.encoder_meta.add(_elem70);
                }
                struct.setEncoder_metaIsSet(true);
            }
            if (incoming.get(6)) {
                struct.min_max = new BlockletMinMaxIndex();
                struct.min_max.read((TProtocol)iprot);
                struct.setMin_maxIsSet(true);
            }
            if (incoming.get(7)) {
                struct.numberOfRowsInpage = iprot.readI32();
                struct.setNumberOfRowsInpageIsSet(true);
            }
        }
    }

    private static class DataChunk2TupleSchemeFactory
    implements SchemeFactory {
        private DataChunk2TupleSchemeFactory() {
        }

        public DataChunk2TupleScheme getScheme() {
            return new DataChunk2TupleScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataChunk2StandardScheme
    extends StandardScheme<DataChunk2> {
        private DataChunk2StandardScheme() {
        }

        public void read(TProtocol iprot, DataChunk2 struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.chunk_meta = new ChunkCompressionMeta();
                            struct.chunk_meta.read(iprot);
                            struct.setChunk_metaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 2) {
                            struct.rowMajor = iprot.readBool();
                            struct.setRowMajorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.data_page_length = iprot.readI32();
                            struct.setData_page_lengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.rowid_page_length = iprot.readI32();
                            struct.setRowid_page_lengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.rle_page_length = iprot.readI32();
                            struct.setRle_page_lengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.presence = new PresenceMeta();
                            struct.presence.read(iprot);
                            struct.setPresenceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.sort_state = SortState.findByValue(iprot.readI32());
                            struct.setSort_stateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list56 = iprot.readListBegin();
                            struct.encoders = new ArrayList<Encoding>(_list56.size);
                            for (int _i58 = 0; _i58 < _list56.size; ++_i58) {
                                Encoding _elem57 = Encoding.findByValue(iprot.readI32());
                                struct.encoders.add(_elem57);
                            }
                            iprot.readListEnd();
                            struct.setEncodersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list59 = iprot.readListBegin();
                            struct.encoder_meta = new ArrayList<ByteBuffer>(_list59.size);
                            for (int _i61 = 0; _i61 < _list59.size; ++_i61) {
                                ByteBuffer _elem60 = iprot.readBinary();
                                struct.encoder_meta.add(_elem60);
                            }
                            iprot.readListEnd();
                            struct.setEncoder_metaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.min_max = new BlockletMinMaxIndex();
                            struct.min_max.read(iprot);
                            struct.setMin_maxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.numberOfRowsInpage = iprot.readI32();
                            struct.setNumberOfRowsInpageIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetRowMajor()) {
                throw new TProtocolException("Required field 'rowMajor' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetData_page_length()) {
                throw new TProtocolException("Required field 'data_page_length' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, DataChunk2 struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.chunk_meta != null) {
                oprot.writeFieldBegin(CHUNK_META_FIELD_DESC);
                struct.chunk_meta.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(ROW_MAJOR_FIELD_DESC);
            oprot.writeBool(struct.rowMajor);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DATA_PAGE_LENGTH_FIELD_DESC);
            oprot.writeI32(struct.data_page_length);
            oprot.writeFieldEnd();
            if (struct.isSetRowid_page_length()) {
                oprot.writeFieldBegin(ROWID_PAGE_LENGTH_FIELD_DESC);
                oprot.writeI32(struct.rowid_page_length);
                oprot.writeFieldEnd();
            }
            if (struct.isSetRle_page_length()) {
                oprot.writeFieldBegin(RLE_PAGE_LENGTH_FIELD_DESC);
                oprot.writeI32(struct.rle_page_length);
                oprot.writeFieldEnd();
            }
            if (struct.presence != null && struct.isSetPresence()) {
                oprot.writeFieldBegin(PRESENCE_FIELD_DESC);
                struct.presence.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.sort_state != null && struct.isSetSort_state()) {
                oprot.writeFieldBegin(SORT_STATE_FIELD_DESC);
                oprot.writeI32(struct.sort_state.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.encoders != null && struct.isSetEncoders()) {
                oprot.writeFieldBegin(ENCODERS_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.encoders.size()));
                for (Encoding _iter62 : struct.encoders) {
                    oprot.writeI32(_iter62.getValue());
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.encoder_meta != null && struct.isSetEncoder_meta()) {
                oprot.writeFieldBegin(ENCODER_META_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.encoder_meta.size()));
                for (ByteBuffer _iter63 : struct.encoder_meta) {
                    oprot.writeBinary(_iter63);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.min_max != null && struct.isSetMin_max()) {
                oprot.writeFieldBegin(MIN_MAX_FIELD_DESC);
                struct.min_max.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNumberOfRowsInpage()) {
                oprot.writeFieldBegin(NUMBER_OF_ROWS_INPAGE_FIELD_DESC);
                oprot.writeI32(struct.numberOfRowsInpage);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class DataChunk2StandardSchemeFactory
    implements SchemeFactory {
        private DataChunk2StandardSchemeFactory() {
        }

        public DataChunk2StandardScheme getScheme() {
            return new DataChunk2StandardScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum _Fields implements TFieldIdEnum
    {
        CHUNK_META(1, "chunk_meta"),
        ROW_MAJOR(2, "rowMajor"),
        DATA_PAGE_LENGTH(3, "data_page_length"),
        ROWID_PAGE_LENGTH(4, "rowid_page_length"),
        RLE_PAGE_LENGTH(5, "rle_page_length"),
        PRESENCE(6, "presence"),
        SORT_STATE(7, "sort_state"),
        ENCODERS(8, "encoders"),
        ENCODER_META(9, "encoder_meta"),
        MIN_MAX(10, "min_max"),
        NUMBER_OF_ROWS_INPAGE(11, "numberOfRowsInpage");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CHUNK_META;
                }
                case 2: {
                    return ROW_MAJOR;
                }
                case 3: {
                    return DATA_PAGE_LENGTH;
                }
                case 4: {
                    return ROWID_PAGE_LENGTH;
                }
                case 5: {
                    return RLE_PAGE_LENGTH;
                }
                case 6: {
                    return PRESENCE;
                }
                case 7: {
                    return SORT_STATE;
                }
                case 8: {
                    return ENCODERS;
                }
                case 9: {
                    return ENCODER_META;
                }
                case 10: {
                    return MIN_MAX;
                }
                case 11: {
                    return NUMBER_OF_ROWS_INPAGE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

