/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JAXRSServerFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public JAXRSServerFactoryBeanDefinitionParser() {
        this.setBeanClass(SpringJAXRSServerFactoryBean.class);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("beanNames".equals(name)) {
            String[] values = val.split(" ");
            ArrayList<SpringResourceFactory> tempFactories = new ArrayList<SpringResourceFactory>(values.length);
            for (String v : values) {
                String theValue = v.trim();
                if (theValue.length() <= 0) continue;
                tempFactories.add(new SpringResourceFactory(theValue));
            }
            bean.addPropertyValue("tempResourceProviders", tempFactories);
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name) || "extensionMappings".equals(name) || "languageMappings".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("features".equals(name) || "schemaLocations".equals(name) || "providers".equals(name) || "serviceBeans".equals(name) || "modelBeans".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("serviceFactories".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("resourceProviders", (Object)list);
        } else if ("model".equals(name)) {
            List<UserResource> resources = ResourceUtils.getResourcesFromElement(el);
            bean.addPropertyValue("modelBeans", resources);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element, ctx, bean);
        bean.setInitMethodName("create");
        bean.setLazyInit(false);
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = super.resolveId(elem, definition, ctx);
        if (StringUtils.isEmpty((String)id)) {
            id = this.getBeanClass().getName() + "--" + definition.hashCode();
        }
        return id;
    }

    protected boolean hasBusProperty() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SpringJAXRSServerFactoryBean
    extends JAXRSServerFactoryBean
    implements ApplicationContextAware {
        private List<SpringResourceFactory> tempFactories;

        public SpringJAXRSServerFactoryBean() {
        }

        public SpringJAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
            super(sf);
        }

        public void setTempResourceProviders(List<SpringResourceFactory> providers) {
            this.tempFactories = providers;
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.tempFactories != null) {
                ArrayList<ResourceProvider> factories = new ArrayList<ResourceProvider>(this.tempFactories.size());
                for (int i = 0; i < this.tempFactories.size(); ++i) {
                    SpringResourceFactory factory = this.tempFactories.get(i);
                    factory.setApplicationContext(ctx);
                    factories.add(factory);
                }
                this.tempFactories.clear();
                super.setResourceProviders(factories);
            }
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
            }
        }
    }
}

