/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class VersionRange
implements Comparable {
    Version high;
    Version low;
    char start = (char)91;
    char end = (char)93;
    static String V = "[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[a-zA-Z0-9_-]+)?)?)?";
    static Pattern RANGE = Pattern.compile("(\\(|\\[)(" + V + "),(" + V + ")(\\)|\\])");

    public VersionRange(String string) {
        string = string.trim();
        Matcher m = RANGE.matcher(string);
        if (m.matches()) {
            this.start = m.group(1).charAt(0);
            this.low = new Version(m.group(2));
            this.high = new Version(m.group(6));
            this.end = m.group(10).charAt(0);
            if (this.low.compareTo((Object)this.high) >= 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            this.high = this.low = new Version(string);
        }
    }

    public boolean isRange() {
        return this.high != this.low;
    }

    public boolean includeLow() {
        return this.start == '[';
    }

    public boolean includeHigh() {
        return this.end == ']';
    }

    public String toString() {
        if (this.high == this.low) {
            return this.high.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.start);
        sb.append(this.low);
        sb.append(',');
        sb.append(this.high);
        sb.append(this.end);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof VersionRange) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.low.hashCode() * this.high.hashCode();
    }

    public int compareTo(Object other) {
        VersionRange range = (VersionRange)other;
        VersionRange a = this;
        VersionRange b = range;
        if (range.isRange()) {
            a = range;
            b = this;
        } else if (!this.isRange()) {
            return this.low.compareTo((Object)range.high);
        }
        int l = a.low.compareTo((Object)b.low);
        boolean ll = false;
        if (a.includeLow()) {
            ll = l <= 0;
        } else {
            boolean bl = ll = l < 0;
        }
        if (!ll) {
            return -1;
        }
        int h = a.high.compareTo((Object)b.high);
        if (a.includeHigh()) {
            ll = h >= 0;
        } else {
            boolean bl = ll = h > 0;
        }
        if (ll) {
            return 0;
        }
        return 1;
    }
}

