/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.co.BatchCoBroadcastWithKeyedOperator;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithKeyedOperator;
import org.apache.flink.streaming.api.transformations.KeyedBroadcastStateTransformation;
import org.apache.flink.streaming.runtime.translators.AbstractTwoInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.BatchExecutionUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class KeyedBroadcastStateTransformationTranslator<KEY, IN1, IN2, OUT>
extends AbstractTwoInputTransformationTranslator<IN1, IN2, OUT, KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        BatchCoBroadcastWithKeyedOperator<KEY, IN1, IN2, OUT> operator = new BatchCoBroadcastWithKeyedOperator<KEY, IN1, IN2, OUT>(transformation.getUserFunction(), transformation.getBroadcastStateDescriptors());
        Collection<Integer> result = this.translateInternal(transformation, transformation.getRegularInput(), transformation.getBroadcastInput(), SimpleOperatorFactory.of(operator), transformation.getStateKeyType(), transformation.getKeySelector(), null, context);
        BatchExecutionUtils.applyBatchExecutionSettings(transformation.getId(), context, StreamConfig.InputRequirement.SORTED, StreamConfig.InputRequirement.PASS_THROUGH);
        return result;
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        CoBroadcastWithKeyedOperator<KEY, IN1, IN2, OUT> operator = new CoBroadcastWithKeyedOperator<KEY, IN1, IN2, OUT>(transformation.getUserFunction(), transformation.getBroadcastStateDescriptors());
        return this.translateInternal(transformation, transformation.getRegularInput(), transformation.getBroadcastInput(), SimpleOperatorFactory.of(operator), transformation.getStateKeyType(), transformation.getKeySelector(), null, context);
    }
}

