/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=r!B\u001a5\u0011\u0003Id!B\u001e5\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005bB#\u0002\u0005\u0004%\tA\u0012\u0005\u0007\u0015\u0006\u0001\u000b\u0011B$\u0007\tm\"\u0004a\u0013\u0005\u0006\u0007\u0016!\t\u0001\u0014\u0005\b\u000b\u0016\u0011\r\u0011\"\u0001G\u0011\u0019QU\u0001)A\u0005\u000f\"9a*\u0002b\u0001\n\u0003y\u0005BB.\u0006A\u0003%\u0001\u000bC\u0004]\u000b\t\u0007I\u0011A/\t\r\u0011,\u0001\u0015!\u0003_\u0011%)W\u00011AA\u0002\u0013\u0005a\rC\u0005p\u000b\u0001\u0007\t\u0019!C\u0001a\"Ia/\u0002a\u0001\u0002\u0003\u0006Ka\u001a\u0005\no\u0016\u0001\r\u00111A\u0005\u0002\u0019D\u0011\u0002_\u0003A\u0002\u0003\u0007I\u0011A=\t\u0013m,\u0001\u0019!A!B\u00139\u0007\"\u0003?\u0006\u0001\u0004\u0005\r\u0011\"\u0001g\u0011%iX\u00011AA\u0002\u0013\u0005a\u0010\u0003\u0006\u0002\u0002\u0015\u0001\r\u0011!Q!\n\u001dD1\"a\u0001\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006!Y\u00111C\u0003A\u0002\u0003\u0007I\u0011AA\u000b\u0011-\tI\"\u0002a\u0001\u0002\u0003\u0006K!a\u0002\t\u0017\u0005mQ\u00011AA\u0002\u0013\u0005\u0011Q\u0004\u0005\f\u0003w)\u0001\u0019!a\u0001\n\u0003\ti\u0004C\u0006\u0002B\u0015\u0001\r\u0011!Q!\n\u0005}\u0001bCA\"\u000b\u0001\u0007\t\u0019!C\u0001\u0003\u000bB1\"!\u0014\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002P!Y\u00111K\u0003A\u0002\u0003\u0005\u000b\u0015BA$\u0011-\t)&\u0002a\u0001\u0002\u0004%\t!a\u0016\t\u0017\u0005}S\u00011AA\u0002\u0013\u0005\u0011\u0011\r\u0005\f\u0003K*\u0001\u0019!A!B\u0013\tI\u0006C\u0006\u0002h\u0015\u0001\r\u00111A\u0005\u0002\u0005%\u0004bCA>\u000b\u0001\u0007\t\u0019!C\u0001\u0003{B1\"!!\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002l!I\u00111Q\u0003C\u0002\u0013\u0005\u0011Q\u0011\u0005\t\u0003\u001b+\u0001\u0015!\u0003\u0002\b\"I\u0011qR\u0003C\u0002\u0013\u0005\u0011\u0011\u0013\u0005\t\u00037+\u0001\u0015!\u0003\u0002\u0014\"I\u0011QT\u0003C\u0002\u0013\u0005\u0011q\u0014\u0005\t\u0003[+\u0001\u0015!\u0003\u0002\"\"Y\u0011qV\u0003A\u0002\u0003\u0007I\u0011AAY\u0011-\tI,\u0002a\u0001\u0002\u0004%\t!a/\t\u0017\u0005}V\u00011A\u0001B\u0003&\u00111\u0017\u0005\b\u0003\u0003,A\u0011AAb\u0011\u001d\tY.\u0002C\t\u0003;Dq!!;\u0006\t\u0003\tY\u000fC\u0004\u0003\u0014\u0015!\t!a1\t\u000f\tuQ\u0001\"\u0005\u0003 \u0005)\u0012IY:ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8UKN$(BA\u001b7\u0003\u001d\u0019G.^:uKJT\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001!\tQ\u0014!D\u00015\u0005U\t%m\u001d;sC\u000e$\b+\u0019:uSRLwN\u001c+fgR\u001c\"!A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011(\u0001\u0005ce>\\WM]%e+\u00059\u0005C\u0001 I\u0013\tIuHA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0014\u0005\u0015iD#A'\u0011\u0005i*\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002!B\u0011\u0011+W\u0007\u0002%*\u00111\u000bV\u0001\u0007G>lWn\u001c8\u000b\u0005]*&B\u0001,X\u0003\u0019\t\u0007/Y2iK*\t\u0001,A\u0002pe\u001eL!A\u0017*\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0003uS6,W#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u00054\u0014!B;uS2\u001c\u0018BA2a\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;na\u0012K'/F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0002j_*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000f\u0006\u0002riB\u0011aH]\u0005\u0003g~\u0012A!\u00168ji\"9QODA\u0001\u0002\u00049\u0017a\u0001=%c\u00059A/\u001c9ESJ\u0004\u0013a\u00027pO\u0012K'/M\u0001\fY><G)\u001b:2?\u0012*\u0017\u000f\u0006\u0002ru\"9Q/EA\u0001\u0002\u00049\u0017\u0001\u00037pO\u0012K'/\r\u0011\u0002\u000f1|w\rR5se\u0005YAn\\4ESJ\u0014t\fJ3r)\t\tx\u0010C\u0004v)\u0005\u0005\t\u0019A4\u0002\u00111|w\rR5se\u0001\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAN\u0001\u0004Y><\u0017\u0002BA\t\u0003\u0017\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$2!]A\f\u0011!)x#!AA\u0002\u0005\u001d\u0011a\u00037pO6\u000bg.Y4fe\u0002\nq\"\u00197uKJL5O]'b]\u0006<WM]\u000b\u0003\u0003?\u0001B!!\t\u000269!\u00111EA\u0019\u001d\u0011\t)#a\f\u000f\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b9\u0003\u0019a$o\\8u}%\tq'\u0003\u0002bm%\u0019\u00111\u00071\u0002\u0013Q+7\u000f^+uS2\u001c\u0018\u0002BA\u001c\u0003s\u00111#T8dW\u0006cG/\u001a:JgJl\u0015M\\1hKJT1!a\ra\u0003M\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014x\fJ3r)\r\t\u0018q\b\u0005\tkj\t\t\u00111\u0001\u0002 \u0005\u0001\u0012\r\u001c;fe&\u001b(/T1oC\u001e,'\u000fI\u0001\u0012SN\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XCAA$!\u0011\t\t#!\u0013\n\t\u0005-\u0013\u0011\b\u0002\u0016\u001b>\u001c7.S:s\u0007\"\fgnZ3MSN$XM\\3s\u0003UI7O]\"iC:<W\rT5ti\u0016tWM]0%KF$2!]A)\u0011!)X$!AA\u0002\u0005\u001d\u0013AE5te\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u0005e\u0003\u0003BA\u0005\u00037JA!!\u0018\u0002\f\tIAj\\4D_:4\u0017nZ\u0001\u000eY><7i\u001c8gS\u001e|F%Z9\u0015\u0007E\f\u0019\u0007\u0003\u0005vA\u0005\u0005\t\u0019AA-\u0003)awnZ\"p]\u001aLw\rI\u0001\u0011G>tg-[4SKB|7/\u001b;pef,\"!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005AQ.\u001a;bI\u0006$\u0018MC\u0002\u0002vY\naa]3sm\u0016\u0014\u0018\u0002BA=\u0003_\u0012A#T8dW\u000e{gNZ5h%\u0016\u0004xn]5u_JL\u0018\u0001F2p]\u001aLwMU3q_NLGo\u001c:z?\u0012*\u0017\u000fF\u0002r\u0003\u007fB\u0001\"^\u0012\u0002\u0002\u0003\u0007\u00111N\u0001\u0012G>tg-[4SKB|7/\u001b;pef\u0004\u0013!\u00053fY\u0006LX\rZ(qKJ\fG/[8ogV\u0011\u0011q\u0011\t\u0004u\u0005%\u0015bAAFi\t\tB)\u001a7bs\u0016$w\n]3sCRLwN\\:\u0002%\u0011,G.Y=fI>\u0003XM]1uS>t7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005M\u0005\u0003BAK\u0003/k!!a\u001d\n\t\u0005e\u00151\u000f\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005\trN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005\u0005\u0006\u0003BAR\u0003Sk!!!*\u000b\t\u0005\u001d\u00161O\u0001\fG\",7m\u001b9pS:$8/\u0003\u0003\u0002,\u0006\u0015&!E(gMN,Go\u00115fG.\u0004x.\u001b8ug\u0006\u0011rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u00024B\u0019!(!.\n\u0007\u0005]FGA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$2!]A_\u0011!)H&!AA\u0002\u0005M\u0016A\u00039beRLG/[8oA\u0005)1/\u001a;vaR\t\u0011\u000fK\u0002/\u0003\u000f\u0004B!!3\u0002X6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-A\u0002ba&TA!!5\u0002T\u00069!.\u001e9ji\u0016\u0014(bAAk/\u0006)!.\u001e8ji&!\u0011\u0011\\Af\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001bS:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\\\u000b\u0003\u0003?\u0004B!!9\u0002f6\u0011\u00111\u001d\u0006\u0004\u0003\u001b4\u0014\u0002BAt\u0003G\u0014!\"\u00119j-\u0016\u00148/[8o\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\ti/!?\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=l\u0003\u0011)H/\u001b7\n\t\u0005]\u0018\u0011\u001f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA~a\u0001\u0007\u0011Q`\u0001\n_Z,'O]5eKN\u0004\u0002\"a@\u0003\b\t5!Q\u0002\b\u0005\u0005\u0003\u0011\u0019\u0001E\u0002\u0002(}J1A!\u0002@\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0002B\u0006\u0005\ri\u0015\r\u001d\u0006\u0004\u0005\u000by\u0004\u0003BA\u0000\u0005\u001fIAA!\u0005\u0003\f\t11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004c\t]\u0001\u0003BAe\u00053IAAa\u0007\u0002L\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$b!a-\u0003\"\t\u0015\u0002B\u0002B\u0012e\u0001\u0007q)A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002B\u0014e\u0001\u0007!\u0011F\u0001\tSNdU-\u00193feB\u0019aHa\u000b\n\u0007\t5rHA\u0004C_>dW-\u00198")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;
    private TestUtils.MockIsrChangeListener isrChangeListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    public TestUtils.MockIsrChangeListener isrChangeListener() {
        return this.isrChangeListener;
    }

    public void isrChangeListener_$eq(TestUtils.MockIsrChangeListener x$1) {
        this.isrChangeListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        String string;
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), this.configRepository(), new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), this.interBrokerProtocolVersion()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterIsrManager_$eq(new TestUtils.MockAlterIsrManager());
        this.isrChangeListener_$eq(new TestUtils.MockIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public ApiVersion interBrokerProtocolVersion() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }
}

