/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011\bC\u0004A\u0001\u0001\u0007I\u0011A!\t\r\u001d\u0003\u0001\u0015)\u0003;\u0011\u001dA\u0005\u00011A\u0005\u0002%Cq\u0001\u0016\u0001A\u0002\u0013\u0005Q\u000b\u0003\u0004X\u0001\u0001\u0006KA\u0013\u0005\u00061\u0002!\t!\u0017\u0005\u0006O\u0002!\t!\u0017\u0005\u0006Y\u0002!\t!\u0017\u0005\u0006c\u0002!\t!\u0017\u0005\u0006g\u0002!\t!\u0017\u0005\u0006k\u0002!\t!\u0017\u0005\u0006o\u0002!\t!\u0017\u0005\u0006s\u0002!\t!\u0017\u0005\u0006w\u0002!\t!\u0017\u0005\u0006{\u0002!\t!\u0017\u0005\u0006\u007f\u0002!\t!\u0017\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t)\u0007\u0001C\u0005\u0003O2a!!\u0006\u0001\u0001\u0005]\u0001\u0002DA\r+\t\u0005\t\u0015!\u0003\u0002\u001c\u0005\u0005\u0002BCA\u0012+\t\u0005\t\u0015!\u0003\u0002&!Q\u0011qG\u000b\u0003\u0006\u0004%\t!!\u000f\t\u0015\u0005mRC!A!\u0002\u0013\t)\u0003\u0003\u00045+\u0011\u0005\u0011Q\b\u0005\n\u0003\u000b*\u0002\u0019!C\u0001\u0003\u000fB\u0011\"a\u0014\u0016\u0001\u0004%\t!!\u0015\t\u0011\u0005US\u0003)Q\u0005\u0003\u0013Ba!a\u0016\u0016\t\u0003I\u0006bBA-+\u0011\u0005\u00131\f\u0005\u0007\u0003;*B\u0011I-\t\r\u0005}S\u0003\"\u0011Z\u000f%\t\t\nAA\u0001\u0012\u0003\t\u0019JB\u0005\u0002\u0016\u0001\t\t\u0011#\u0001\u0002\u0016\"1Ag\tC\u0001\u0003/C\u0011\"!'$#\u0003%\t!a'\t\u0013\u0005E6%%A\u0005\u0002\u0005m%\u0001\u0006#fY\u0006LX\rZ(qKJ\fG/[8o)\u0016\u001cHO\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003!\n\u0011\u0002];sO\u0006$xN]=\u0016\u0003i\u00022aN\u001e>\u0013\ta\u0004FA\rEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B+(oZ1u_JL\bCA\u001c?\u0013\ty\u0004F\u0001\tEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]\u0006i\u0001/\u001e:hCR|'/_0%KF$\"AQ#\u0011\u0005=\u001a\u0015B\u0001#1\u0005\u0011)f.\u001b;\t\u000f\u0019\u001b\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002\u0015A,(oZ1u_JL\b%A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f+\u0005Q\u0005CA&S\u001b\u0005a%BA'O\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001fB\u000bA!\u001e;jY*\t\u0011+\u0001\u0003kCZ\f\u0017BA*M\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017aE3yK\u000e,Ho\u001c:TKJ4\u0018nY3`I\u0015\fHC\u0001\"W\u0011\u001d1e!!AA\u0002)\u000b\u0001#\u001a=fGV$xN]*feZL7-\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003\tC#\u0001C.\u0011\u0005q+W\"A/\u000b\u0005y{\u0016aA1qS*\u0011\u0001-Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00117-A\u0003kk:LGOC\u0001e\u0003\ry'oZ\u0005\u0003Mv\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007FA\u0005j!\ta&.\u0003\u0002l;\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001fi\u0016\u001cH\u000fT8dW&sGK]=D_6\u0004H.\u001a;f\u000b2\u001cXmV1uG\"D#A\u00038\u0011\u0005q{\u0017B\u00019^\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^*bM\u0016$&/_\"p[BdW\r^3Pe\u0016c7/\u001a\u0015\u0003\u00179\fq\u0003^3tiJ+\u0017/^3tiN\u000bG/[:gC\u000e$\u0018n\u001c8)\u00051q\u0017!\u0005;fgR\u0014V-];fgR,\u0005\u0010]5ss\"\u0012QB\\\u0001\u0012i\u0016\u001cH\u000fR3mCf,GMR;ukJ,\u0007F\u0001\bo\u0003A!Xm\u001d;SKF,Xm\u001d;QkJ<W\r\u000b\u0002\u0010]\u0006q3\u000f[8vY\u0012\u001c\u0015M\\2fY\u001a{'oS3z%\u0016$XO\u001d8j]\u001e\u001c\u0015M\\2fY2,Gm\u00149fe\u0006$\u0018n\u001c8tQ\t\u0001b.A\u001dtQ>,H\u000e\u001a*fiV\u0014hNT5m\u001fB,'/\u0019;j_:\u001cxJ\\\"b]\u000e,GNR8s\u0017\u0016Lx\u000b[3o\u0017\u0016LHi\\3t]R,\u00050[:uQ\t\tb.\u0001\u0012uKN$HK]=D_6\u0004H.\u001a;f/&$\b.T;mi&\u0004H.\u001a+ie\u0016\fGm\u001d\u0015\u0003%9\f!D^3sS\u001aLH)\u001a7bs\u0016$w\n]3sCRLwN\u001c'pG.$RAQA\u0004\u0003CB\u0001\"!\u0003\u0014\t\u0003\u0007\u00111B\u0001\u0015[>\u001c7\u000eR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0011\u000b=\ni!!\u0005\n\u0007\u0005=\u0001G\u0001\u0005=Eft\u0017-\\3?!\r\t\u0019\"F\u0007\u0002\u0001\t!Rj\\2l\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\"!F\u001f\u0002\u000f\u0011,G.Y=NgB\u0019q&!\b\n\u0007\u0005}\u0001G\u0001\u0003M_:<\u0017bAA\r}\u00059An\\2l\u001fB$\b#B\u0018\u0002(\u0005-\u0012bAA\u0015a\t1q\n\u001d;j_:\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003ca\u0015!\u00027pG.\u001c\u0018\u0002BA\u001b\u0003_\u0011QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017a\u0004:fgB|gn]3M_\u000e\\w\n\u001d;\u0016\u0005\u0005\u0015\u0012\u0001\u0005:fgB|gn]3M_\u000e\\w\n\u001d;!)!\t\t\"a\u0010\u0002B\u0005\r\u0003bBA\r5\u0001\u0007\u00111\u0004\u0005\n\u0003GQ\u0002\u0013!a\u0001\u0003KA\u0011\"a\u000e\u001b!\u0003\u0005\r!!\n\u0002\u0017\r|W\u000e\u001d7fi\u0006\u0014G.Z\u000b\u0003\u0003\u0013\u00022aLA&\u0013\r\ti\u0005\r\u0002\b\u0005>|G.Z1o\u0003=\u0019w.\u001c9mKR\f'\r\\3`I\u0015\fHc\u0001\"\u0002T!Aa\tHA\u0001\u0002\u0004\tI%\u0001\u0007d_6\u0004H.\u001a;bE2,\u0007%A\bbo\u0006LG/\u0012=qSJ\fG/[8o\u0003-!(/_\"p[BdW\r^3\u0015\u0005\u0005%\u0013\u0001D8o\u000bb\u0004\u0018N]1uS>t\u0017AC8o\u0007>l\u0007\u000f\\3uK\"9\u00111M\nA\u0002\u0005%\u0013aD7jg6\fGo\u00195fI2{7m[:\u0002%I,hn\u00148B]>$\b.\u001a:UQJ,\u0017\r\u001a\u000b\u0007\u0003S\n9)!$1\t\u0005-\u0014Q\u000f\t\u0006\u0017\u00065\u0014\u0011O\u0005\u0004\u0003_b%A\u0002$viV\u0014X\r\u0005\u0003\u0002t\u0005UD\u0002\u0001\u0003\f\u0003o\"\u0012\u0011!A\u0001\u0006\u0003\tIHA\u0002`II\nB!a\u001f\u0002\u0002B\u0019q&! \n\u0007\u0005}\u0004GA\u0004O_RD\u0017N\\4\u0011\u0007=\n\u0019)C\u0002\u0002\u0006B\u00121!\u00118z\u0011!\tI\t\u0006CA\u0002\u0005-\u0015a\u00014v]B!q&!\u0004C\u0011\u001d\ty\t\u0006a\u0001\u0003\u0013\nab\u001d5pk2$7i\\7qY\u0016$X-\u0001\u000bN_\u000e\\G)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0004\u0003'\u00193CA\u0012/)\t\t\u0019*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003;SC!!\n\u0002 .\u0012\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003%)hn\u00195fG.,GMC\u0002\u0002,B\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty+!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<DelayedOperation> purgatory = null;
    private ExecutorService executorService = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<DelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<DelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<DelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", 0, 1000, true, true));
    }

    @AfterEach
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
    }

    @Test
    public void testLockInTryCompleteElseWatch() {
        DelayedOperation op = new DelayedOperation(null){

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return false;
            }

            public boolean safeTryComplete() {
                Assertions.fail((String)"tryCompleteElseWatch should not use safeTryComplete");
                return super.safeTryComplete();
            }
        };
        this.purgatory().tryCompleteElseWatch(op, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
    }

    @Test
    public void testSafeTryCompleteOrElse() {
        BooleanRef pass = BooleanRef.create((boolean)false);
        boolean op$1_shouldComplete = false;
        Assertions.assertFalse((boolean)new DelayedOperation(null, op$1_shouldComplete){
            private final boolean shouldComplete$1;

            public void onExpiration() {
            }

            public void onComplete() {
            }

            public boolean tryComplete() {
                Assertions.assertTrue((boolean)((ReentrantLock)this.lock()).isHeldByCurrentThread());
                return this.shouldComplete$1;
            }
            {
                this.shouldComplete$1 = shouldComplete$1;
                super(100000L, (Option)None$.MODULE$);
            }
        }.safeTryCompleteOrElse((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            pass$1.elem = true;
        }));
        Assertions.assertTrue((boolean)pass.elem);
        boolean op$1_shouldComplete2 = true;
        Assertions.assertTrue((boolean)new /* invalid duplicate definition of identical inner class */.safeTryCompleteOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"this method should NOT be executed")));
    }

    @Test
    public void testRequestSatisfaction() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"With no waiting requests, nothing should be satisfied");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})), (String)"r1 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"Still nothing satisfied");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})), (String)"r2 not satisfied and hence watched");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"Still nothing satisfied");
        r1.completable_$eq(true);
        Assertions.assertEquals((int)1, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"r1 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test1"), (String)"Nothing satisfied");
        r2.completable_$eq(true);
        Assertions.assertEquals((int)1, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"r2 satisfied");
        Assertions.assertEquals((int)0, (int)this.purgatory().checkAndComplete((Object)"test2"), (String)"Nothing satisfied");
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})), (String)"r1 not satisfied and hence watched");
        Assertions.assertFalse((boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})), (String)"r2 not satisfied and hence watched");
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assertions.assertTrue((boolean)r1.isCompleted(), (String)"r1 completed due to expiration");
        Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 hasn't completed");
        Assertions.assertTrue((elapsed >= expiration ? 1 : 0) != 0, (String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString());
    }

    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        AtomicInteger result = new AtomicInteger();
        Assertions.assertFalse((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
        List futures1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11))}));
        Assertions.assertTrue((boolean)purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)(JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.updateResult$1(futures1, result)).isCompleted(), (String)"r1 not completed");
        Assertions.assertEquals((int)21, (int)result.get());
        Assertions.assertFalse((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
        result.set(-1);
        List futures2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), new CompletableFuture()}));
        DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)(JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.updateResult$1(futures2, result));
        Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 should be incomplete");
        ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
        Assertions.assertFalse((boolean)r2.isCompleted());
        Assertions.assertEquals((int)-1, (int)result.get());
        ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!r2.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"r2 not completed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$9(result)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"callback not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Assertions.assertTrue((boolean)DelayedOperationTest.hasExecutorThread$1(purgatoryName), (String)"Thread not created for executing delayed task");
        result.set(-1);
        List futures3 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31))}));
        DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)(JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.updateResult$1(futures3, result));
        Assertions.assertFalse((boolean)r3.isCompleted(), (String)"r3 should be incomplete");
        Assertions.assertEquals((int)-1, (int)result.get());
        ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!r3.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"r3 not completed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        long l7 = 15000L;
        long l8 = 100L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$14(result)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + l7) {
                Assertions.fail((String)"callback not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l7), l8));
        }
        result.set(-1);
        long start = Time.SYSTEM.hiResClockMs();
        long expirationMs = 2000L;
        List futures4 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), new CompletableFuture()}));
        DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)(JFunction0.mcV.sp & Serializable)() -> DelayedOperationTest.updateResult$1(futures4, result));
        ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
        long l9 = 15000L;
        long l10 = 100L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DelayedOperationTest.$anonfun$testDelayedFuture$17(futures4)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + l9) {
                Assertions.fail((String)"r4 futures not expired");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l9), l10));
        }
        Assertions.assertTrue((boolean)r4.isCompleted(), (String)"r4 not completed after timeout");
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assertions.assertTrue((elapsed >= expirationMs ? 1 : 0) != 0, (String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expirationMs).toString());
        Assertions.assertEquals((int)40, (Integer)((Integer)((CompletableFuture)futures4.head()).get()));
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> ((CompletableFuture)futures4.apply(1)).get()).getCause().getClass());
        Assertions.assertEquals((int)40, (int)result.get());
    }

    @Test
    public void testRequestPurge() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assertions.assertEquals((int)3, (int)this.purgatory().numDelayed(), (String)"Purgatory should have 3 total delayed operations");
        Assertions.assertEquals((int)6, (int)this.purgatory().watched(), (String)"Purgatory should have 6 watched elements");
        r2.completable_$eq(true);
        r2.tryComplete();
        Assertions.assertEquals((int)2, (int)this.purgatory().numDelayed(), (String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assertions.assertEquals((int)1, (int)this.purgatory().numDelayed(), (String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().numDelayed()).toString());
        this.purgatory().checkAndComplete((Object)"test1");
        Assertions.assertEquals((int)4, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString());
        this.purgatory().checkAndComplete((Object)"test2");
        Assertions.assertEquals((int)2, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString());
        this.purgatory().checkAndComplete((Object)"test3");
        Assertions.assertEquals((int)1, (int)this.purgatory().watched(), (String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        if (this.MockDelayedOperation() == null) {
            throw null;
        }
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assertions.assertEquals((int)2, (int)cancelledOperations.size());
        Assertions.assertEquals((int)1, (int)this.purgatory().numDelayed());
        Assertions.assertEquals((int)1, (int)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assertions.assertEquals((Object)package$.MODULE$.Nil(), (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)index -> {
            public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
            extends MockDelayedOperation {
                private final String key;
                private final AtomicInteger completionAttemptsRemaining;
                private final Random random$1;
                private final int maxDelayMs$1;

                public String key() {
                    return this.key;
                }

                public AtomicInteger completionAttemptsRemaining() {
                    return this.completionAttemptsRemaining;
                }

                public boolean tryComplete() {
                    boolean shouldComplete = this.completable();
                    Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                    if (shouldComplete) {
                        return this.forceComplete();
                    }
                    return false;
                }

                public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                    this.random$1 = random$1;
                    this.maxDelayMs$1 = maxDelayMs$1;
                    if ($outer.MockDelayedOperation() == null) {
                        throw null;
                    }
                    if ($outer.MockDelayedOperation() == null) {
                        throw null;
                    }
                    super($outer, 10000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
                    this.key = new StringBuilder(3).append("key").append(index).toString();
                    this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                }
            }
            return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)index));
        });
        ((IterableOnceOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1 & Serializable)x$5 -> DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)x$5)))).foreach((Function1 & Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        int createDelayedOperations$1_count = 2;
        ObjectRef ops = ObjectRef.create((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count).map((Function1 & Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$6))));
        this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        int createDelayedOperations$1_count2 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count2).map((Function1 & Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$6)));
        Lock inLock_lock = ((DelayedOperation)((scala.collection.immutable.Seq)ops.elem).apply(1)).lock();
        inLock_lock.lock();
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)ops.elem, key);
        }
        finally {
            inLock_lock.unlock();
        }
        Object var6_7 = null;
        int createDelayedOperations$1_count3 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count3).map((Function1 & Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$6)));
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().lock();
        Future<?> runOnAnotherThread_future = this.executorService().submit(new Runnable(null, (Function0)runOnAnotherThread_fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future.isDone(), (String)"Should not have completed");
        }
        Object var8_11 = null;
        Object var10_12 = null;
        try {
            this.checkAndComplete$1((scala.collection.immutable.Seq)ops.elem, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(1))})), key);
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
            Future<?> runOnAnotherThread_future2 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assertions.assertFalse((boolean)runOnAnotherThread_future2.isDone(), (String)"Should not have completed");
            }
            Object var11_15 = null;
            Object var13_16 = null;
            this.checkAndComplete$1((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> ((DelayedOperation)((scala.collection.immutable.Seq)ops$2.elem).apply(0)).lock().unlock();
        Future<?> runOnAnotherThread_future3 = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future3.isDone(), (String)"Should not have completed");
        }
        Object var14_18 = null;
        Object var16_19 = null;
        this.checkAndComplete$1((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))})), key);
        int createDelayedOperations$1_count4 = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createDelayedOperations$1_count4).map((Function1 & Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$6)));
        ((MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1 & Serializable)lock -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, ops, mismatchedLocks, key, lock);
            return BoxedUnit.UNIT;
        });
        int createCompletableOperations$1_count = 2;
        ops.elem = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), createCompletableOperations$1_count).map((Function1 & Serializable)x$7 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation, BoxesRunTime.unboxToInt((Object)x$7)));
        ((scala.collection.immutable.Seq)ops.elem).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Future<?> future = this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (shouldComplete) {
            future.get();
        } else {
            Assertions.assertFalse((boolean)future.isDone(), (String)"Should not have completed");
        }
        return var3_3;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        synchronized (this) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
            return;
        }
    }

    private static final DelayedOperation op$1(boolean shouldComplete) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$1 -> x$1.getName())).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(new StringBuilder(16).append("DelayedExecutor-").append(purgatoryName$1).toString())));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$4) {
        return (Integer)x$4.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)futures.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompletedExceptionally())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DelayedOperationTest.$anonfun$testDelayedFuture$4(x$4))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$7(DelayedFuture r2$1) {
        return r2$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$8() {
        return "r2 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$9(AtomicInteger result$1) {
        return result$1.get() == 41;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$10() {
        return "callback not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$12(DelayedFuture r3$1) {
        return r3$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$13() {
        return "r3 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$14(AtomicInteger result$1) {
        return result$1.get() == 61;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$15() {
        return "callback not invoked";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        return ((CompletableFuture)futures4$1.apply(1)).isDone();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$18() {
        return "r4 futures not expired";
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$2;

            public void run() {
                if (this.op$2.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$2.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$2.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$2 = op$2;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$5) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        });
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Operation should have completed");
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$1, int x$6) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key$1})));
        Assertions.assertFalse((boolean)op.isCompleted(), (String)"Not completable");
        return op;
    }

    private final scala.collection.immutable.Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$1) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x$6 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation, key, BoxesRunTime.unboxToInt((Object)x$6)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$7) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    private static final scala.collection.immutable.Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x$7 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation, BoxesRunTime.unboxToInt((Object)x$7)));
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Should have completed");
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assertions.assertFalse((boolean)op.isCompleted(), (String)"Should not have completed");
    }

    private final void checkAndComplete$1(scala.collection.immutable.Seq completableOps, scala.collection.immutable.Seq expectedComplete, String key$1) {
        completableOps.foreach((Function1 & Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$1);
        Assertions.assertEquals((int)expectedComplete.size(), (int)completed);
        expectedComplete.foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        ((Set)completableOps.toSet().$minus$minus((IterableOnce)expectedComplete)).foreach((Function1 & Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$6(DelayedOperationTest $this, ObjectRef ops$2, String key$1) {
        $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)ops$2.elem, key$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$1, ReentrantLock lock) {
        void runOnAnotherThread_shouldComplete;
        void runOnAnotherThread_shouldComplete2;
        boolean bl = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun = (JFunction0.mcV.sp & Serializable)() -> lock.lock();
        Future<?> runOnAnotherThread_future = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete2 != false) {
            runOnAnotherThread_future.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future.isDone(), (String)"Should not have completed");
        }
        Object var6_6 = null;
        Object var8_7 = null;
        try {
            try {
                $this.checkAndComplete$1((scala.collection.immutable.Seq)ops$2.elem, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(1))})), key$1);
                Assertions.assertFalse((boolean)mismatchedLocks$1, (String)"Should have failed with mismatched locks");
            }
            catch (IllegalStateException illegalStateException) {
                Assertions.assertTrue((boolean)mismatchedLocks$1, (String)"Should not have failed with valid locks");
            }
        }
        catch (Throwable throwable) {
            void runOnAnotherThread_shouldComplete3;
            boolean bl2 = true;
            JFunction0.mcV.sp & Serializable runOnAnotherThread_fun2 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
            Future<?> runOnAnotherThread_future2 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
            if (runOnAnotherThread_shouldComplete3 != false) {
                runOnAnotherThread_future2.get();
            } else {
                Assertions.assertFalse((boolean)runOnAnotherThread_future2.isDone(), (String)"Should not have completed");
            }
            Object var9_10 = null;
            Object var11_11 = null;
            $this.checkAndComplete$1((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), key$1);
            throw throwable;
        }
        boolean bl3 = true;
        JFunction0.mcV.sp & Serializable runOnAnotherThread_fun3 = (JFunction0.mcV.sp & Serializable)() -> lock.unlock();
        Future<?> runOnAnotherThread_future3 = $this.executorService().submit(new /* invalid duplicate definition of identical inner class */);
        if (runOnAnotherThread_shouldComplete != false) {
            runOnAnotherThread_future3.get();
        } else {
            Assertions.assertFalse((boolean)runOnAnotherThread_future3.isDone(), (String)"Should not have completed");
        }
        Object var12_13 = null;
        Object var14_14 = null;
        $this.checkAndComplete$1((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((scala.collection.immutable.Seq)ops$2.elem).apply(0))})), key$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$1, MockDelayedOperation op) {
        Assertions.assertTrue((boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{key$1}))), (String)"Should have completed");
        Assertions.assertTrue((boolean)op.isCompleted(), (String)"Should have completed");
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            if (this.completable()) {
                return this.forceComplete();
            }
            return false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1 & Serializable)lock -> {
                MockDelayedOperation.$anonfun$onComplete$1(lock);
                return BoxedUnit.UNIT;
            });
            synchronized (this) {
                this.notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

