/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119!\u0002CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u001diWm]:bO\u0016L!!\u0004\u0006\u0003\u00155+7o]1hKN+G\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011m\u0001!Q1A\u0005\u0002q\tAAZ5mKV\tQ\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005\u0011\u0011n\u001c\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0003GS2,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000b\u0019LG.\u001a\u0011\t\u0013!\u0002!Q1A\u0005\u0002\tI\u0013aB2iC:tW\r\\\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\tG\"\fgN\\3mg*\u0011q&I\u0001\u0004]&|\u0017BA\u0019-\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\t\u0011M\u0002!\u0011!Q\u0001\n)\n\u0001b\u00195b]:,G\u000e\t\u0005\nk\u0001\u0011)\u0019!C\u0001\u0005Y\nQa\u001d;beR,\u0012a\u000e\t\u0003+aJ!!\u000f\f\u0003\u0007%sG\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u00038\u0003\u0019\u0019H/\u0019:uA!IQ\b\u0001BC\u0002\u0013\u0005!AN\u0001\u0006Y&l\u0017\u000e\u001e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005o\u00051A.[7ji\u0002B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0019S:LGo\u00115b]:,G\u000eU8tSRLwN\u001c+p\u000b:$\u0007CA\u000bD\u0013\t!eCA\u0004C_>dW-\u00198\t\r\u0019\u0003A\u0011\u0001\u0003H\u0003\u0019a\u0014N\\5u}Q1\u0001JS&M\u001b:\u0003\"!\u0013\u0001\u000e\u0003\tAQaG#A\u0002uAQ\u0001K#A\u0002)Bq!N#\u0011\u0002\u0003\u0007q\u0007C\u0004>\u000bB\u0005\t\u0019A\u001c\t\u000f\u0005+\u0005\u0013!a\u0001\u0005\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016!B0tSj,W#\u0001*\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016AB1u_6L7M\u0003\u0002X1\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005e\u000b\u0013\u0001B;uS2L!a\u0017+\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019i\u0006\u0001)A\u0005%\u00061ql]5{K\u0002BQA\u0012\u0001\u0005\u0002}#2\u0001\u00131b\u0011\u0015Yb\f1\u0001\u001e\u0011\u0015Ac\f1\u0001+\u0011\u00151\u0005\u0001\"\u0001d)\tAE\rC\u0003\u001cE\u0002\u0007Q\u0004C\u0003g\u0001\u0011\u0005q-\u0001\u0003sK\u0006$Gc\u0001%iU\")\u0011.\u001aa\u0001o\u0005A\u0001o\\:ji&|g\u000eC\u0003lK\u0002\u0007q'\u0001\u0003tSj,\u0007BB7\u0001\t\u0003\u0011a.A\u0005tK\u0006\u00148\r\u001b$peR\u0019qN]<\u0011\u0005%\u0003\u0018BA9\u0003\u00059yeMZ:fiB{7/\u001b;j_:DQa\u001d7A\u0002Q\fA\u0002^1sO\u0016$xJ\u001a4tKR\u0004\"!F;\n\u0005Y4\"\u0001\u0002'p]\u001eDQ\u0001\u001f7A\u0002]\n\u0001c\u001d;beRLgn\u001a)pg&$\u0018n\u001c8\t\u000bi\u0004A\u0011A>\u0002\u000f]\u0014\u0018\u000e^3U_R1q\u0007`A\u0002\u0003\u000fAQ!`=A\u0002y\f1\u0002Z3ti\u000eC\u0017M\u001c8fYB\u00111f`\u0005\u0004\u0003\u0003a#\u0001F$bi\",'/\u001b8h\u0005f$Xm\u00115b]:,G\u000e\u0003\u0004\u0002\u0006e\u0004\r\u0001^\u0001\u000eoJLG/\u001a)pg&$\u0018n\u001c8\t\u000b-L\b\u0019A\u001c\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u0005A\u0011\u000e^3sCR|'/\u0006\u0002\u0002\u0010A1\u0011\u0011CA\u0011\u0003OqA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0019\ta\u0001\u0010:p_Rt\u0014\"A\f\n\u0007\u0005}a#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011q\u0004\f\u0011\u0007%\tI#C\u0002\u0002,)\u0011\u0001#T3tg\u0006<W-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t)\u00059\u0004bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0007CB\u0004XM\u001c3\u0015\t\u0005e\u0012q\b\t\u0004+\u0005m\u0012bAA\u001f-\t!QK\\5u\u0011!\t\t%a\rA\u0002\u0005\r\u0013\u0001C7fgN\fw-Z:\u0011\u0007%\t)%C\u0002\u0002H)\u0011ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bbBA&\u0001\u0011\u0005\u0011QJ\u0001\u0006M2,8\u000f\u001b\u000b\u0003\u0003sAq!!\u0015\u0001\t\u0003\ti%A\u0003dY>\u001cX\rC\u0004\u0002V\u0001!\t!a\u0016\u0002\r\u0011,G.\u001a;f)\u0005\u0011\u0005bBA.\u0001\u0011\u0005\u0011QL\u0001\u000biJ,hnY1uKR{G\u0003BA\u001d\u0003?Bq!!\u0019\u0002Z\u0001\u0007q'\u0001\u0006uCJ<W\r^*ju\u0016D3\u0001AA3!\ry\u0011qM\u0005\u0004\u0003S\u0002\"!\u00048p]RD'/Z1eg\u00064WmB\u0005\u0002n\t\t\t\u0011#\u0002\u0002p\u0005qa)\u001b7f\u001b\u0016\u001c8/Y4f'\u0016$\bcA%\u0002r\u0019A\u0011AAA\u0001\u0012\u000b\t\u0019hE\u0003\u0002r\u0005UD\u0003\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY(I\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0000\u0005e$AB(cU\u0016\u001cG\u000fC\u0004G\u0003c\"\t!a!\u0015\u0005\u0005=\u0004BCAD\u0003c\n\n\u0011\"\u0001\u0002\n\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012\u001aTCAAFU\r9\u0014QR\u0016\u0003\u0003\u001f\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0014\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0006M%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011\u0011UA9#\u0003%\t!!#\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i!Q\u0011QUA9#\u0003%\t!a*\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0016\u0016\u0004\u0005\u00065\u0005")
public class FileMessageSet
extends MessageSet
implements Logging {
    private final File file;
    private final FileChannel channel;
    private final int start;
    private final int limit;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final boolean init$default$5() {
        return FileMessageSet$.MODULE$.init$default$5();
    }

    public static final int init$default$4() {
        return FileMessageSet$.MODULE$.init$default$4();
    }

    public static final int init$default$3() {
        return FileMessageSet$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int limit() {
        return this.limit;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int n, int n2) {
        return new FileMessageSet(this.file(), this.channel(), this.start() + n, package$.MODULE$.min(this.start() + n + n2, this.sizeInBytes()), false);
    }

    public OffsetPosition searchFor(long l, int n) {
        int n2 = n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int n3 = this._size().get();
        while (n2 + MessageSet$.MODULE$.LogOverhead() < n3) {
            byteBuffer.rewind();
            this.channel().read(byteBuffer, n2);
            if (byteBuffer.hasRemaining()) {
                throw new IllegalStateException(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToInteger((int)n), this.file().getAbsolutePath()})));
            }
            byteBuffer.rewind();
            long l2 = byteBuffer.getLong();
            if (l2 >= l) {
                return new OffsetPosition(l2, n2);
            }
            int n4 = byteBuffer.getInt();
            n2 += MessageSet$.MODULE$.LogOverhead() + n4;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel, long l, int n) {
        int n2 = package$.MODULE$.min((int)this.channel().size(), this.limit()) - this.start();
        if (n2 < this._size().get()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this._size().get()), BoxesRunTime.boxToInteger((int)n2)})));
        }
        int n3 = (int)this.channel().transferTo((long)this.start() + l, package$.MODULE$.min(n, this.sizeInBytes()), gatheringByteChannel);
        this.trace((Function0<String>)new Serializable(this, n, n3){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append((Object)BoxesRunTime.boxToInteger((int)this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
                this.size$1 = n;
                this.bytesTransferred$1 = n2;
            }
        });
        return n3;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return new IteratorTemplate<MessageAndOffset>(this){
            private int location;
            private final FileMessageSet $outer;

            private int location() {
                return this.location;
            }

            private void location_$eq(int n) {
                this.location = n;
            }

            public MessageAndOffset makeNext() {
                ByteBuffer byteBuffer = ByteBuffer.allocate(12);
                this.$outer.channel().read(byteBuffer, this.location());
                if (byteBuffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                byteBuffer.rewind();
                long l = byteBuffer.getLong();
                int n = byteBuffer.getInt();
                if (n < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
                this.$outer.channel().read(byteBuffer2, this.location() + 12);
                if (byteBuffer2.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                byteBuffer2.rewind();
                this.location_$eq(this.location() + (n + 12));
                return new MessageAndOffset(new Message(byteBuffer2), l);
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
                this.location = fileMessageSet.start();
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet byteBufferMessageSet) {
        int n = byteBufferMessageSet.writeTo(this.channel(), 0L, byteBufferMessageSet.sizeInBytes());
        this._size().getAndAdd(n);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().force(true);
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
            }
        });
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
            }
        });
        return this.file().delete();
    }

    public void truncateTo(int n) {
        if (n > this.sizeInBytes()) {
            throw new KafkaException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Attempt to truncate log segment to %d bytes failed since the current ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}))).append((Object)Predef$.MODULE$.augmentString(" size of this log segment is only %d bytes").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sizeInBytes())}))).toString());
        }
        this.channel().truncate(n);
        this.channel().position(n);
        this._size().set(n);
    }

    public FileMessageSet(File file, FileChannel fileChannel, int n, int n2, boolean bl) {
        Object object;
        this.file = file;
        this.channel = fileChannel;
        this.start = n;
        this.limit = n2;
        Logging$class.$init$(this);
        this._size = new AtomicInteger(package$.MODULE$.min((int)fileChannel.size(), n2) - n);
        if (bl) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final FileMessageSet $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Creating or reloading log segment %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath()}));
                }
                {
                    if (fileMessageSet == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = fileMessageSet;
                }
            });
            object = fileChannel.position(fileChannel.size());
        } else {
            object = BoxedUnit.UNIT;
        }
    }

    public FileMessageSet(File file, FileChannel fileChannel) {
        this(file, fileChannel, 0, Integer.MAX_VALUE, FileMessageSet$.MODULE$.init$default$5());
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }
}

