/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u000f\tAa)\u001b7f\u0019>\u001c7N\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001\u0003\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\b\u0019><w-\u001b8h!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011m\u0001!Q1A\u0005\u0002q\tAAZ5mKV\tQ\u0004\u0005\u0002\u001fC5\tqD\u0003\u0002!\u0019\u0005\u0011\u0011n\\\u0005\u0003E}\u0011AAR5mK\"AA\u0005\u0001B\u0001B\u0003%Q$A\u0003gS2,\u0007\u0005C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"!\u0005\u0001\t\u000bm)\u0003\u0019A\u000f\t\u000f-\u0002!\u0019!C\u0005Y\u000591\r[1o]\u0016dW#A\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001C2iC:tW\r\\:\u000b\u0005Ib\u0011a\u00018j_&\u0011Ag\f\u0002\f\r&dWm\u00115b]:,G\u000e\u0003\u00047\u0001\u0001\u0006I!L\u0001\tG\"\fgN\\3mA!9\u0001\b\u0001a\u0001\n\u0013I\u0014!\u00024m_\u000e\\W#\u0001\u001e\u0011\u00059Z\u0014BA\u00010\u0011\u001di\u0004\u00011A\u0005\ny\n\u0011B\u001a7pG.|F%Z9\u0015\u0005}\u0012\u0005CA\u000bA\u0013\t\teC\u0001\u0003V]&$\bbB\"=\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0004BB#\u0001A\u0003&!(\u0001\u0004gY>\u001c7\u000e\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0005Y>\u001c7\u000eF\u0001@\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u001d!(/\u001f'pG.$\u0012\u0001\u0014\t\u0003+5K!A\u0014\f\u0003\u000f\t{w\u000e\\3b]\")\u0001\u000b\u0001C\u0001\u0011\u00061QO\u001c7pG.DQA\u0015\u0001\u0005\u0002!\u000bq\u0001Z3tiJ|\u0017\u0010")
public class FileLock
implements Logging {
    private final File file;
    private final FileChannel channel;
    private java.nio.channels.FileLock flock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileLock fileLock = this;
        synchronized (fileLock) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private java.nio.channels.FileLock flock() {
        return this.flock;
    }

    private void flock_$eq(java.nio.channels.FileLock fileLock) {
        this.flock = fileLock;
    }

    public void lock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.trace((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final FileLock $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Acquiring lock on ").append((Object)this.$outer.file().getAbsolutePath()).toString();
                }
                {
                    if (fileLock == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = fileLock;
                }
            });
            this.flock_$eq(this.channel().lock());
            return;
        }
    }

    public boolean tryLock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.trace((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final FileLock $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Acquiring lock on ").append((Object)this.$outer.file().getAbsolutePath()).toString();
                }
                {
                    if (fileLock == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = fileLock;
                }
            });
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.liftedTree1$1());
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void unlock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            BoxedUnit boxedUnit;
            this.trace((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final FileLock $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Releasing lock on ").append((Object)this.$outer.file().getAbsolutePath()).toString();
                }
                {
                    if (fileLock == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = fileLock;
                }
            });
            if (this.flock() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.flock().release();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void destroy() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.unlock();
            this.channel().close();
            return;
        }
    }

    private final boolean liftedTree1$1() {
        boolean bl = false;
        try {
            this.flock_$eq(this.channel().tryLock());
            bl = this.flock() != null;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            bl = false;
        }
        return bl;
    }

    public FileLock(File file) {
        this.file = file;
        Logging$class.$init$(this);
        file.createNewFile();
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        this.flock = null;
    }
}

